/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa;

import io.meeds.notes.model.NoteFeaturedImage;
import io.meeds.notes.model.NoteMetadataObject;
import io.meeds.notes.model.NotePageProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.AttachmentEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.PermissionEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiPreferences;
import org.exoplatform.wiki.model.WikiPreferencesSyntax;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.utils.Utils;

public class EntityConverter {
    private static final Log LOG = ExoLogger.getLogger(EntityConverter.class);
    private static SpaceService spaceService;
    private static MetadataService metadataService;
    public static final MetadataType NOTES_METADATA_TYPE;
    public static final MetadataKey NOTES_METADATA_KEY;

    public static Wiki convertWikiEntityToWiki(WikiEntity wikiEntity) {
        Wiki wiki = null;
        if (wikiEntity != null) {
            wiki = new Wiki();
            wiki.setId(String.valueOf(wikiEntity.getId()));
            wiki.setType(wikiEntity.getType());
            wiki.setOwner(wikiEntity.getOwner());
            PageEntity wikiHomePageEntity = wikiEntity.getWikiHome();
            if (wikiHomePageEntity != null) {
                wiki.setWikiHome(EntityConverter.convertPageEntityToPage(wikiHomePageEntity));
            }
            wiki.setPermissions(EntityConverter.convertPermissionEntitiesToPermissionEntries(wikiEntity.getPermissions(), Arrays.asList(PermissionType.ADMINPAGE, PermissionType.ADMINSPACE)));
            WikiPreferences wikiPreferences = new WikiPreferences();
            WikiPreferencesSyntax wikiPreferencesSyntax = new WikiPreferencesSyntax();
            wikiPreferencesSyntax.setDefaultSyntax(wikiEntity.getSyntax());
            wikiPreferencesSyntax.setAllowMultipleSyntaxes(wikiEntity.isAllowMultipleSyntax());
            wikiPreferences.setWikiPreferencesSyntax(wikiPreferencesSyntax);
            wiki.setPreferences(wikiPreferences);
        }
        return wiki;
    }

    public static WikiEntity convertWikiToWikiEntity(Wiki wiki, WikiDAO wikiDAO) {
        WikiEntity wikiEntity = null;
        if (wiki != null) {
            WikiPreferencesSyntax wikiPreferencesSyntax;
            wikiEntity = new WikiEntity();
            wikiEntity.setType(wiki.getType());
            wikiEntity.setOwner(wiki.getOwner());
            wikiEntity.setWikiHome(EntityConverter.convertPageToPageEntity(wiki.getWikiHome(), wikiDAO));
            wikiEntity.setPermissions(EntityConverter.convertPermissionEntriesToPermissionEntities(wiki.getPermissions()));
            WikiPreferences wikiPreferences = wiki.getPreferences();
            if (wikiPreferences != null && (wikiPreferencesSyntax = wikiPreferences.getWikiPreferencesSyntax()) != null) {
                wikiEntity.setSyntax(wikiPreferencesSyntax.getDefaultSyntax());
                wikiEntity.setAllowMultipleSyntax(wikiPreferencesSyntax.isAllowMultipleSyntaxes());
            }
        }
        return wikiEntity;
    }

    public static Page convertPageEntityToPage(PageEntity pageEntity) {
        Page page = null;
        if (pageEntity != null) {
            page = new Page();
            page.setId(String.valueOf(pageEntity.getId()));
            page.setName(pageEntity.getName());
            WikiEntity wiki = pageEntity.getWiki();
            if (wiki != null) {
                page.setWikiId(String.valueOf(wiki.getId()));
                page.setWikiType(wiki.getType());
                page.setWikiOwner(wiki.getOwner());
            }
            if (pageEntity.getParentPage() != null) {
                page.setParentPageId(String.valueOf(pageEntity.getParentPage().getId()));
                page.setParentPageName(pageEntity.getParentPage().getName());
            }
            page.setTitle(pageEntity.getTitle());
            page.setOwner(pageEntity.getOwner());
            page.setAuthor(pageEntity.getAuthor());
            page.setContent(pageEntity.getContent());
            page.setSyntax(pageEntity.getSyntax());
            page.setCreatedDate(pageEntity.getCreatedDate());
            page.setUpdatedDate(pageEntity.getUpdatedDate());
            page.setMinorEdit(pageEntity.isMinorEdit());
            page.setComment(pageEntity.getComment());
            page.setPermissions(EntityConverter.convertPermissionEntitiesToPermissionEntries(pageEntity.getPermissions(), Arrays.asList(PermissionType.VIEWPAGE, PermissionType.EDITPAGE)));
            page.setActivityId(pageEntity.getActivityId());
            page.setDeleted(pageEntity.isDeleted());
            page.setUrl(Utils.getPageUrl(page));
            EntityConverter.buildNotePageMetadata(page, page.isDraftPage());
        }
        return page;
    }

    public static void buildNotePageMetadata(Page note, boolean isDraft) {
        if (note == null) {
            return;
        }
        Space space = EntityConverter.getSpaceService().getSpaceByGroupId(note.getWikiOwner());
        if (space != null) {
            Object noteId = note.getId();
            if (note.getLang() != null) {
                noteId = (String)noteId + "-" + note.getLang();
            }
            NoteMetadataObject noteMetadataObject = new NoteMetadataObject(isDraft ? "noteDraftPage" : "notePage", (String)noteId, note.getParentPageId(), Long.parseLong(space.getId()));
            EntityConverter.getMetadataService().getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)noteMetadataObject).stream().findFirst().ifPresent(metadataItem -> {
                if (!MapUtils.isEmpty((Map)metadataItem.getProperties())) {
                    EntityConverter.buildPageProperties(metadataItem.getProperties(), note);
                }
            });
        }
    }

    private static void buildPageProperties(Map<String, String> properties, Page note) {
        NotePageProperties notePageProperties = new NotePageProperties();
        NoteFeaturedImage noteFeaturedImage = new NoteFeaturedImage();
        notePageProperties.setNoteId(Long.parseLong(note.getId()));
        notePageProperties.setSummary(properties.get("summary"));
        noteFeaturedImage.setId(Long.valueOf(properties.getOrDefault("featuredImageId", "0")));
        noteFeaturedImage.setLastUpdated(Long.valueOf(properties.getOrDefault("featuredImageUpdatedDate", "0")));
        noteFeaturedImage.setAltText(properties.get("featuredImageAltText"));
        notePageProperties.setDraft(note.isDraftPage());
        notePageProperties.setFeaturedImage(noteFeaturedImage);
        note.setProperties(notePageProperties);
    }

    private static SpaceService getSpaceService() {
        if (spaceService == null) {
            spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return spaceService;
    }

    private static MetadataService getMetadataService() {
        if (metadataService == null) {
            metadataService = (MetadataService)CommonsUtils.getService(MetadataService.class);
        }
        return metadataService;
    }

    public static List<PermissionEntry> convertPermissionEntitiesToPermissionEntries(List<PermissionEntity> permissionEntities, List<PermissionType> filteredPermissionTypes) {
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        if (permissionEntities != null) {
            HashMap<String, PermissionEntry> permissionEntriesMap = new HashMap<String, PermissionEntry>();
            for (PermissionEntity permissionEntity : permissionEntities) {
                if (!filteredPermissionTypes.contains((Object)permissionEntity.getPermissionType())) continue;
                Permission newPermission = new Permission(permissionEntity.getPermissionType(), true);
                if (permissionEntriesMap.get(permissionEntity.getIdentity()) != null) {
                    PermissionEntry permissionEntry = (PermissionEntry)permissionEntriesMap.get(permissionEntity.getIdentity());
                    Object[] permissions = permissionEntry.getPermissions();
                    if (ArrayUtils.contains((Object[])permissions, (Object)newPermission)) continue;
                    permissionEntry.setPermissions((Permission[])ArrayUtils.add((Object[])permissions, (Object)newPermission));
                    permissionEntriesMap.put(permissionEntity.getIdentity(), permissionEntry);
                    continue;
                }
                permissionEntriesMap.put(permissionEntity.getIdentity(), new PermissionEntry(permissionEntity.getIdentity(), null, IDType.valueOf(permissionEntity.getIdentityType()), new Permission[]{newPermission}));
            }
            permissionEntries = new ArrayList(permissionEntriesMap.values());
            for (PermissionEntry permissionEntry : permissionEntries) {
                for (PermissionType permissionType : filteredPermissionTypes) {
                    boolean permissionTypeFound = false;
                    for (Permission permission : permissionEntry.getPermissions()) {
                        if (!permission.getPermissionType().equals((Object)permissionType)) continue;
                        permissionTypeFound = true;
                        break;
                    }
                    if (permissionTypeFound) continue;
                    Permission newPermission = new Permission(permissionType, false);
                    permissionEntry.setPermissions((Permission[])ArrayUtils.add((Object[])permissionEntry.getPermissions(), (Object)newPermission));
                }
            }
        }
        return permissionEntries;
    }

    public static PageEntity convertPageToPageEntity(Page page, WikiDAO wikiDAO) {
        PageEntity pageEntity = null;
        if (page != null) {
            WikiEntity wiki;
            pageEntity = new PageEntity();
            pageEntity.setName(page.getName());
            if (page.getWikiId() != null && (wiki = (WikiEntity)wikiDAO.find(Long.valueOf(Long.parseLong(page.getWikiId())))) != null) {
                pageEntity.setWiki(wiki);
            }
            pageEntity.setTitle(page.getTitle());
            pageEntity.setOwner(page.getOwner());
            pageEntity.setAuthor(page.getAuthor());
            pageEntity.setContent(page.getContent());
            pageEntity.setSyntax(page.getSyntax());
            pageEntity.setCreatedDate(page.getCreatedDate());
            pageEntity.setUpdatedDate(page.getUpdatedDate());
            pageEntity.setMinorEdit(page.isMinorEdit());
            pageEntity.setComment(page.getComment());
            pageEntity.setUrl(page.getUrl());
            pageEntity.setPermissions(EntityConverter.convertPermissionEntriesToPermissionEntities(page.getPermissions()));
            pageEntity.setActivityId(page.getActivityId());
        }
        return pageEntity;
    }

    public static List<PermissionEntity> convertPermissionEntriesToPermissionEntities(List<PermissionEntry> permissionEntries) {
        ArrayList<PermissionEntity> permissionEntities = null;
        if (permissionEntries != null) {
            permissionEntities = new ArrayList<PermissionEntity>();
            for (PermissionEntry permissionEntry : permissionEntries) {
                for (Permission permission : permissionEntry.getPermissions()) {
                    if (!permission.isAllowed()) continue;
                    permissionEntities.add(new PermissionEntity(permissionEntry.getId(), permissionEntry.getIdType().toString(), permission.getPermissionType()));
                }
            }
        }
        return permissionEntities;
    }

    public static Attachment convertAttachmentEntityToAttachment(FileService fileService, AttachmentEntity attachmentEntity, boolean loadContent) throws WikiException {
        Attachment attachment = null;
        FileItem fileItem = null;
        if (attachmentEntity != null) {
            attachment = new Attachment();
            attachment.setFullTitle(attachmentEntity.getFullTitle());
            if (attachmentEntity.getCreatedDate() != null) {
                Calendar createdDate = Calendar.getInstance();
                createdDate.setTime(attachmentEntity.getCreatedDate());
                attachment.setCreatedDate(createdDate);
            }
            try {
                if (loadContent) {
                    fileItem = fileService.getFile(attachmentEntity.getAttachmentFileID().longValue());
                } else {
                    FileInfo fileInfo = fileService.getFileInfo(attachmentEntity.getAttachmentFileID().longValue());
                    fileItem = new FileItem(fileInfo, null);
                }
            }
            catch (Exception e) {
                throw new WikiException("Cannot get attachment file ID " + attachmentEntity.getAttachmentFileID() + " from storage", e.getCause());
            }
            if (fileItem != null) {
                attachment.setName(fileItem.getFileInfo().getName());
                String fullTitle = attachment.getFullTitle();
                if (fullTitle != null && !StringUtils.isEmpty((CharSequence)fullTitle)) {
                    int index = fullTitle.lastIndexOf(".");
                    if (index != -1) {
                        attachment.setTitle(fullTitle.substring(0, index));
                    } else {
                        attachment.setTitle(fullTitle);
                    }
                }
                attachment.setContent(fileItem.getAsByte());
                attachment.setMimeType(fileItem.getFileInfo().getMimetype());
                attachment.setWeightInBytes(fileItem.getFileInfo().getSize());
                attachment.setCreator(fileItem.getFileInfo().getUpdater());
                if (fileItem.getFileInfo().getUpdatedDate() != null) {
                    Calendar updatedDate = Calendar.getInstance();
                    updatedDate.setTime(fileItem.getFileInfo().getUpdatedDate());
                    attachment.setUpdatedDate(updatedDate);
                }
            }
        }
        return attachment;
    }

    public static PageAttachmentEntity convertAttachmentToPageAttachmentEntity(FileService fileService, Attachment attachment) throws WikiException {
        PageAttachmentEntity attachmentEntity = null;
        FileItem fileItem = null;
        if (attachment != null) {
            try {
                Date updatedDate = attachment.getUpdatedDate() != null ? attachment.getUpdatedDate().getTime() : GregorianCalendar.getInstance().getTime();
                long size = 0L;
                if (attachment.getContent() != null) {
                    size = attachment.getContent().length;
                }
                fileItem = new FileItem(null, attachment.getName(), attachment.getMimeType(), "wiki", size, updatedDate, attachment.getCreator(), false, (InputStream)new ByteArrayInputStream(attachment.getContent()));
                fileItem = fileService.writeFile(fileItem);
            }
            catch (Exception ex) {
                throw new WikiException("Cannot persist page attachment file NAME " + attachment.getName() + " on file storage", ex.getCause());
            }
            attachmentEntity = new PageAttachmentEntity();
            attachmentEntity.setAttachmentFileID(fileItem.getFileInfo().getId());
            if (attachment.getFullTitle() == null) {
                attachmentEntity.setFullTitle(attachment.getName());
            } else {
                attachmentEntity.setFullTitle(attachment.getFullTitle());
            }
            if (attachment.getCreatedDate() != null) {
                attachmentEntity.setCreatedDate(attachment.getCreatedDate().getTime());
            }
        }
        return attachmentEntity;
    }

    public static DraftPageAttachmentEntity convertAttachmentToDraftPageAttachmentEntity(FileService fileService, Attachment attachment) throws WikiException {
        DraftPageAttachmentEntity attachmentEntity = null;
        FileItem fileItem = null;
        if (attachment != null) {
            try {
                Date updatedDate = attachment.getUpdatedDate() != null ? attachment.getUpdatedDate().getTime() : GregorianCalendar.getInstance().getTime();
                int size = 0;
                if (attachment.getContent() != null) {
                    size = attachment.getContent().length;
                }
                fileItem = new FileItem(null, attachment.getName(), attachment.getMimeType(), "wiki", (long)size, updatedDate, attachment.getCreator(), false, (InputStream)new ByteArrayInputStream(attachment.getContent()));
                fileItem = fileService.writeFile(fileItem);
            }
            catch (Exception ex) {
                throw new WikiException("Cannot persist draft attachment file NAME " + attachment.getName() + " on file storage", ex.getCause());
            }
            if (attachment.getUpdatedDate() == null) {
                attachment.setUpdatedDate(GregorianCalendar.getInstance());
            }
            attachmentEntity = new DraftPageAttachmentEntity();
            attachmentEntity.setAttachmentFileID(fileItem.getFileInfo().getId());
            if (attachment.getFullTitle() == null) {
                attachmentEntity.setFullTitle(attachment.getName());
            } else {
                attachmentEntity.setFullTitle(attachment.getFullTitle());
            }
            if (attachment.getCreatedDate() != null) {
                attachmentEntity.setCreatedDate(attachment.getCreatedDate().getTime());
            }
        }
        return attachmentEntity;
    }

    public static DraftPage convertDraftPageEntityToDraftPage(DraftPageEntity draftPageEntity) {
        DraftPage draftPage = null;
        if (draftPageEntity != null) {
            PageEntity parentPage;
            draftPage = new DraftPage();
            draftPage.setId(String.valueOf(draftPageEntity.getId()));
            draftPage.setName(draftPageEntity.getName());
            String title = draftPageEntity.getTitle();
            draftPage.setTitle(title != null ? title : "");
            draftPage.setAuthor(draftPageEntity.getAuthor());
            draftPage.setOwner(draftPageEntity.getAuthor());
            draftPage.setContent(draftPageEntity.getContent());
            draftPage.setLang(draftPageEntity.getLang());
            draftPage.setSyntax(draftPageEntity.getSyntax());
            draftPage.setCreatedDate(draftPageEntity.getCreatedDate());
            draftPage.setUpdatedDate(draftPageEntity.getUpdatedDate());
            draftPage.setNewPage(draftPageEntity.isNewPage());
            PageEntity targetPage = draftPageEntity.getTargetPage();
            if (targetPage != null) {
                draftPage.setTargetPageId(String.valueOf(targetPage.getId()));
                draftPage.setTargetPageRevision(draftPageEntity.getTargetRevision());
                WikiEntity wiki = targetPage.getWiki();
                if (wiki != null) {
                    draftPage.setWikiType(wiki.getType());
                    draftPage.setWikiOwner(wiki.getOwner());
                }
            }
            if ((parentPage = draftPageEntity.getParentPage()) != null) {
                draftPage.setParentPageId(String.valueOf(parentPage.getId()));
                draftPage.setParentPageName(parentPage.getName());
                if (StringUtils.isEmpty((CharSequence)draftPage.getWikiType()) || StringUtils.isEmpty((CharSequence)draftPage.getWikiOwner())) {
                    WikiEntity wiki = parentPage.getWiki();
                    draftPage.setWikiId(String.valueOf(wiki.getId()));
                    draftPage.setWikiOwner(parentPage.getWiki().getOwner());
                    draftPage.setWikiType(wiki.getType());
                }
            }
            EntityConverter.buildNotePageMetadata(draftPage, true);
        }
        return draftPage;
    }

    public static DraftPageEntity convertDraftPageToDraftPageEntity(DraftPage draftPage, PageDAO pageDAO) {
        DraftPageEntity draftPageEntity = null;
        if (draftPage != null) {
            String parentPageId;
            draftPageEntity = new DraftPageEntity();
            if (StringUtils.isNotEmpty((CharSequence)draftPage.getId())) {
                draftPageEntity.setId(Long.parseLong(draftPage.getId()));
            }
            draftPageEntity.setName(draftPage.getName());
            draftPageEntity.setTitle(draftPage.getTitle());
            draftPageEntity.setAuthor(draftPage.getAuthor());
            draftPageEntity.setContent(draftPage.getContent());
            draftPageEntity.setLang(draftPage.getLang());
            draftPageEntity.setSyntax(draftPage.getSyntax());
            draftPageEntity.setCreatedDate(draftPage.getCreatedDate());
            draftPageEntity.setUpdatedDate(draftPage.getUpdatedDate());
            draftPageEntity.setNewPage(draftPage.isNewPage());
            String targetPageId = draftPage.getTargetPageId();
            if (StringUtils.isNotEmpty((CharSequence)targetPageId)) {
                draftPageEntity.setTargetPage((PageEntity)pageDAO.find(Long.valueOf(targetPageId)));
            }
            if (StringUtils.isNotEmpty((CharSequence)(parentPageId = draftPage.getParentPageId()))) {
                draftPageEntity.setParentPage((PageEntity)pageDAO.find(Long.valueOf(parentPageId)));
            }
            draftPageEntity.setTargetRevision(draftPage.getTargetPageRevision());
            EntityConverter.buildNotePageMetadata(draftPage, true);
        }
        return draftPageEntity;
    }

    public static PageVersion convertPageVersionEntityToPageVersion(PageVersionEntity pageVersionEntity) {
        PageVersion pageVersion = null;
        if (pageVersionEntity != null) {
            pageVersion = new PageVersion();
            pageVersion.setId(String.valueOf(pageVersionEntity.getId()));
            pageVersion.setName(String.valueOf(pageVersionEntity.getVersionNumber()));
            pageVersion.setTitle(pageVersionEntity.getTitle());
            pageVersion.setAuthor(pageVersionEntity.getAuthor());
            pageVersion.setComment(pageVersionEntity.getComment());
            pageVersion.setContent(pageVersionEntity.getContent());
            pageVersion.setCreatedDate(pageVersionEntity.getCreatedDate());
            pageVersion.setUpdatedDate(pageVersionEntity.getUpdatedDate());
            pageVersion.setOwner(pageVersionEntity.getAuthor());
            pageVersion.setParent(EntityConverter.convertPageEntityToPage(pageVersionEntity.getPage()));
            pageVersion.setLang(pageVersionEntity.getLang());
            pageVersion.setWikiOwner(pageVersionEntity.getPage().getWiki().getOwner());
            EntityConverter.buildNotePageMetadata(pageVersion, pageVersion.isDraftPage());
        }
        return pageVersion;
    }

    public static PageHistory convertPageVersionEntityToPageHistory(PageVersionEntity pageVersionEntity) {
        PageHistory pageHistory = null;
        if (pageVersionEntity != null) {
            pageHistory = new PageHistory();
            pageHistory.setId(pageVersionEntity.getId());
            pageHistory.setVersionNumber(pageVersionEntity.getVersionNumber());
            pageHistory.setAuthor(pageVersionEntity.getAuthor());
            pageHistory.setContent(pageVersionEntity.getContent());
            pageHistory.setCreatedDate(pageVersionEntity.getCreatedDate());
            pageHistory.setUpdatedDate(pageVersionEntity.getUpdatedDate());
            pageHistory.setLang(pageVersionEntity.getLang());
        }
        return pageHistory;
    }

    public static PermissionEntry convertPermissionEntityToPermissionEntry(PermissionEntity permissionEntity) {
        PermissionEntry permissionEntry = null;
        if (permissionEntity != null) {
            permissionEntry = new PermissionEntry();
            permissionEntry.setId(permissionEntity.getIdentity());
            permissionEntry.setIdType(IDType.valueOf(permissionEntity.getIdentityType().toUpperCase()));
            permissionEntry.setPermissions(new Permission[]{new Permission(permissionEntity.getPermissionType(), true)});
        }
        return permissionEntry;
    }

    public static List<PageHistory> toPageHistoryVersions(List<PageVersionEntity> pageVersionEntities) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return pageVersionEntities.stream().map(EntityConverter::convertPageVersionEntityToPageHistory).peek(pageHistory -> {
            Identity identity = identityManager.getOrCreateIdentity("organization", pageHistory.getAuthor());
            if (identity != null && identity.getProfile() != null && identity.getProfile().getFullName() != null) {
                pageHistory.setAuthorFullName(identity.getProfile().getFullName());
            }
        }).toList();
    }

    public static List<DraftPage> toDraftPages(List<DraftPageEntity> draftPageEntities) {
        return draftPageEntities.stream().map(EntityConverter::convertDraftPageEntityToDraftPage).toList();
    }

    static {
        NOTES_METADATA_TYPE = new MetadataType(1001L, "notes");
        NOTES_METADATA_KEY = new MetadataKey(NOTES_METADATA_TYPE.getName(), "notes", 0L);
    }
}

