/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ActivityLifeCycle
extends AbstractLifeCycle<ActivityListener, ActivityLifeCycleEvent> {
    @Override
    protected void dispatchEvent(ActivityListener listener, ActivityLifeCycleEvent event) {
        switch (event.getType()) {
            case SAVE_ACTIVITY: {
                listener.saveActivity(event);
                break;
            }
            case UPDATE_ACTIVITY: {
                listener.updateActivity(event);
                break;
            }
            case SAVE_COMMENT: {
                listener.saveComment(event);
                break;
            }
            case UPDATE_COMMENT: {
                listener.updateComment(event);
                break;
            }
            case LIKE_ACTIVITY: {
                listener.likeActivity(event);
                break;
            }
            case DELETE_LIKE_ACTIVITY: {
                listener.deleteLikeActivity(event);
                break;
            }
            case LIKE_COMMENT: {
                listener.likeComment(event);
                break;
            }
            case DELETE_LIKE_COMMENT: {
                listener.deleteLikeComment(event);
                break;
            }
            case DELETE_COMMENT: {
                listener.deleteComment(event);
                break;
            }
            case DELETE_ACTIVITY: {
                listener.deleteActivity(event);
                break;
            }
            case SHARED_ACTIVITY: {
                listener.shareActivity(event);
                break;
            }
            case HIDE_ACTIVITY: {
                listener.hideActivity(event);
                break;
            }
            case PIN_ACTIVITY: {
                listener.pinActivity(event);
                break;
            }
            case UNPIN_ACTIVITY: {
                listener.unpinActivity(event);
            }
        }
    }

    public void saveActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.SAVE_ACTIVITY, activity));
    }

    public void updateActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UPDATE_ACTIVITY, activity));
    }

    public void saveComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.SAVE_COMMENT, activity));
    }

    public void updateComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UPDATE_COMMENT, activity));
    }

    public void likeActivity(ExoSocialActivity activity, String userIdentityId) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.LIKE_ACTIVITY, activity, userIdentityId));
    }

    public void likeComment(ExoSocialActivity activity, String userIdentityId) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.LIKE_COMMENT, activity, userIdentityId));
    }

    public void deleteLikeActivity(ExoSocialActivity activity, String userIdentityId) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.DELETE_LIKE_ACTIVITY, activity, userIdentityId));
    }

    public void deleteLikeComment(ExoSocialActivity activity, String userIdentityId) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.DELETE_LIKE_COMMENT, activity, userIdentityId));
    }

    public void deleteActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.DELETE_ACTIVITY, activity));
    }

    public void deleteComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.DELETE_COMMENT, activity));
    }

    public void shareActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.SHARED_ACTIVITY, activity));
    }

    public void hideActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.HIDE_ACTIVITY, activity));
    }

    public void pinActivity(ExoSocialActivity activity, String userIdentityId) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.PIN_ACTIVITY, activity, userIdentityId));
    }

    public void unpinActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UNPIN_ACTIVITY, activity));
    }
}

