/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wom.api.constant;

import io.meeds.wom.api.model.WomErrorMessage;

public class WomException
extends Exception {
    private static final long serialVersionUID = -31643228664080493L;
    private final boolean shouldRetry;
    private final int code;

    public WomException(String message) {
        super(message);
        this.shouldRetry = false;
        this.code = 0;
    }

    public WomException(String message, Exception e) {
        super(message, e);
        this.shouldRetry = false;
        this.code = 0;
    }

    public WomException(String message, boolean shouldRetry) {
        super(message);
        this.shouldRetry = shouldRetry;
        this.code = 0;
    }

    public WomException(String message, boolean shouldRetry, int code) {
        super(message);
        this.shouldRetry = shouldRetry;
        this.code = code;
    }

    public WomException(WomErrorMessage errorMessage) {
        super(errorMessage.getMessageKey());
        this.shouldRetry = errorMessage.isShouldRetry();
        this.code = errorMessage.getCode();
    }

    public WomException(WomErrorMessage errorMessage, Exception e) {
        super(errorMessage.getMessageKey(), e);
        this.shouldRetry = errorMessage.isShouldRetry();
        this.code = errorMessage.getCode();
    }

    public WomErrorMessage getErrorCode() {
        return new WomErrorMessage(this.code, this.shouldRetry, this.getMessage());
    }

    public boolean isShouldRetry() {
        return this.shouldRetry;
    }

    public int getCode() {
        return this.code;
    }
}

