/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch.graph.Connection;
import co.elastic.clients.elasticsearch.graph.Vertex;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ExploreResponse
implements JsonpSerializable {
    private final List<Connection> connections;
    private final List<ShardFailure> failures;
    private final boolean timedOut;
    private final long took;
    private final List<Vertex> vertices;
    public static final JsonpDeserializer<ExploreResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExploreResponse::setupExploreResponseDeserializer);

    private ExploreResponse(Builder builder) {
        this.connections = ApiTypeHelper.unmodifiableRequired(builder.connections, (Object)this, "connections");
        this.failures = ApiTypeHelper.unmodifiableRequired(builder.failures, (Object)this, "failures");
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, this, "timedOut");
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.vertices = ApiTypeHelper.unmodifiableRequired(builder.vertices, (Object)this, "vertices");
    }

    public static ExploreResponse of(Function<Builder, ObjectBuilder<ExploreResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Connection> connections() {
        return this.connections;
    }

    public final List<ShardFailure> failures() {
        return this.failures;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final long took() {
        return this.took;
    }

    public final List<Vertex> vertices() {
        return this.vertices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.connections)) {
            generator.writeKey("connections");
            generator.writeStartArray();
            for (Connection connection : this.connections) {
                connection.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure shardFailure : this.failures) {
                shardFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("took");
        generator.write(this.took);
        if (ApiTypeHelper.isDefined(this.vertices)) {
            generator.writeKey("vertices");
            generator.writeStartArray();
            for (Vertex vertex : this.vertices) {
                vertex.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupExploreResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connections, JsonpDeserializer.arrayDeserializer(Connection._DESERIALIZER), "connections");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::vertices, JsonpDeserializer.arrayDeserializer(Vertex._DESERIALIZER), "vertices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExploreResponse> {
        private List<Connection> connections;
        private List<ShardFailure> failures;
        private Boolean timedOut;
        private Long took;
        private List<Vertex> vertices;

        public final Builder connections(List<Connection> list) {
            this.connections = Builder._listAddAll(this.connections, list);
            return this;
        }

        public final Builder connections(Connection value, Connection ... values) {
            this.connections = Builder._listAdd(this.connections, value, values);
            return this;
        }

        public final Builder connections(Function<Connection.Builder, ObjectBuilder<Connection>> fn) {
            return this.connections(fn.apply(new Connection.Builder()).build(), new Connection[0]);
        }

        public final Builder failures(List<ShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(ShardFailure value, ShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build(), new ShardFailure[0]);
        }

        public final Builder timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder took(long value) {
            this.took = value;
            return this;
        }

        public final Builder vertices(List<Vertex> list) {
            this.vertices = Builder._listAddAll(this.vertices, list);
            return this;
        }

        public final Builder vertices(Vertex value, Vertex ... values) {
            this.vertices = Builder._listAdd(this.vertices, value, values);
            return this;
        }

        public final Builder vertices(Function<Vertex.Builder, ObjectBuilder<Vertex>> fn) {
            return this.vertices(fn.apply(new Vertex.Builder()).build(), new Vertex[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExploreResponse build() {
            this._checkSingleUse();
            return new ExploreResponse(this);
        }
    }
}

