/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.indices.IndexRouting;
import co.elastic.clients.elasticsearch.nodes.info.DeprecationIndexing;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsClusterElection;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoSettingsCluster
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final IndexRouting routing;
    private final NodeInfoSettingsClusterElection election;
    @Nullable
    private final String initialMasterNodes;
    @Nullable
    private final DeprecationIndexing deprecationIndexing;
    public static final JsonpDeserializer<NodeInfoSettingsCluster> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsCluster::setupNodeInfoSettingsClusterDeserializer);

    private NodeInfoSettingsCluster(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.routing = builder.routing;
        this.election = ApiTypeHelper.requireNonNull(builder.election, this, "election");
        this.initialMasterNodes = builder.initialMasterNodes;
        this.deprecationIndexing = builder.deprecationIndexing;
    }

    public static NodeInfoSettingsCluster of(Function<Builder, ObjectBuilder<NodeInfoSettingsCluster>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final IndexRouting routing() {
        return this.routing;
    }

    public final NodeInfoSettingsClusterElection election() {
        return this.election;
    }

    @Nullable
    public final String initialMasterNodes() {
        return this.initialMasterNodes;
    }

    @Nullable
    public final DeprecationIndexing deprecationIndexing() {
        return this.deprecationIndexing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.routing != null) {
            generator.writeKey("routing");
            this.routing.serialize(generator, mapper);
        }
        generator.writeKey("election");
        this.election.serialize(generator, mapper);
        if (this.initialMasterNodes != null) {
            generator.writeKey("initial_master_nodes");
            generator.write(this.initialMasterNodes);
        }
        if (this.deprecationIndexing != null) {
            generator.writeKey("deprecation_indexing");
            this.deprecationIndexing.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoSettingsClusterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::routing, IndexRouting._DESERIALIZER, "routing");
        op.add(Builder::election, NodeInfoSettingsClusterElection._DESERIALIZER, "election");
        op.add(Builder::initialMasterNodes, JsonpDeserializer.stringDeserializer(), "initial_master_nodes");
        op.add(Builder::deprecationIndexing, DeprecationIndexing._DESERIALIZER, "deprecation_indexing");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoSettingsCluster> {
        private String name;
        @Nullable
        private IndexRouting routing;
        private NodeInfoSettingsClusterElection election;
        @Nullable
        private String initialMasterNodes;
        @Nullable
        private DeprecationIndexing deprecationIndexing;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder routing(@Nullable IndexRouting value) {
            this.routing = value;
            return this;
        }

        public final Builder routing(Function<IndexRouting.Builder, ObjectBuilder<IndexRouting>> fn) {
            return this.routing(fn.apply(new IndexRouting.Builder()).build());
        }

        public final Builder election(NodeInfoSettingsClusterElection value) {
            this.election = value;
            return this;
        }

        public final Builder election(Function<NodeInfoSettingsClusterElection.Builder, ObjectBuilder<NodeInfoSettingsClusterElection>> fn) {
            return this.election(fn.apply(new NodeInfoSettingsClusterElection.Builder()).build());
        }

        public final Builder initialMasterNodes(@Nullable String value) {
            this.initialMasterNodes = value;
            return this;
        }

        public final Builder deprecationIndexing(@Nullable DeprecationIndexing value) {
            this.deprecationIndexing = value;
            return this;
        }

        public final Builder deprecationIndexing(Function<DeprecationIndexing.Builder, ObjectBuilder<DeprecationIndexing>> fn) {
            return this.deprecationIndexing(fn.apply(new DeprecationIndexing.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoSettingsCluster build() {
            this._checkSingleUse();
            return new NodeInfoSettingsCluster(this);
        }
    }
}

