/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.model;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import java.util.Map;
import java.util.Set;

public class RulePublication
extends RuleDTO {
    private static final long serialVersionUID = -7606132880459885724L;
    protected long spaceId;
    protected String message;
    protected Map<String, String> templateParams;
    protected boolean publish;

    public RulePublication(RuleDTO rule, long spaceId, String message, Map<String, String> templateParams, boolean publish) {
        super(rule.getId(), rule.getTitle(), rule.getDescription(), rule.getScore(), rule.getProgram(), rule.isEnabled(), rule.isDeleted(), rule.getCreatedBy(), rule.getCreatedDate(), rule.getLastModifiedBy(), rule.getEvent(), rule.getLastModifiedDate(), rule.getStartDate(), rule.getEndDate(), rule.getActivityId(), rule.getCacheTime(), rule.getPrerequisiteRuleIds(), rule.getType(), rule.getDefaultRealizationStatus(), rule.getRecurrence());
        this.spaceId = spaceId;
        this.message = message;
        this.templateParams = templateParams;
        this.publish = publish;
    }

    public RulePublication(Long id, String title, String description, int score, ProgramDTO program, boolean enabled, boolean deleted, String createdBy, String createdDate, String lastModifiedBy, EventDTO event, String lastModifiedDate, String startDate, String endDate, long activityId, long cacheTime, Set<Long> prerequisiteRuleIds, EntityType type, RealizationStatus defaultRealizationStatus, RecurrenceType recurrence, long spaceId, String message, Map<String, String> templateParams, boolean publish) {
        super(id, title, description, score, program, enabled, deleted, createdBy, createdDate, lastModifiedBy, event, lastModifiedDate, startDate, endDate, activityId, cacheTime, prerequisiteRuleIds, type, defaultRealizationStatus, recurrence);
        this.spaceId = spaceId;
        this.message = message;
        this.templateParams = templateParams;
        this.publish = publish;
    }

    @Override
    public RulePublication clone() {
        return new RulePublication(this.id, this.title, this.description, this.score, this.program, this.publish, this.publish, this.createdBy, this.createdDate, this.lastModifiedBy, this.event, this.lastModifiedDate, this.startDate, this.endDate, this.activityId, this.cacheTime, this.prerequisiteRuleIds, this.type, this.defaultRealizationStatus, this.recurrence, this.spaceId, this.message, this.templateParams, this.publish);
    }

    public RulePublication() {
    }

    public RulePublication(long spaceId, String message, Map<String, String> templateParams, boolean publish) {
        this.spaceId = spaceId;
        this.message = message;
        this.templateParams = templateParams;
        this.publish = publish;
    }

    @Override
    public long getSpaceId() {
        return this.spaceId;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setSpaceId(long spaceId) {
        this.spaceId = spaceId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTemplateParams(Map<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    @Override
    public String toString() {
        return "RulePublication(spaceId=" + this.getSpaceId() + ", message=" + this.getMessage() + ", templateParams=" + String.valueOf(this.getTemplateParams()) + ", publish=" + this.isPublish() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RulePublication)) {
            return false;
        }
        RulePublication other = (RulePublication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSpaceId() != other.getSpaceId()) {
            return false;
        }
        if (this.isPublish() != other.isPublish()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Map<String, String> this$templateParams = this.getTemplateParams();
        Map<String, String> other$templateParams = other.getTemplateParams();
        return !(this$templateParams == null ? other$templateParams != null : !((Object)this$templateParams).equals(other$templateParams));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RulePublication;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $spaceId = this.getSpaceId();
        result = result * 59 + (int)($spaceId >>> 32 ^ $spaceId);
        result = result * 59 + (this.isPublish() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Map<String, String> $templateParams = this.getTemplateParams();
        result = result * 59 + ($templateParams == null ? 43 : ((Object)$templateParams).hashCode());
        return result;
    }
}

