/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.EntityVisibility;
import io.meeds.gamification.model.ProgramColorAlreadyExists;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.utils.Utils;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ProgramServiceImpl
implements ProgramService {
    private static final String PROGRAM_DOESN_T_EXIST = "Program doesn't exist";
    protected final ProgramStorage programStorage;
    protected final ListenerService listenerService;
    protected final IdentityManager identityManager;
    protected final SpaceService spaceService;

    public ProgramServiceImpl(ProgramStorage programStorage, ListenerService listenerService, IdentityManager identityManager, SpaceService spaceService) {
        this.programStorage = programStorage;
        this.listenerService = listenerService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    @Override
    public List<ProgramDTO> getPrograms(ProgramFilter programFilter, String username, int offset, int limit) throws IllegalAccessException {
        List<Long> programIds = this.getProgramIds(programFilter, username, offset, limit);
        return programIds.stream().map(this::getProgramById).toList();
    }

    @Override
    public List<Long> getProgramIds(ProgramFilter programFilter, String username, int offset, int limit) throws IllegalAccessException {
        programFilter = this.computeUserSpaces(programFilter, username);
        return this.getProgramIds(programFilter, offset, limit);
    }

    @Override
    public List<Long> getProgramIds(ProgramFilter programFilter, int offset, int limit) {
        if (programFilter.isSortByBudget()) {
            return this.programStorage.findHighestBudgetProgramIdsBySpacesIds(programFilter, offset, limit);
        }
        return this.programStorage.getProgramIdsByFilter(programFilter, offset, limit);
    }

    @Override
    public List<Long> getOwnedProgramIds(String username, int offset, int limit) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return Collections.emptyList();
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        long userIdentityId = Long.parseLong(userIdentity.getId());
        ProgramFilter programFilter = this.computeOwnedProgramsFilter(userIdentity.getRemoteId(), userIdentityId);
        return this.getProgramIds(programFilter, offset, limit);
    }

    @Override
    public List<Long> getMemberProgramIds(String username, int offset, int limit) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return Collections.emptyList();
        }
        ProgramFilter programFilter = this.computeMemberProgramsFilter(username);
        return this.getProgramIds(programFilter, offset, limit);
    }

    @Override
    public List<Long> getPublicProgramIds(int offset, int limit) {
        ProgramFilter programFilter = new ProgramFilter();
        programFilter.setStatus(EntityStatusType.ENABLED);
        return this.getProgramIds(programFilter, offset, limit);
    }

    @Override
    public ProgramDTO getProgramByTitle(String programTitle) {
        if (StringUtils.isBlank((CharSequence)programTitle)) {
            throw new IllegalArgumentException("programTitle has to be not null");
        }
        return this.programStorage.getProgramByTitle(programTitle);
    }

    @Override
    public int countPrograms(ProgramFilter programFilter, String username) throws IllegalAccessException {
        programFilter = this.computeUserSpaces(programFilter, username);
        return this.countPrograms(programFilter);
    }

    @Override
    public int countPrograms(ProgramFilter programFilter) {
        return this.programStorage.countPrograms(programFilter);
    }

    @Override
    public int countOwnedPrograms(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return 0;
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        long userIdentityId = Long.parseLong(userIdentity.getId());
        ProgramFilter programFilter = this.computeOwnedProgramsFilter(userIdentity.getRemoteId(), userIdentityId);
        return this.countPrograms(programFilter);
    }

    @Override
    public int countMemberPrograms(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return 0;
        }
        ProgramFilter programFilter = this.computeMemberProgramsFilter(username);
        return this.countPrograms(programFilter);
    }

    @Override
    public int countPublicPrograms() {
        ProgramFilter programFilter = new ProgramFilter();
        programFilter.setStatus(EntityStatusType.ENABLED);
        return this.countPrograms(programFilter);
    }

    @Override
    public ProgramDTO createProgram(ProgramDTO program, Identity aclIdentity) throws IllegalAccessException {
        if (program == null) {
            throw new IllegalArgumentException("program is mandatory");
        }
        if (program.getId() != 0L) {
            throw new IllegalArgumentException("program id must be equal to 0");
        }
        if (program.isDeleted()) {
            throw new IllegalArgumentException("program to create can't be marked as deleted");
        }
        if (!this.canAddProgram(aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to create a program");
        }
        ProgramDTO createdProgram = this.createProgram(program, aclIdentity.getUserId());
        Utils.broadcastEvent(this.listenerService, "program.created", createdProgram, aclIdentity.getUserId());
        return createdProgram;
    }

    @Override
    public ProgramDTO createProgram(ProgramDTO program) {
        ProgramDTO createdProgram = this.createProgram(program, IdentityConstants.SYSTEM);
        Utils.broadcastEvent(this.listenerService, "program.created", createdProgram, null);
        return createdProgram;
    }

    @Override
    public ProgramDTO updateProgram(ProgramDTO program, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        if (aclIdentity == null) {
            throw new IllegalAccessException("Anonymous user can't update the program " + String.valueOf(program));
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(aclIdentity.getUserId());
        if (userIdentity == null || userIdentity.isDeleted() || !userIdentity.isEnable()) {
            throw new IllegalAccessException("Anonymous user can't update the program " + String.valueOf(program));
        }
        ProgramDTO storedProgram = this.programStorage.getProgramById(program.getId());
        if (storedProgram == null) {
            throw new ObjectNotFoundException(PROGRAM_DOESN_T_EXIST);
        }
        if (storedProgram.isDeleted()) {
            throw new ObjectNotFoundException("Program is marked as deleted");
        }
        if (!this.isProgramOwner(storedProgram.getId(), aclIdentity.getUserId())) {
            throw new IllegalAccessException("The user is not authorized to update the program where he's not owner" + String.valueOf(program));
        }
        if (program.getSpaceId() != storedProgram.getSpaceId() && !this.isProgramOwner(program.getSpaceId(), program.getOwnerIds(), program.isOpen(), userIdentity)) {
            throw new IllegalAccessException("The user is not authorized to update the program to an audience where he's not owner" + String.valueOf(program));
        }
        ProgramDTO programToSave = storedProgram.clone();
        programToSave.setLastModifiedBy(aclIdentity.getUserId());
        programToSave.setLastModifiedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        programToSave.setAvatarUploadId(program.getAvatarUploadId());
        programToSave.setCoverUploadId(program.getCoverUploadId());
        programToSave.setDescription(program.getDescription());
        programToSave.setTitle(program.getTitle());
        programToSave.setEnabled(program.isEnabled());
        programToSave.setOpen(program.isOpen());
        programToSave.setBudget(program.getBudget());
        programToSave.setOwnerIds(program.getOwnerIds());
        programToSave.setSpaceId(program.isOpen() ? 0L : program.getSpaceId());
        programToSave.setColor(program.getColor());
        return this.saveProgramAndBroadcast(programToSave, storedProgram, aclIdentity.getUserId());
    }

    @Override
    public ProgramDTO updateProgram(ProgramDTO program) throws ObjectNotFoundException {
        ProgramDTO storedProgram = this.programStorage.getProgramById(program.getId());
        if (storedProgram == null) {
            throw new ObjectNotFoundException(PROGRAM_DOESN_T_EXIST);
        }
        if (storedProgram.isDeleted()) {
            throw new ObjectNotFoundException("Program is marked as deleted");
        }
        if (program.isOpen()) {
            program.setSpaceId(0L);
        }
        return this.saveProgramAndBroadcast(program, storedProgram, null);
    }

    @Override
    public void updateProgramDate(long programId) {
        this.programStorage.updateProgramDate(programId);
    }

    @Override
    public ProgramDTO deleteProgramById(long programId, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(PROGRAM_DOESN_T_EXIST);
        }
        if (aclIdentity == null || !this.isProgramOwner(programId, aclIdentity.getUserId())) {
            throw new IllegalAccessException("The user is not authorized to delete the program");
        }
        program.setDeleted(true);
        program.setVisibility(EntityVisibility.RESTRICTED);
        program = this.programStorage.saveProgram(program);
        Utils.broadcastEvent(this.listenerService, "program.deleted", program, aclIdentity.getUserId());
        return program;
    }

    @Override
    public void deleteProgramCoverById(long programId, Identity aclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(PROGRAM_DOESN_T_EXIST);
        }
        if (aclIdentity == null || !this.isProgramOwner(programId, aclIdentity.getUserId())) {
            throw new IllegalAccessException("The user is not authorized to delete the program cover");
        }
        long coverFileId = program.getCoverFileId();
        if (coverFileId <= 0L) {
            throw new ObjectNotFoundException("program cover doesn't exist");
        }
        this.programStorage.deleteImage(coverFileId);
        program.setCoverFileId(0L);
        program = this.programStorage.saveProgram(program);
        Utils.broadcastEvent(this.listenerService, "program.updated", program, aclIdentity.getUserId());
    }

    @Override
    public void deleteProgramAvatarById(long programId, Identity aclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(PROGRAM_DOESN_T_EXIST);
        }
        if (aclIdentity == null || !this.isProgramOwner(programId, aclIdentity.getUserId())) {
            throw new IllegalAccessException("The user is not authorized to delete the program avatar");
        }
        long avatarFileId = program.getAvatarFileId();
        if (avatarFileId <= 0L) {
            throw new ObjectNotFoundException("program avatar doesn't exist");
        }
        this.programStorage.deleteImage(avatarFileId);
        program.setAvatarFileId(0L);
        program = this.programStorage.saveProgram(program);
        Utils.broadcastEvent(this.listenerService, "program.updated", program, aclIdentity.getUserId());
    }

    @Override
    public ProgramDTO getProgramById(long programId, String username) throws IllegalAccessException, ObjectNotFoundException {
        ProgramDTO program = this.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(PROGRAM_DOESN_T_EXIST);
        }
        if (program.isDeleted()) {
            Utils.broadcastEvent(this.listenerService, "program.deleted", program, username);
            throw new ObjectNotFoundException("Program has been deleted");
        }
        if (!this.canViewProgram(program, username)) {
            throw new IllegalAccessException("Program isn't accessible");
        }
        return program;
    }

    @Override
    public ProgramDTO getProgramById(long programId) {
        if (programId <= 0L) {
            throw new IllegalArgumentException("Program id is mandatory");
        }
        return this.programStorage.getProgramById(programId);
    }

    @Override
    public InputStream getProgramCoverStream(long programId) throws ObjectNotFoundException {
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(String.format("program with id %s doesn't exist", programId));
        }
        if (program.getCoverFileId() == 0L) {
            throw new ObjectNotFoundException(String.format("program with id %s doesn't have a coverId", programId));
        }
        return this.programStorage.getImageAsStream(program.getCoverFileId());
    }

    @Override
    public InputStream getProgramAvatarStream(long programId) throws ObjectNotFoundException {
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException("program with id " + programId + " doesn't exist");
        }
        if (program.getAvatarFileId() == 0L) {
            throw new ObjectNotFoundException("program with id " + programId + " doesn't have an avatarId");
        }
        return this.programStorage.getImageAsStream(program.getAvatarFileId());
    }

    @Override
    public boolean canAddProgram(Identity aclIdentity) {
        return aclIdentity != null && Utils.isRewardingManager(aclIdentity.getUserId());
    }

    @Override
    public boolean isProgramOwner(long programId, String username) {
        return this.isProgramOwner(programId, username, true);
    }

    @Override
    public boolean isProgramOwner(long programId, String username, boolean checkDeleted) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        if (userIdentity == null || userIdentity.isDeleted() || !userIdentity.isEnable()) {
            return false;
        }
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null || checkDeleted && program.isDeleted()) {
            return false;
        }
        return this.isProgramOwner(program.getSpaceId(), program.getOwnerIds(), program.isOpen(), userIdentity);
    }

    @Override
    public boolean isProgramMember(long programId, String username) {
        return this.isProgramMember(programId, username, true);
    }

    @Override
    public boolean isProgramMember(long programId, String username, boolean checkDeleted) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        if (userIdentity == null || userIdentity.isDeleted() || !userIdentity.isEnable()) {
            return false;
        }
        ProgramDTO program = this.programStorage.getProgramById(programId);
        if (program == null || checkDeleted && program.isDeleted()) {
            return false;
        }
        if (program.isOpen()) {
            return true;
        }
        return Utils.isRewardingManager(username) || this.isSpaceMember(program.getSpaceId(), username);
    }

    @Override
    public boolean canUseProgramColor(long programId, String color) {
        if (StringUtils.isBlank((CharSequence)color)) {
            return true;
        }
        ProgramDTO program = programId > 0L ? this.programStorage.getProgramById(programId) : null;
        return this.canUseProgramColor(color, program == null ? null : program.getColor());
    }

    @Override
    public boolean canViewProgram(long programId, String username) {
        ProgramDTO program = this.getProgramById(programId);
        return this.canViewProgram(program, username);
    }

    @Override
    public List<String> getAdministrators() {
        return this.programStorage.getAdministrators();
    }

    private boolean canViewProgram(ProgramDTO program, String username) {
        return program != null && (this.isProgramOwner(program.getId(), username) || program.getVisibility() == EntityVisibility.OPEN || this.isProgramMember(program.getId(), username, false));
    }

    private ProgramFilter computeUserSpaces(ProgramFilter programFilter, String username) throws IllegalAccessException {
        programFilter = programFilter.clone();
        if (Utils.isRewardingManager(username)) {
            programFilter.setOwnerId(0L);
            programFilter.setAllSpaces(true);
            return programFilter;
        }
        if (programFilter.getOwnerId() > 0L) {
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
            if (Long.parseLong(userIdentity.getId()) != programFilter.getOwnerId()) {
                throw new IllegalAccessException();
            }
            List managedSpaceIds = this.spaceService.getManagerSpacesIds(username, 0, -1).stream().map(Long::parseLong).toList();
            if (CollectionUtils.isEmpty(managedSpaceIds)) {
                programFilter.setSpacesIds(Collections.emptyList());
            } else {
                if (CollectionUtils.isNotEmpty(programFilter.getSpacesIds())) {
                    managedSpaceIds = (List)CollectionUtils.intersection(managedSpaceIds, programFilter.getSpacesIds());
                }
                programFilter.setSpacesIds(managedSpaceIds);
            }
        } else if (StringUtils.isNotBlank((CharSequence)username)) {
            List memberSpacesIds = this.spaceService.getMemberSpacesIds(username, 0, -1).stream().map(Long::parseLong).toList();
            if (CollectionUtils.isNotEmpty(programFilter.getSpacesIds())) {
                memberSpacesIds = (List)CollectionUtils.intersection(memberSpacesIds, programFilter.getSpacesIds());
            }
            programFilter.setSpacesIds(memberSpacesIds);
        }
        return programFilter;
    }

    private ProgramDTO createProgram(ProgramDTO program, String username) {
        boolean isAutomatic = StringUtils.isBlank((CharSequence)username) || StringUtils.equals((CharSequence)IdentityConstants.SYSTEM, (CharSequence)username);
        program.setType(isAutomatic ? EntityType.AUTOMATIC.name() : EntityType.MANUAL.name());
        program.setCreatedBy(username);
        program.setCreatedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        program.setLastModifiedBy(username);
        program.setLastModifiedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        if (program.isOpen()) {
            program.setSpaceId(0L);
        }
        program.setVisibility(this.isSpaceOpen(program.getSpaceId()) ? EntityVisibility.OPEN : EntityVisibility.RESTRICTED);
        this.checkProgramColorUnicity(program.getColor(), null);
        return this.programStorage.saveProgram(program);
    }

    private void checkProgramColorUnicity(String newColor, String storedColor) {
        if (StringUtils.isNotBlank((CharSequence)newColor) && !this.canUseProgramColor(newColor, storedColor)) {
            throw new ProgramColorAlreadyExists();
        }
    }

    private boolean canUseProgramColor(String newColor, String storedColor) {
        return StringUtils.equals((CharSequence)newColor, (CharSequence)storedColor) || !this.programStorage.isProgramColorExists(newColor);
    }

    private boolean isProgramOwner(long spaceId, Set<Long> ownerIds, boolean openProgram, org.exoplatform.social.core.identity.model.Identity userIdentity) {
        if (userIdentity == null || userIdentity.isDeleted() || !userIdentity.isEnable()) {
            return false;
        }
        String username = userIdentity.getRemoteId();
        if (Utils.isRewardingManager(username) || this.isSpaceManager(spaceId, username)) {
            return true;
        }
        return (openProgram || this.isSpaceMember(spaceId, username)) && ownerIds != null && ownerIds.contains(Long.parseLong(userIdentity.getId()));
    }

    private boolean isSpaceManager(long spaceId, String username) {
        if (this.spaceService.isSuperManager(username)) {
            return true;
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            return false;
        }
        return this.spaceService.isManager(space, username);
    }

    private boolean isSpaceMember(long spaceId, String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            return false;
        }
        return this.spaceService.isMember(space, username);
    }

    private boolean isSpaceOpen(long spaceId) {
        Space space = spaceId > 0L ? this.spaceService.getSpaceById(String.valueOf(spaceId)) : null;
        return space == null || "open".equals(space.getRegistration()) && !"hidden".equals(space.getVisibility());
    }

    private ProgramFilter computeOwnedProgramsFilter(String username, long userIdentityId) {
        ProgramFilter programFilter = new ProgramFilter();
        programFilter.setIncludeDeleted(true);
        if (Utils.isRewardingManager(username)) {
            programFilter.setAllSpaces(true);
        } else {
            programFilter.setOwnerId(userIdentityId);
            List managedSpaceIds = this.spaceService.getManagerSpacesIds(username, 0, -1);
            if (CollectionUtils.isEmpty((Collection)managedSpaceIds)) {
                programFilter.setSpacesIds(Collections.emptyList());
            } else {
                programFilter.setSpacesIds(managedSpaceIds.stream().map(Long::parseLong).toList());
            }
        }
        return programFilter;
    }

    private ProgramFilter computeMemberProgramsFilter(String username) {
        ProgramFilter programFilter = new ProgramFilter();
        programFilter.setIncludeDeleted(true);
        if (Utils.isRewardingManager(username)) {
            programFilter.setAllSpaces(true);
        } else {
            List memberSpaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
            if (CollectionUtils.isEmpty((Collection)memberSpaceIds)) {
                programFilter.setSpacesIds(Collections.emptyList());
            } else {
                programFilter.setSpacesIds(memberSpaceIds.stream().map(Long::parseLong).toList());
            }
        }
        return programFilter;
    }

    private ProgramDTO saveProgramAndBroadcast(ProgramDTO program, ProgramDTO storedProgram, String username) {
        this.checkProgramColorUnicity(program.getColor(), storedProgram.getColor());
        program.setVisibility(this.isSpaceOpen(program.getSpaceId()) ? EntityVisibility.OPEN : EntityVisibility.RESTRICTED);
        program = this.programStorage.saveProgram(program);
        if (storedProgram.isEnabled() && !program.isEnabled()) {
            Utils.broadcastEvent(this.listenerService, "program.disabled", program, username);
        } else if (!storedProgram.isEnabled() && program.isEnabled()) {
            Utils.broadcastEvent(this.listenerService, "program.enabled", program, username);
        }
        if (storedProgram.getSpaceId() != program.getSpaceId()) {
            Utils.broadcastEvent(this.listenerService, "program.audience.updated", program, storedProgram);
        }
        Utils.broadcastEvent(this.listenerService, "program.updated", program, username);
        return this.getProgramById(program.getId());
    }
}

