/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class ActionNonTxAware<R, A, E extends Exception> {
    protected static final Log LOG = ExoLogger.getLogger(ActionNonTxAware.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R run(A ... arg) throws E {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = null;
        try {
            if (tm != null) {
                try {
                    tx = tm.suspend();
                }
                catch (SystemException e) {
                    LOG.warn((Object)"Cannot suspend the current transaction", (Throwable)e);
                }
            }
            R r = this.execute((A)arg);
            return r;
        }
        finally {
            if (tx != null) {
                try {
                    tm.resume(tx);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Cannot resume the current transaction", (Throwable)e);
                }
            }
        }
    }

    public R run() throws E {
        return this.run(null);
    }

    protected R execute(A ... arg) throws E {
        if (arg == null || arg.length == 0) {
            return this.execute((A)null);
        }
        return this.execute(arg[0]);
    }

    protected R execute(A arg) throws E {
        return null;
    }

    protected abstract TransactionManager getTransactionManager();
}

