/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    public static class ChangeNodeActionListener
    extends EventListener<UIPortalApplication> {
        @Override
        public void execute(Event<UIPortalApplication> event) throws Exception {
            PortalRequestContext pcontext = PortalRequestContext.getCurrentInstance();
            UserPortal userPortal = pcontext.getUserPortalConfig().getUserPortal();
            UIPortalApplication uiPortalApp = event.getSource();
            UIPortal showedUIPortal = uiPortalApp.getCurrentSite();
            UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
            builder.withReadCheck();
            PageNodeEvent pageNodeEvent = (PageNodeEvent)event;
            String nodePath = pageNodeEvent.getTargetNodeUri();
            UserNode targetNode = null;
            SiteKey siteKey = pageNodeEvent.getSiteKey();
            if (siteKey != null) {
                NavigationService service;
                NavigationContext navContext;
                if (pcontext.getRemoteUser() == null && (siteKey.getType().equals((Object)SiteType.GROUP) || siteKey.getType().equals((Object)SiteType.USER)) && (navContext = (service = uiPortalApp.getApplicationComponent(NavigationService.class)).loadNavigation(siteKey)) != null) {
                    uiPortalApp.setLastRequestNavData(null);
                    pcontext.requestAuthenticationLogin();
                    return;
                }
                UserNavigation navigation = userPortal.getNavigation(siteKey);
                if (navigation != null && (targetNode = userPortal.resolvePath(navigation, builder.build(), nodePath)) == null) {
                    if (pcontext.getRemoteUser() == null && siteKey.getType().equals((Object)SiteType.PORTAL)) {
                        targetNode = userPortal.resolvePath(navigation, null, nodePath);
                        if (targetNode != null) {
                            uiPortalApp.setLastRequestNavData(null);
                            pcontext.requestAuthenticationLogin();
                            return;
                        }
                    } else {
                        targetNode = userPortal.getDefaultPath(navigation, builder.build());
                    }
                }
            }
            if (targetNode == null && (targetNode = userPortal.getDefaultPath(builder.build())) == null) {
                if (showedUIPortal != null) {
                    UIPageBody uiPageBody = showedUIPortal.findFirstComponentOfType(UIPageBody.class);
                    uiPageBody.setUIComponent(null);
                }
                return;
            }
            UserNode currentNavPath = null;
            if (showedUIPortal != null) {
                currentNavPath = showedUIPortal.getNavPath();
            }
            if (currentNavPath != null && currentNavPath.getNavigation().getKey().equals((Object)siteKey)) {
                if (!currentNavPath.getURI().equals(targetNode.getURI())) {
                    showedUIPortal.setNavPath(targetNode);
                }
            } else {
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                uiWorkingWS.setRenderedChild("UIViewWS");
                uiPortalApp.setModeState(0);
                showedUIPortal = uiPortalApp.getCachedUIPortal(siteKey);
                if (showedUIPortal != null) {
                    showedUIPortal.setNavPath(targetNode);
                    uiPortalApp.setCurrentSite(showedUIPortal);
                    PortalConfig associatedPortalConfig = pcontext.getDynamicPortalConfig();
                    UserPortalConfig userPortalConfig = pcontext.getUserPortalConfig();
                    userPortalConfig.setPortalConfig(associatedPortalConfig);
                } else {
                    showedUIPortal = this.buildUIPortal(uiPortalApp, pcontext);
                    if (showedUIPortal == null) {
                        return;
                    }
                    showedUIPortal.setNavPath(targetNode);
                    uiPortalApp.setCurrentSite(showedUIPortal);
                    uiPortalApp.putCachedUIPortal(showedUIPortal);
                }
            }
            showedUIPortal.refreshUIPage();
            pcontext.ignoreAJAXUpdateOnPortlets(!pcontext.useAjax());
        }

        private UIPortal buildUIPortal(UIPortalApplication uiPortalApp, PortalRequestContext pcontext) throws Exception {
            PortalConfig portalConfig = pcontext.getDynamicPortalConfig();
            Container layout = portalConfig.getPortalLayout();
            if (layout != null) {
                pcontext.getUserPortalConfig().setPortalConfig(portalConfig);
            }
            UIPortal uiPortal = uiPortalApp.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortalWithMetaLayout(uiPortal, pcontext.getDynamicPortalConfig());
            return uiPortal;
        }
    }
}

