/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class NavigationUtils {
    public static final Scope ECMS_NAVIGATION_SCOPE;
    private static ThreadLocal<Map<String, String>> gotNavigationKeeper;
    private static Constructor<UserNavigation> userNavigationCtor;
    private static final Log LOG;

    public static boolean gotNavigation(String portal, String user) {
        return NavigationUtils.gotNavigation(portal, user, "");
    }

    public static boolean gotNavigation(String portal, String user, String scope) {
        Map<String, String> navigations = gotNavigationKeeper.get();
        if (navigations == null) {
            return false;
        }
        String navigation = navigations.get(portal + " " + user + " " + scope);
        return navigation != null;
    }

    public static UserNavigation getUserNavigationOfPortal(UserPortal userPortal, String portalName) throws Exception {
        UserACL userACL = (UserACL)ExoContainerContext.getService(UserACL.class);
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        NavigationContext portalNav = userPortalConfigService.getNavigationService().loadNavigation(new SiteKey(SiteType.PORTAL, portalName));
        if (portalNav == null) {
            return null;
        }
        UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, ConversationState.getCurrent().getIdentity().getUserId());
        return userNavigationCtor.newInstance(userPortal, portalNav, userACL.hasEditPermission(userPortalCfg.getPortalConfig()));
    }

    public static UserNavigation getUserNavigation(UserPortal userPortal, SiteKey siteKey) throws Exception {
        if (siteKey.getTypeName().equalsIgnoreCase(SiteType.PORTAL.getName())) {
            return NavigationUtils.getUserNavigationOfPortal(userPortal, siteKey.getName());
        }
        UserACL userACL = (UserACL)ExoContainerContext.getService(UserACL.class);
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        NavigationContext portalNav = userPortalConfigService.getNavigationService().loadNavigation(siteKey);
        if (portalNav == null) {
            return null;
        }
        return userNavigationCtor.newInstance(userPortal, portalNav, userACL.hasEditPermissionOnNavigation(siteKey));
    }

    static {
        block2: {
            ECMS_NAVIGATION_SCOPE = Scope.CHILDREN;
            gotNavigationKeeper = new ThreadLocal();
            userNavigationCtor = null;
            LOG = ExoLogger.getLogger((String)NavigationUtils.class.getName());
            try {
                userNavigationCtor = UserNavigation.class.getDeclaredConstructor(UserPortalImpl.class, NavigationContext.class, Boolean.TYPE);
                userNavigationCtor.setAccessible(true);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
    }
}

