/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UISharedLayout;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplicationLifecycle;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIPortalApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl", events={@EventConfig(listeners={UIPageActionListener.ChangeNodeActionListener.class}, csrfCheck=false)})
public class UIPortalApplication
extends UIApplication {
    public static final String DEFAULT_MODE_PROPERTY = "gatein.portal.pageEditor.defaultEditMode";
    public static final String PORTAL_PORTLETS_SKIN_ID = "portalPortletSkins";
    public static final int NORMAL_MODE = 0;
    public static final int APP_BLOCK_EDIT_MODE = 1;
    public static final int APP_VIEW_EDIT_MODE = 2;
    public static final int CONTAINER_BLOCK_EDIT_MODE = 3;
    public static final int CONTAINER_VIEW_EDIT_MODE = 4;
    public static final UIComponent EMPTY_COMPONENT = new UIComponent(){

        @Override
        public String getId() {
            return "_portal:componentId_";
        }
    };
    public static final String UI_WORKING_WS_ID = "UIWorkingWorkspace";
    public static final String UI_VIEWING_WS_ID = "UIViewWS";
    public static final String UI_EDITTING_WS_ID = "UIEditInlineWS";
    public static final String UI_MASK_WS_ID = "UIMaskWorkspace";
    protected UIWorkingWorkspace uiWorkingWorkspace;
    private static EditMode defaultEditMode = null;
    private int modeState = 0;
    private EditLevel editLevel = EditLevel.NO_EDIT;
    private Orientation orientation_ = Orientation.LT;
    private SkinService skinService;
    private SkinVisitor skinVisitor;
    private LayoutService layoutService;
    private boolean isSessionOpen = false;
    private Map<SiteKey, UIPortal> all_UIPortals;
    private boolean isAjaxInLastRequest;
    private RequestNavigationData lastNonAjaxRequestNavData;
    private RequestNavigationData lastRequestNavData;
    private UIComponentDecorator uiViewWorkingWorkspace;
    private String lastPortal;
    private String lastPortalOwner;

    public static EditMode getDefaultEditMode() {
        if (defaultEditMode == null) {
            String val = PropertyManager.getProperty((String)DEFAULT_MODE_PROPERTY);
            if (val == null || val.length() == 0) {
                defaultEditMode = EditMode.BLOCK;
            } else {
                try {
                    defaultEditMode = EditMode.valueOf(val.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    StringBuilder msg = new StringBuilder().append("Ignoring illegal value '").append(val).append("' of ").append(DEFAULT_MODE_PROPERTY).append(" property in configuration.properties. One of [");
                    for (EditMode mode : EditMode.values()) {
                        if (msg.charAt(msg.length() - 1) != '[') {
                            msg.append(", ");
                        }
                        msg.append(mode.name());
                    }
                    msg.append("] is expected. Using default value '").append(EditMode.BLOCK.name()).append("'.");
                    log.warn((Object)msg.toString());
                    defaultEditMode = EditMode.BLOCK;
                }
            }
        }
        return defaultEditMode;
    }

    public UIPortalApplication() throws Exception {
        String localeName;
        LocaleConfig localeConfig;
        log = ExoLogger.getLogger((String)"portal:UIPortalApplication");
        PortalRequestContext context = PortalRequestContext.getCurrentInstance();
        this.skinService = this.getApplicationComponent(SkinService.class);
        this.skinVisitor = this.getApplicationComponent(SkinVisitor.class);
        this.layoutService = this.getApplicationComponent(LayoutService.class);
        LocaleConfigService localeConfigService = this.getApplicationComponent(LocaleConfigService.class);
        Locale locale = context.getLocale();
        if (locale == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No locale set on PortalRequestContext! Falling back to 'en'.");
            }
            locale = Locale.ENGLISH;
        }
        if ((localeConfig = localeConfigService.getLocaleConfig(localeName = LocaleContextInfo.getLocaleAsString((Locale)locale))) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported locale set on PortalRequestContext: " + localeName + "! Falling back to 'en'."));
            }
            localeConfig = localeConfigService.getLocaleConfig(Locale.ENGLISH.getLanguage());
        }
        this.setOrientation(localeConfig.getOrientation());
        context.setUIApplication(this);
        this.all_UIPortals = new HashMap<SiteKey, UIPortal>();
        this.lastPortalOwner = context.getPortalOwner();
        this.initWorkspaces();
    }

    public void setCurrentSite(UIPortal uiPortal) {
        PortalRequestContext.getCurrentInstance().setUiPortal(uiPortal);
        UISiteBody siteBody = this.findFirstComponentOfType(UISiteBody.class);
        if (siteBody != null) {
            siteBody.setUIComponent(uiPortal);
        }
    }

    public UIPortal getCurrentSite() {
        return PortalRequestContext.getCurrentInstance().getUiPortal();
    }

    public UIPortal getCachedUIPortal(String ownerType, String ownerId) {
        if (ownerType == null || ownerId == null) {
            return null;
        }
        return this.all_UIPortals.get(new SiteKey(ownerType, ownerId));
    }

    public UIPortal getCachedUIPortal(SiteKey key) {
        if (key == null) {
            return null;
        }
        return this.all_UIPortals.get(key);
    }

    public void putCachedUIPortal(UIPortal uiPortal) {
        SiteKey siteKey = uiPortal.getSiteKey();
        if (siteKey != null) {
            this.all_UIPortals.put(siteKey, uiPortal);
        }
    }

    public void removeCachedUIPortal(String ownerType, String ownerId) {
        if (ownerType == null || ownerId == null) {
            return;
        }
        this.all_UIPortals.remove(new SiteKey(ownerType, ownerId));
    }

    public void invalidateUIPage(String pageRef) {
        for (UIPortal tmp : this.all_UIPortals.values()) {
            tmp.clearUIPage(pageRef);
        }
    }

    public void refreshCachedUI() throws Exception {
        this.all_UIPortals.clear();
        UIPortal uiPortal = this.getCurrentSite();
        if (uiPortal != null) {
            SiteKey siteKey = uiPortal.getSiteKey();
            UIPortal tmp = null;
            PortalConfig portalConfig = Util.getPortalRequestContext().getDynamicPortalConfig();
            if (portalConfig != null) {
                PortalRequestContext pcontext;
                tmp = this.createUIComponent(UIPortal.class, null, null);
                PortalDataMapper.toUIPortalWithMetaLayout(tmp, portalConfig);
                this.putCachedUIPortal(tmp);
                tmp.setNavPath(uiPortal.getNavPath());
                tmp.refreshUIPage();
                this.setCurrentSite(tmp);
                if (SiteType.PORTAL.equals((Object)siteKey.getType()) && (pcontext = Util.getPortalRequestContext()) != null) {
                    UserPortalConfig userPortalConfig = pcontext.getUserPortalConfig();
                    userPortalConfig.setPortalConfig(portalConfig);
                }
            }
        }
    }

    public boolean isSessionOpen() {
        return this.isSessionOpen;
    }

    public void setSessionOpen(boolean isSessionOpen) {
        this.isSessionOpen = isSessionOpen;
    }

    public Orientation getOrientation() {
        return this.orientation_;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation_ = orientation;
    }

    public Locale getLocale() {
        return Util.getPortalRequestContext().getLocale();
    }

    public void setModeState(int mode) {
        this.modeState = mode;
        if (this.modeState == 0) {
            this.editLevel = EditLevel.NO_EDIT;
        }
    }

    public void setDefaultEditMode(ComponentTab componentTab, EditLevel editLevel) {
        this.editLevel = editLevel;
        EditMode editMode = UIPortalApplication.getDefaultEditMode();
        block0 : switch (componentTab.ordinal()) {
            case 0: {
                switch (editMode.ordinal()) {
                    case 0: {
                        this.modeState = 1;
                        break block0;
                    }
                    case 1: {
                        this.modeState = 2;
                        break block0;
                    }
                }
                log.warn((Object)("Ignoring unexpected " + EditMode.class.getName() + " value '" + editMode.name() + "' and using '" + EditMode.BLOCK.name() + "'."));
                break;
            }
            case 1: {
                switch (editMode.ordinal()) {
                    case 0: {
                        this.modeState = 3;
                        break block0;
                    }
                    case 1: {
                        this.modeState = 4;
                        break block0;
                    }
                }
                log.warn((Object)("Ignoring unexpected " + EditMode.class.getName() + " value '" + editMode.name() + "' and using '" + EditMode.BLOCK.name() + "'."));
                break;
            }
            default: {
                log.warn((Object)("Ignoring unexpected " + ComponentTab.class.getName() + " value '" + componentTab.name() + "' and using '" + ComponentTab.APPLICATIONS.name() + "'."));
                switch (editMode.ordinal()) {
                    case 0: {
                        this.modeState = 1;
                        break block0;
                    }
                    case 1: {
                        this.modeState = 2;
                        break block0;
                    }
                }
                log.warn((Object)("Ignoring unexpected " + EditMode.class.getName() + " value '" + editMode.name() + "' and using '" + EditMode.BLOCK.name() + "'."));
            }
        }
    }

    public int getModeState() {
        return this.modeState;
    }

    public void setLastRequestNavData(RequestNavigationData navData) {
        this.lastRequestNavData = navData;
    }

    public boolean isEditing() {
        return this.modeState != 0;
    }

    public Map<String, Boolean> getScripts() {
        PortalRequestContext prc = PortalRequestContext.getCurrentInstance();
        JavascriptManager jsMan = prc.getJavascriptManager();
        FetchMap requiredResources = jsMan.getScriptResources();
        log.debug("Resource ids to resolve: {}", new Object[]{requiredResources});
        JavascriptConfigService service = this.getApplicationComponent(JavascriptConfigService.class);
        LinkedHashMap<String, Boolean> ret = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Boolean> tmp = new LinkedHashMap<String, Boolean>();
        Map resolved = service.resolveIds((Map)requiredResources);
        for (ScriptResource rs : resolved.keySet()) {
            ResourceId id = rs.getId();
            if (ResourceScope.SHARED.equals((Object)id.getScope()) && "bootstrap".equals(id.getName())) {
                ret.put(id.toString(), false);
                continue;
            }
            boolean isRemote = !rs.isEmpty() && rs.getModules().get(0) instanceof Module.Remote;
            tmp.put(id.toString(), isRemote);
        }
        ret.putAll(tmp);
        for (String url : jsMan.getExtendedScriptURLs()) {
            ret.put(url, true);
        }
        log.debug((Object)("Resolved resources for page: " + String.valueOf(ret)));
        return ret;
    }

    public JSONObject getJSConfig() {
        return this.getApplicationComponent(JavascriptConfigService.class).getJSConfig();
    }

    public Collection<SkinConfig> getPortalSkins(SkinVisitor visitor) {
        if (visitor != null) {
            return this.skinService.findSkins(visitor);
        }
        return Collections.emptyList();
    }

    public Collection<SkinConfig> getPortalSkins() {
        String skin = this.getSkin();
        ArrayList<Object> skins = null;
        skins = this.skinVisitor == null ? new ArrayList(this.skinService.getPortalSkins(skin)) : new ArrayList<SkinConfig>(this.getPortalSkins(this.skinVisitor));
        SkinConfig skinConfig = this.skinService.getSkin(this.getCurrentSite().getName(), skin);
        if (skinConfig != null) {
            skins.add(skinConfig);
        }
        Collections.sort(skins, (s1, s2) -> s1.getCSSPriority() - s2.getCSSPriority());
        return skins;
    }

    public Collection<SkinConfig> getCustomSkins() {
        return this.skinService.getCustomPortalSkins(this.getSkin());
    }

    public String getBrandingUrl() {
        BrandingService brandingService = this.getApplicationComponent(BrandingService.class);
        long lastUpdatedTime = brandingService.getLastUpdatedTime();
        return "/" + PortalContainer.getCurrentPortalContainerName() + "/" + PortalContainer.getCurrentRestContextName() + "/v1/platform/branding/css?v=" + lastUpdatedTime;
    }

    public String getSkin() {
        return PortalRequestContext.getCurrentInstance().getSkin();
    }

    public Set<Skin> getPortletSkins() {
        String skin = this.getSkin();
        List<SkinConfig> portletSkins = this.getCurrentPortlets().stream().map(this::getPortletSkinConfig).filter(Objects::nonNull).toList();
        List<SkinConfig> additionalSkins = portletSkins.stream().filter(portletSkin -> {
            SkinConfig skinConfig;
            return portletSkin instanceof SkinConfig && CollectionUtils.isNotEmpty((Collection)(skinConfig = portletSkin).getAdditionalModules());
        }).map(SkinConfig::getAdditionalModules).flatMap(Collection::stream).distinct().map(module -> this.skinService.getPortalSkin(module, skin)).filter(Objects::nonNull).toList();
        return Stream.concat(portletSkins.stream(), additionalSkins.stream()).filter(Objects::nonNull).filter(c -> {
            SkinConfig skinConfig;
            return !(c instanceof SkinConfig) || (skinConfig = c).getCSSPath() != null;
        }).sorted((s1, s2) -> s1.getCSSPriority() - s2.getCSSPriority()).collect(Collectors.toSet());
    }

    public Set<String> getPortletNames() {
        return this.getPagePortletInfos().stream().map(ContainerPortletInfo::getName).collect(Collectors.toSet());
    }

    public Set<String> getPortletBundles() {
        return this.getInitParamsOfPagePortlets("preload.resource.bundles");
    }

    public Set<String> getPortletStylesheets() {
        return this.getInitParamsOfPagePortlets("preload.resource.stylesheet");
    }

    public Set<String> getInitParamsOfPagePortlets(String paramName) {
        List<ContainerPortletInfo> portletInfos = this.getPagePortletInfos();
        HashSet<String> result = new HashSet<String>();
        for (ContainerPortletInfo portletInfo : portletInfos) {
            String separator = portletInfo.getInitParameter("separator");
            String valuesString = portletInfo.getInitParameter(paramName);
            if (!StringUtils.isNotBlank((CharSequence)valuesString)) continue;
            String[] valuesArray = StringUtils.isBlank((CharSequence)separator) ? (valuesString.contains("|") ? StringUtils.split((String)valuesString, (char)'|') : StringUtils.split((String)valuesString, (char)',')) : StringUtils.split((String)valuesString, (String)separator);
            for (String value : valuesArray) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                result.add(value.trim());
            }
        }
        return result;
    }

    public List<ContainerPortletInfo> getPagePortletInfos() {
        return this.getCurrentPortlets().stream().filter(p -> p.getProducedOfferedPortlet() != null).map(pinfo -> pinfo.getProducedOfferedPortlet().getInfo()).filter(pinfo -> pinfo instanceof ContainerPortletInfo).map(p -> (ContainerPortletInfo)p).toList();
    }

    private SkinConfig getPortletSkinConfig(UIPortlet portlet) {
        String portletId = portlet.getSkinId();
        if (portletId != null) {
            return this.skinService.getSkin(portletId, this.getSkin());
        }
        return null;
    }

    private void initWorkspaces() throws Exception {
        if (this.getChildById(UI_WORKING_WS_ID) != null) {
            this.removeChildById(UI_WORKING_WS_ID);
        }
        this.uiWorkingWorkspace = this.addChild(UIWorkingWorkspace.class, UI_WORKING_WS_ID, null);
        this.uiViewWorkingWorkspace = this.uiWorkingWorkspace.addChild(UIComponentDecorator.class, null, UI_VIEWING_WS_ID);
        if (this.getChildById(UI_MASK_WS_ID) == null) {
            this.addChild(UIMaskWorkspace.class, UI_MASK_WS_ID, null);
        }
        this.initSharedLayout();
    }

    private void initSharedLayout() throws Exception {
        Container container = this.layoutService.getSharedLayout(this.lastPortalOwner);
        if (container != null) {
            UISharedLayout uiContainer = this.createUIComponent(UISharedLayout.class, null, null);
            uiContainer.setStorageId(container.getStorageId());
            PortalDataMapper.toUIContainer(uiContainer, container);
            uiContainer.setRendered(true);
            this.uiViewWorkingWorkspace.setUIComponent(uiContainer);
        }
        this.refreshCachedUI();
    }

    @Override
    public void processDecode(WebuiRequestContext context) throws Exception {
        UIPortal uiPortal;
        PortalRequestContext prc = (PortalRequestContext)context;
        String portalName = prc.getUserPortalConfig().getPortalName();
        if (!Safe.equals((Object)portalName, (Object)this.lastPortal)) {
            this.reloadPortalProperties();
            this.lastPortal = portalName;
        }
        if ((uiPortal = this.getCachedUIPortal(prc.getSiteKey())) != null) {
            this.setCurrentSite(uiPortal);
            uiPortal.refreshUIPage();
        }
        super.processDecode(context);
    }

    @Override
    public void processAction(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        RequestNavigationData requestNavData = pcontext.getNavigationData();
        boolean isAjax = pcontext.useAjax();
        if (!isAjax) {
            if (this.isAjaxInLastRequest) {
                this.isAjaxInLastRequest = false;
                if (requestNavData.equals(this.lastNonAjaxRequestNavData) && this.isRefreshPage(requestNavData) && pcontext.getPortletParameters().isEmpty()) {
                    NodeURL nodeURL = ((NodeURL)pcontext.createURL(NodeURL.TYPE)).setNode(this.getCurrentSite().getSelectedUserNode());
                    pcontext.sendRedirect(nodeURL.toString());
                    return;
                }
            }
            this.lastNonAjaxRequestNavData = requestNavData;
        }
        this.isAjaxInLastRequest = isAjax;
        if (this.isRefreshPage(requestNavData)) {
            if (!this.isDraftPage() && !this.isMaximizePortlet()) {
                this.lastRequestNavData = requestNavData;
            }
            StringBuilder js = new StringBuilder("eXo.env.server.portalBaseURL=\"");
            js.append(this.getBaseURL()).append("\";\n");
            String url = this.getPortalURLTemplate();
            js.append("eXo.env.server.portalURLTemplate=\"");
            js.append(url).append("\";");
            JavascriptManager javascriptManager = pcontext.getJavascriptManager();
            if (USE_WEBUI_RESOURCES) {
                javascriptManager.require("SHARED/base").addScripts(js.toString());
            } else {
                javascriptManager.addJavascript((CharSequence)js.toString());
            }
            SiteKey siteKey = pcontext.getSiteKey();
            PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(this, "ChangeNode", siteKey, pcontext.getNodePath());
            this.broadcast(pnevent, Event.Phase.PROCESS);
        }
        if (!isAjax) {
            this.lastNonAjaxRequestNavData = requestNavData;
        }
        if (pcontext.isResponseComplete()) {
            return;
        }
        if (this.getCurrentSite() == null || this.getCurrentSite().getSelectedUserNode() == null) {
            pcontext.sendError(404);
        }
        super.processAction(pcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        String maximizedPortletId = this.getMaximizedPortletId();
        if (StringUtils.isNotBlank((CharSequence)maximizedPortletId)) {
            UIPortlet maximizedUiPortlet = this.getCurrentPortlets().stream().filter(p -> StringUtils.equals((CharSequence)p.getStorageId(), (CharSequence)maximizedPortletId) || StringUtils.equals((CharSequence)p.getId(), (CharSequence)maximizedPortletId)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Portlet with id %s to maximize wasn't found in page with title '%s'", maximizedPortletId, this.getCurrentPage().getTitle())));
            UIPage uiPage = this.findFirstComponentOfType(UIPage.class);
            uiPage.normalizePortletWindowStates();
            uiPage.setMaximizedUIPortlet(maximizedUiPortlet);
        }
        try {
            PortalRequestContext pcontext = (PortalRequestContext)context;
            pcontext.setAttribute("requestStartTime", System.currentTimeMillis());
            if (!StringUtils.equals((CharSequence)this.lastPortalOwner, (CharSequence)pcontext.getPortalOwner())) {
                this.lastPortalOwner = pcontext.getPortalOwner();
                this.initWorkspaces();
            }
            JavascriptManager jsMan = context.getJavascriptManager();
            String portalOwner = pcontext.getPortalOwner();
            jsMan.loadScriptResource(ResourceScope.PORTAL, portalOwner);
            Writer w = context.getWriter();
            if (!context.useAjax()) {
                jsMan.loadScriptResource(ResourceScope.SHARED, "merged");
                jsMan.loadScriptResource(ResourceScope.SHARED, "bootstrap");
                super.processRender(context);
            } else {
                UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)this.getChildById(UI_MASK_WS_ID);
                if (uiMaskWS.isUpdated()) {
                    pcontext.addUIComponentToUpdateByAjax(uiMaskWS);
                }
                if (USE_WEBUI_RESOURCES && this.getUIPopupMessages().hasMessage()) {
                    pcontext.addUIComponentToUpdateByAjax(this.getUIPopupMessages());
                }
                Set<UIComponent> list = context.getUIComponentToUpdateByAjax();
                ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>(3);
                ArrayList<UIComponent> uiDataComponents = new ArrayList<UIComponent>(5);
                if (list != null) {
                    for (UIComponent uIComponent : list) {
                        if (uIComponent instanceof UIPortlet) {
                            uiPortlets.add((UIPortlet)uIComponent);
                            continue;
                        }
                        uiDataComponents.add(uIComponent);
                    }
                }
                w.write("<div class=\"PortalResponse\">");
                w.write("<div class=\"PortalResponseData\">");
                for (UIComponent uIComponent : uiDataComponents) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJAX call: Need to refresh the UI component " + uIComponent.getName()));
                    }
                    this.renderBlockToUpdate(uIComponent, context, w);
                }
                w.write("</div>");
                if (!context.getFullRender()) {
                    for (UIPortlet uIPortlet : uiPortlets) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("AJAX call: Need to refresh the Portlet " + uIPortlet.getId()));
                        }
                        w.write("<div class=\"PortletResponse\" style=\"display: none\">");
                        w.append("<div class=\"PortletResponsePortletId\">" + uIPortlet.getId() + "</div>");
                        w.append("<div class=\"PortletResponseData\">");
                        uIPortlet.processRender(context);
                        w.append("</div>");
                        w.append("<div class=\"PortletResponseScript\"></div>");
                        w.write("</div>");
                    }
                }
                w.write("<div class=\"MarkupHeadElements\">");
                List<String> headElems = ((PortalRequestContext)context).getExtraMarkupHeadersAsStrings();
                for (String elem : headElems) {
                    w.write(elem);
                }
                w.write("</div>");
                w.write("<div class=\"LoadingScripts\">");
                this.writeLoadingScripts(pcontext);
                w.write("</div>");
                w.write("<div class=\"PortalResponseScript\">");
                JavascriptManager javascriptManager = pcontext.getJavascriptManager();
                String skin = this.getAddSkinScript(pcontext.getControllerContext(), list);
                if (skin != null) {
                    javascriptManager.require("SHARED/skin", "skin").addScripts(skin);
                }
                w.write(javascriptManager.getJavaScripts());
                w.write("</div>");
                w.write("</div>");
            }
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)maximizedPortletId)) {
                UIPage uiPage = this.findFirstComponentOfType(UIPage.class);
                uiPage.setMaximizedUIPortlet(null);
                uiPage.normalizePortletWindowStates();
            }
        }
    }

    private void writeLoadingScripts(PortalRequestContext context) throws Exception {
        Writer w = context.getWriter();
        Map<String, Boolean> scriptURLs = this.getScripts();
        w.write("<div class=\"ImmediateScripts\">");
        w.write(StringUtils.join(scriptURLs.keySet(), (String)","));
        w.write("</div>");
    }

    private String getAddSkinScript(ControllerContext context, Set<UIComponent> updateComponents) {
        if (updateComponents == null) {
            return null;
        }
        ArrayList uiportlets = new ArrayList();
        for (UIComponent uIComponent : updateComponents) {
            UIComponentDecorator uiDecorator;
            if (uIComponent instanceof UIContainer) {
                UIContainer uiContainer = (UIContainer)uIComponent;
                uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
            }
            if (!(uIComponent instanceof UIComponentDecorator) || !((uiDecorator = (UIComponentDecorator)uIComponent).getUIComponent() instanceof UIContainer)) continue;
            UIContainer uiContainer = (UIContainer)uiDecorator.getUIComponent();
            uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
        }
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        for (UIPortlet uiPortlet : uiportlets) {
            SkinConfig skinConfig;
            String skinId = uiPortlet.getSkinId();
            if (skinId == null || (skinConfig = this.skinService.getSkin(skinId, this.getSkin())) == null) continue;
            skins.add(skinConfig);
        }
        StringBuilder stringBuilder = new StringBuilder(1000);
        for (SkinConfig ele : skins) {
            SkinURL url = ele.createURL(context);
            url.setOrientation(this.orientation_);
            stringBuilder.append("skin.addSkin('").append(ele.getId()).append("','").append(url).append("');\n");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public UserPortalConfig getUserPortalConfig() {
        return Util.getPortalRequestContext().getUserPortalConfig();
    }

    public void reloadPortalProperties() throws Exception {
        PortalRequestContext context = Util.getPortalRequestContext();
        context.refreshPortalConfig();
    }

    public String getUserHomePage() {
        PortalRequestContext context = Util.getPortalRequestContext();
        return this.getApplicationComponent(UserPortalConfigService.class).getUserHomePage(context.getRemoteUser());
    }

    public boolean isMenuSticky() {
        PortalRequestContext context = Util.getPortalRequestContext();
        if (StringUtils.isBlank((CharSequence)context.getRemoteUser())) {
            return false;
        }
        SettingValue stickySettingValue = this.getApplicationComponent(SettingService.class).get(Context.USER.id(context.getRemoteUser()), Scope.APPLICATION.id("HamburgerMenu"), "Sticky");
        return stickySettingValue == null ? Boolean.parseBoolean(System.getProperty("io.meeds.userPrefs.HamburgerMenu.sticky", "false")) : Boolean.parseBoolean(stickySettingValue.getValue().toString());
    }

    public String getPortalURLTemplate() throws UnsupportedEncodingException {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        ComponentURL urlTemplate = (ComponentURL)pcontext.createURL(ComponentURL.TYPE);
        urlTemplate.setMimeType(MimeType.PLAIN);
        urlTemplate.setPath(pcontext.getNodePath());
        urlTemplate.setResource(EMPTY_COMPONENT);
        urlTemplate.setAction("_portal:action_");
        return urlTemplate.toString();
    }

    public String getBaseURL() throws UnsupportedEncodingException {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        NodeURL nodeURL = (NodeURL)pcontext.createURL(NodeURL.TYPE, new NavigationResource(pcontext.getSiteKey(), pcontext.getNodePath()));
        return nodeURL.toString();
    }

    public EditLevel getEditLevel() {
        return this.editLevel;
    }

    public void setEditLevel(EditLevel editLevel) {
        this.editLevel = editLevel;
    }

    public EditMode getEditMode() {
        switch (this.modeState) {
            case 0: {
                return EditMode.NO_EDIT;
            }
            case 1: 
            case 3: {
                return EditMode.BLOCK;
            }
            case 2: 
            case 4: {
                return EditMode.PREVIEW;
            }
        }
        throw new IllegalStateException("Unexpected " + UIPortalApplication.class.getName() + ".modeState value " + this.modeState + ".");
    }

    public ComponentTab getComponentTab() {
        switch (this.modeState) {
            case 0: {
                return ComponentTab.NO_EDIT;
            }
            case 1: 
            case 2: {
                return ComponentTab.APPLICATIONS;
            }
            case 3: 
            case 4: {
                return ComponentTab.CONTAINERS;
            }
        }
        throw new IllegalStateException("Unexpected " + UIPortalApplication.class.getName() + ".modeState value " + this.modeState + ".");
    }

    public void includePortletScripts() {
        PortalRequestContext pcontext = PortalRequestContext.getCurrentInstance();
        JavascriptManager jsMan = pcontext.getJavascriptManager();
        ArrayList portlets = new ArrayList();
        this.uiViewWorkingWorkspace.findComponentOfType(portlets, UIPortlet.class);
        for (UIPortlet uiPortlet : portlets) {
            if (uiPortlet.isLazyResourcesLoading()) continue;
            try {
                jsMan.loadScriptResource(ResourceScope.PORTLET, uiPortlet.getApplicationId());
            }
            catch (Exception e) {
                log.warn("Can't load JS resource for portlet {}", new Object[]{uiPortlet.getName(), e});
            }
        }
    }

    public String getLastPortal() {
        return this.lastPortal;
    }

    public UIPage getCurrentPage() {
        return PortalRequestContext.getCurrentInstance().getUiPage();
    }

    public void setCurrentPage(UIPage currentPage) {
        PortalRequestContext.getCurrentInstance().setUiPage(currentPage);
    }

    private boolean isRefreshPage(RequestNavigationData requestNavData) {
        return !requestNavData.equals(this.lastRequestNavData) || this.getCurrentSite() == null || this.isDraftPage() || this.isMaximizePortlet();
    }

    private boolean isDraftPage() {
        return ((PortalRequestContext)RequestContext.getCurrentInstance()).isDraftPage();
    }

    public boolean isMaximizePortlet() {
        return StringUtils.isNotBlank((CharSequence)PortalRequestContext.getCurrentInstance().getMaximizedPortletId());
    }

    public String getMaximizedPortletId() {
        return PortalRequestContext.getCurrentInstance().getMaximizedPortletId();
    }

    private List<UIPortlet> getCurrentPortlets() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        List<UIPortlet> uiPortlets = requestContext.getUiPortlets();
        if (uiPortlets == null) {
            uiPortlets = new ArrayList<UIPortlet>();
            UISharedLayout sharedLayout = this.uiWorkingWorkspace.findFirstComponentOfType(UISharedLayout.class);
            if (sharedLayout == null || sharedLayout.isShowSharedLayout(requestContext)) {
                this.uiWorkingWorkspace.findComponentOfType(uiPortlets, UIPortlet.class);
            } else {
                UIPage currentPage = this.getCurrentPage();
                if (!requestContext.isMaximizePortlet() && !currentPage.isShowMaxWindow()) {
                    this.getCurrentSite().findComponentOfType(uiPortlets, UIPortlet.class);
                } else {
                    currentPage.findComponentOfType(uiPortlets, UIPortlet.class);
                }
            }
            requestContext.setUiPortlets(uiPortlets);
        }
        return uiPortlets;
    }

    public static enum EditMode {
        BLOCK,
        PREVIEW,
        NO_EDIT;

    }

    public static enum EditLevel {
        NO_EDIT,
        EDIT_SITE,
        EDIT_PAGE;

    }

    public static enum ComponentTab {
        APPLICATIONS,
        CONTAINERS,
        NO_EDIT;

    }
}

