/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputBase;

@ComponentConfig(template="system:/groovy/webui/form/UIUploadInput.gtmpl", events={@EventConfig(listeners={CreateUploadIdActionListener.class}), @EventConfig(listeners={RemoveUploadIdActionListener.class})})
public class UIUploadInput
extends UIFormInputBase<String> {
    private LinkedList<String> uploadIds = new LinkedList();
    private boolean dynamic = false;
    private Integer limitSize;
    private UploadService.UploadUnit limitUnit;

    public UIUploadInput(String name, String bindingExpression) {
        this(name, bindingExpression, 1);
    }

    public UIUploadInput(String name, String bindingExpression, int limitFile) {
        super(name, bindingExpression, String.class);
        if (limitFile < 1) {
            this.dynamic = true;
            limitFile = 1;
        }
        for (int i = 0; i < limitFile; ++i) {
            this.uploadIds.add(new StringBuffer().append(Math.abs(this.hashCode())).append('-').append(i).toString());
        }
        UploadService service = this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadIds.size(); ++i) {
            service.addUploadLimit(this.uploadIds.get(i), null);
        }
        this.setComponentConfig(UIUploadInput.class, null);
    }

    public UIUploadInput(String name, String bindingExpression, int limitFile, int limitSize) {
        this(name, bindingExpression, limitFile, limitSize, UploadService.UploadUnit.MB);
    }

    public UIUploadInput(String name, String bindingExpression, int limitFile, int limitSize, UploadService.UploadUnit unit) {
        super(name, bindingExpression, String.class);
        if (limitFile < 1) {
            this.dynamic = true;
            limitFile = 1;
        }
        this.limitUnit = unit;
        for (int i = 0; i < limitFile; ++i) {
            this.uploadIds.add(new StringBuffer().append(Math.abs(this.hashCode())).append('-').append(i).toString());
        }
        UploadService service = this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < limitFile; ++i) {
            service.addUploadLimit(this.uploadIds.get(i), Integer.valueOf(limitSize), unit);
        }
        this.setComponentConfig(UIUploadInput.class, null);
    }

    public String[] getUploadIds() {
        return this.uploadIds.toArray(new String[this.uploadIds.size()]);
    }

    public boolean isDynamicMode() {
        return this.dynamic;
    }

    public void addNewUploadId() {
        String lastedUploadId = this.uploadIds.getLast();
        String hash = lastedUploadId.substring(0, lastedUploadId.indexOf(45));
        int newIndex = Integer.valueOf(lastedUploadId.substring(hash.length() + 1)) + 1;
        String newUploadId = new StringBuffer().append(hash).append('-').append(newIndex).toString();
        this.uploadIds.addLast(newUploadId);
        UploadService service = this.getApplicationComponent(UploadService.class);
        service.addUploadLimit(newUploadId, this.limitSize, this.limitUnit);
    }

    public void removeUploadId(String uploadId) {
        this.uploadIds.remove(uploadId);
        UploadService service = this.getApplicationComponent(UploadService.class);
        service.removeUploadLimit(uploadId);
    }

    public UploadResource[] getUploadResources() {
        ArrayList<UploadResource> holder = new ArrayList<UploadResource>();
        UploadService service = this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadIds.size(); ++i) {
            UploadResource uploadResource = service.getUploadResource(this.uploadIds.get(i));
            if (uploadResource == null) continue;
            holder.add(uploadResource);
        }
        return holder.toArray(new UploadResource[holder.size()]);
    }

    public UploadResource getUploadResource(String uploadId) {
        UploadService service = this.getApplicationComponent(UploadService.class);
        return service.getUploadResource(uploadId);
    }

    public InputStream[] getUploadDataAsStreams() throws FileNotFoundException {
        ArrayList<FileInputStream> holder = new ArrayList<FileInputStream>();
        UploadService service = this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadIds.size(); ++i) {
            UploadResource uploadResource = service.getUploadResource(this.uploadIds.get(i));
            if (uploadResource == null) continue;
            File file = new File(uploadResource.getStoreLocation());
            holder.add(new FileInputStream(file));
        }
        return holder.toArray(new InputStream[holder.size()]);
    }

    public InputStream getUploadDataAsStream(String uploadId) throws FileNotFoundException {
        UploadService service = this.getApplicationComponent(UploadService.class);
        UploadResource uploadResource = service.getUploadResource(uploadId);
        if (uploadResource == null) {
            return null;
        }
        return new FileInputStream(new File(uploadResource.getStoreLocation()));
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
    }

    public static class RemoveUploadIdActionListener
    extends EventListener<UIUploadInput> {
        @Override
        public void execute(Event<UIUploadInput> event) throws Exception {
            UIUploadInput input = event.getSource();
            WebuiRequestContext context = event.getRequestContext();
            String uploadId = context.getRequestParameter("objectId");
            input.removeUploadId(uploadId);
            context.addUIComponentToUpdateByAjax(input);
        }
    }

    public static class CreateUploadIdActionListener
    extends EventListener<UIUploadInput> {
        @Override
        public void execute(Event<UIUploadInput> event) throws Exception {
            UIUploadInput input = event.getSource();
            input.addNewUploadId();
            event.getRequestContext().addUIComponentToUpdateByAjax(input);
        }
    }
}

