/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.management;

import java.util.Date;
import java.util.Locale;
import org.gatein.api.common.i18n.LocalizedString;
import org.gatein.api.management.GateInApiManagementResource;
import org.gatein.api.management.Utils;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.NodeVisitor;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.navigation.PublicationDate;
import org.gatein.api.navigation.Visibility;
import org.gatein.api.page.PageId;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.annotations.Managed;
import org.gatein.management.api.annotations.ManagedContext;
import org.gatein.management.api.annotations.ManagedOperation;
import org.gatein.management.api.annotations.ManagedRole;
import org.gatein.management.api.annotations.MappedAttribute;
import org.gatein.management.api.annotations.MappedPath;
import org.gatein.management.api.model.Model;
import org.gatein.management.api.model.ModelList;
import org.gatein.management.api.model.ModelNumber;
import org.gatein.management.api.model.ModelObject;
import org.gatein.management.api.model.ModelProvider;
import org.gatein.management.api.model.ModelReference;
import org.gatein.management.api.model.ModelString;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.api.operation.OperationContext;

@Managed
public class NavigationManagementResource {
    private final Navigation navigation;
    private final ModelProvider modelProvider;

    public NavigationManagementResource(Navigation navigation, ModelProvider modelProvider) {
        this.navigation = navigation;
        this.modelProvider = modelProvider;
    }

    @Managed
    public ModelObject getNavigation(@ManagedContext OperationContext context, @MappedAttribute(value="scope") String scopeAttribute, @MappedAttribute(value="showAll") String showAllAttribute) {
        boolean showAll;
        NodeVisitor visitor = Nodes.visitChildren();
        int scope = 0;
        if (scopeAttribute != null) {
            scope = Integer.parseInt(scopeAttribute);
            visitor = Nodes.visitNodes((int)scope);
        }
        Node node = this.getNode(NodePath.root(), true, visitor);
        boolean bl = showAll = showAllAttribute != null && Boolean.parseBoolean(showAllAttribute);
        if (!showAll || !context.getExternalContext().isUserInRole("administrators")) {
            node = node.filter().showDefault();
        }
        return this.populateNavigationModel(node, scope, context);
    }

    @Managed
    @ManagedOperation(name="update-resource", description="Updates the navigation")
    public ModelObject updateNavigation(@ManagedContext OperationContext context, @ManagedContext ModelObject navModel) {
        ModelNumber priority = Utils.get(navModel, ModelNumber.class, "priority");
        if (priority.isDefined()) {
            this.navigation.setPriority(priority.getInt());
        }
        Node node = this.getNode(NodePath.root(), true, Nodes.visitChildren());
        return this.populateNavigationModel(node, 0, context);
    }

    @Managed(value="{path: .*}")
    public ModelObject getNode(@MappedPath(value="path") String path, @MappedAttribute(value="scope") String scopeAttribute, @MappedAttribute(value="showAll") String showAllAttribute, @ManagedContext OperationContext context) {
        NodeVisitor visitor = Nodes.visitChildren();
        int scope = 0;
        if (scopeAttribute != null) {
            scope = Integer.parseInt(scopeAttribute);
            visitor = Nodes.visitNodes((int)scope);
        }
        Node node = this.getNode(path, true, visitor);
        boolean showAll = showAllAttribute != null && Boolean.parseBoolean(showAllAttribute);
        node = showAll && context.getExternalContext().isUserInRole("administrators") ? node.filter().showDefault() : node.filter().showDefault();
        ModelObject model = (ModelObject)this.modelProvider.newModel(ModelObject.class);
        this.populateNode(node, scope, model, context.getAddress());
        return model;
    }

    @Managed(value="{path: .*}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="remove-resource", description="Removes the navigation node")
    public void removeNode(@MappedPath(value="path") String path) {
        Node node = this.getNode(path, true);
        Node parent = node.getParent();
        parent.removeChild(node.getName());
        this.navigation.saveNode(parent);
    }

    @Managed(value="{path: .*}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="add-resource", description="Adds the navigation node")
    public ModelObject addNode(@MappedPath(value="path") String path, @ManagedContext PathAddress address) {
        String name;
        NodePath nodePath = NodePath.fromString((String)path);
        Node parent = this.getNode(nodePath.parent(), true, Nodes.visitChildren());
        if (parent.hasChild(name = nodePath.getLastSegment())) {
            throw Utils.alreadyExists("Cannot add node", this.navigation.getSiteId(), nodePath);
        }
        Node child = parent.addChild(name);
        this.navigation.saveNode(parent);
        ModelObject model = (ModelObject)this.modelProvider.newModel(ModelObject.class);
        this.populateNode(child, 0, model, address);
        return model;
    }

    @Managed(value="{path: .*}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="update-resource", description="Updates the navigation node")
    public ModelObject updateNode(@MappedPath(value="path") String path, @ManagedContext ModelObject nodeModel, @ManagedContext PathAddress address) {
        Node node = this.getNode(path, true);
        this.updateNodeFromModel(node, nodeModel);
        this.navigation.saveNode(node);
        ModelObject updateNodeModel = (ModelObject)this.modelProvider.newModel(ModelObject.class);
        this.populateNode(node, 0, updateNodeModel, address);
        return updateNodeModel;
    }

    private Node getNode(String pathString, boolean require) {
        return this.getNode(pathString, require, Nodes.visitNone());
    }

    private Node getNode(String pathString, boolean require, NodeVisitor visitor) {
        return this.getNode(NodePath.fromString((String)pathString), require, visitor);
    }

    private Node getNode(NodePath path, boolean require) {
        return this.getNode(path, require, Nodes.visitNone());
    }

    private Node getNode(NodePath path, boolean require, NodeVisitor visitor) {
        Node node = this.navigation.getNode(path, visitor);
        if (node == null && require) {
            throw Utils.notFound("Cannot retrieve node", this.navigation.getSiteId(), path);
        }
        return node;
    }

    private ModelObject populateNavigationModel(Node rootNode, int scope, OperationContext context) {
        ModelObject model = (ModelObject)this.modelProvider.newModel(ModelObject.class);
        PathAddress address = context.getAddress();
        model.set("priority", this.navigation.getPriority());
        model.set("siteType", this.navigation.getSiteId().getType().getName());
        model.set("siteName", this.navigation.getSiteId().getName());
        ModelList nodesModel = model.get("nodes").setEmptyList();
        if (rootNode.isChildrenLoaded()) {
            for (Node child : rootNode) {
                Model childModel = nodesModel.add();
                PathAddress childAddress = address.append(child.getName());
                if (scope > 0 || scope < 0) {
                    this.populateNode(child, scope - 1, childModel.setEmptyObject(), childAddress);
                    continue;
                }
                ModelReference nodeRef = childModel.set(childAddress);
                nodeRef.set("name", child.getName());
            }
        }
        return model;
    }

    private void populateNode(Node node, int scope, ModelObject model, PathAddress address) {
        model.set("name", node.getName());
        Utils.set("uri", node.getURI(), model);
        model.set("isVisible", node.isVisible());
        this.populateVisibility(node.getVisibility(), (ModelObject)model.get("visibility", ModelObject.class));
        model.set("iconName", node.getIconName());
        model.set("displayName", node.getDisplayName());
        Utils.populate("displayNames", node.getDisplayNames(), model);
        ModelList children = (ModelList)model.get("children", ModelList.class);
        if (node.isChildrenLoaded()) {
            for (Node child : node) {
                Model childModel = children.add();
                PathAddress childAddress = address.append(child.getName());
                if (scope > 0 || scope < 0) {
                    this.populateNode(child, scope - 1, childModel.setEmptyObject(), childAddress);
                    continue;
                }
                ModelReference nodeRef = childModel.set(childAddress);
                nodeRef.set("name", child.getName());
            }
        }
        ModelReference pageRef = (ModelReference)model.get("page").asValue(ModelReference.class);
        if (node.getPageId() != null) {
            PageId pageId = node.getPageId();
            pageRef.set("pageName", pageId.getPageName());
            pageRef.set("siteName", pageId.getSiteId().getName());
            pageRef.set("siteType", pageId.getSiteId().getType().getName());
            PathAddress pageAddress = GateInApiManagementResource.getPagesAddress(pageId.getSiteId()).append(pageId.getPageName());
            pageRef.set(pageAddress);
        }
    }

    private void populateVisibility(Visibility visibility, ModelObject model) {
        if (visibility != null) {
            Utils.set("status", visibility.getStatus(), model);
            if (visibility.getPublicationDate() != null) {
                ModelObject pubDateModel = (ModelObject)model.get("publication-date", ModelObject.class);
                Date start = visibility.getPublicationDate().getStart();
                Date end = visibility.getPublicationDate().getEnd();
                Utils.set("start", start, pubDateModel);
                Utils.set("end", end, pubDateModel);
            }
        }
    }

    private void updateNodeFromModel(Node node, ModelObject nodeModel) {
        Visibility visibility;
        if (nodeModel.has("name")) {
            node.setName(Utils.nonNullString(nodeModel, "name"));
        }
        if (nodeModel.has("visibility") && (visibility = NavigationManagementResource.getVisibility(nodeModel, node.getVisibility())) != null) {
            node.setVisibility(visibility);
        }
        if (nodeModel.has("iconName")) {
            String iconName = Utils.get(nodeModel, ModelString.class, "iconName").getValue();
            node.setIconName(iconName);
        }
        if (nodeModel.has("page")) {
            node.setPageId(NavigationManagementResource.getPageId(nodeModel));
        }
        if (nodeModel.has("displayNames")) {
            displayName = NavigationManagementResource.getDisplayNames(nodeModel);
            node.setDisplayNames(displayName);
        } else if (nodeModel.has("displayName")) {
            displayName = Utils.get(nodeModel, ModelString.class, "displayName").getValue();
            if (displayName == null) {
                throw Utils.invalidValue(null, "displayName");
            }
            node.setDisplayName((String)displayName);
        }
    }

    private static LocalizedString getDisplayNames(ModelObject nodeModel) {
        ModelList list = Utils.get(nodeModel, ModelList.class, "displayNames");
        if (!list.isDefined()) {
            throw Utils.invalidValue(null, "displayNames");
        }
        LocalizedString displayName = null;
        int i = 0;
        for (ModelValue mv : list) {
            ModelObject displayNameModel = (ModelObject)mv.asValue(ModelObject.class);
            if (!displayNameModel.has("value")) {
                throw Utils.requiredField("displayNames[" + i + "].value");
            }
            String value = Utils.get(displayNameModel, ModelString.class, "value").getValue();
            if (value == null) {
                throw Utils.invalidValue(value, "displayNames[" + i + "].value");
            }
            if (displayNameModel.has("lang")) {
                ModelString langModel = Utils.get(displayNameModel, ModelString.class, "lang");
                String lang = langModel.getValue();
                if (lang == null) {
                    throw Utils.invalidValue(lang, "displayNames[" + i + "].lang");
                }
                Locale locale = Utils.getLocale(displayNameModel, "lang");
                if (displayName == null) {
                    displayName = new LocalizedString(locale, value);
                    continue;
                }
                displayName.setLocalizedValue(locale, value);
                continue;
            }
            if (displayName == null) {
                displayName = new LocalizedString(value);
                continue;
            }
            throw Utils.invalidData("Cannot have multiple non localized values for displayNames", new String[0]);
        }
        return displayName;
    }

    private static PageId getPageId(ModelObject nodeModel) {
        ModelObject pageModel = Utils.get(nodeModel, ModelObject.class, "page");
        if (pageModel.isDefined()) {
            String pageName = Utils.nonNullString(nodeModel, "page", "pageName");
            String siteName = Utils.nonNullString(nodeModel, "page", "siteName");
            String siteTypeString = Utils.nonNullString(nodeModel, "page", "siteType");
            SiteType siteType = SiteType.forName((String)siteTypeString);
            if (siteType == null) {
                throw Utils.invalidValue(siteTypeString, "page", "siteType");
            }
            return new PageId(new SiteId(siteType, siteName), pageName);
        }
        return null;
    }

    private static Visibility getVisibility(ModelObject nodeModel, Visibility original) {
        Visibility.Status status = NavigationManagementResource.getStatus(nodeModel);
        if (status == Visibility.Status.PUBLICATION) {
            ModelObject pubDateModel = Utils.get(nodeModel, ModelObject.class, "visibility", "publication-date");
            if (!pubDateModel.isDefined()) {
                throw Utils.requiredFieldWhen("visibility status is " + String.valueOf(status), "visibility", "publication-date");
            }
            PublicationDate publicationDate = NavigationManagementResource.getPublicationDate(nodeModel, original.getPublicationDate());
            return new Visibility(publicationDate);
        }
        return new Visibility(status);
    }

    private static Visibility.Status getStatus(ModelObject nodeModel) {
        Visibility.Status status;
        String statusString = Utils.nonNullString(nodeModel, "visibility", "status");
        try {
            status = Visibility.Status.valueOf((String)statusString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw Utils.invalidValue(statusString, "visibility", "status");
        }
        return status;
    }

    private static PublicationDate getPublicationDate(ModelObject nodeModel, PublicationDate previous) {
        Date end;
        Date start;
        ModelString startModel = Utils.get(nodeModel, ModelString.class, "visibility", "publication-date", "start");
        Date date = start = previous == null ? null : previous.getStart();
        if (startModel.isDefined()) {
            start = Utils.getDate(nodeModel, "visibility", "publication-date", "start");
        }
        ModelString endModel = Utils.get(nodeModel, ModelString.class, "visibility", "publication-date", "end");
        Date date2 = end = previous == null ? null : previous.getEnd();
        if (endModel.isDefined()) {
            end = Utils.getDate(nodeModel, "visibility", "publication-date", "end");
        }
        if (start != null && end != null) {
            return PublicationDate.between((Date)start, (Date)end);
        }
        if (start == null && end != null) {
            return PublicationDate.endingOn((Date)end);
        }
        if (start != null) {
            return PublicationDate.startingOn((Date)start);
        }
        throw Utils.invalidData("Either 'start' or 'end' is required for visibility.publication-date", new String[0]);
    }
}

