/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.utils;

import io.meeds.news.model.News;
import io.meeds.notes.model.NoteFeaturedImage;
import io.meeds.notes.model.NotePageProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.wiki.model.DraftPage;

public class NewsUtils {
    private static final Log LOG = ExoLogger.getLogger(NewsUtils.class);
    public static final String POST_NEWS = "exo.news.postArticle";
    public static final String POST_NEWS_ARTICLE = "exo.news.gamification.postArticle";
    public static final String PUBLISH_NEWS = "exo.news.gamification.PublishArticle";
    public static final String VIEW_NEWS = "exo.news.viewArticle";
    public static final String SHARE_NEWS = "exo.news.shareArticle";
    public static final String COMMENT_NEWS = "exo.news.commentArticle";
    public static final String LIKE_NEWS = "exo.news.likeArticle";
    public static final String DELETE_NEWS = "exo.news.deleteArticle";
    public static final String UPDATE_NEWS = "exo.news.updateArticle";
    public static final String SCHEDULE_NEWS = "exo.news.scheduleArticle";
    public static final String UNSCHEDULE_NEWS = "exo.news.unscheduleArticle";
    public static final String NEWS_METADATA_OBJECT_TYPE = "news";
    public static final String DISPLAYED_STATUS = "displayed";
    public static final String TARGET_PERMISSIONS = "permissions";
    public static final String SPACE_NEWS_AUDIENCE = "space";
    public static final String ALL_NEWS_AUDIENCE = "all";
    public static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    public static final String MANAGER_MEMBERSHIP_NAME = "manager";
    public static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    public static final String ADD_ARTICLE_TRANSLATION = "content.add.article.translation";
    public static final String REMOVE_ARTICLE_TRANSLATION = "content.remove.article.translation";
    public static final String SHARE_CONTENT_ATTACHMENTS = "content.share.attachments";

    public static void broadcastEvent(String eventName, Object source, Object data) {
        try {
            ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error broadcasting event '" + eventName + "' using source '" + String.valueOf(source) + "' and data " + String.valueOf(data)), (Throwable)e);
        }
    }

    public static Set<String> processMentions(String content, Space space) {
        HashSet mentions = new HashSet();
        mentions.addAll(MentionUtils.getMentionedUsernames((String)content));
        if (space != null) {
            IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
            String spaceIdentityId = identityStorage.findIdentityId(SPACE_NEWS_AUDIENCE, space.getPrettyName());
            Set mentionedRoles = MentionUtils.getMentionedRoles((String)content, (String)spaceIdentityId);
            mentionedRoles.forEach(role -> {
                if (StringUtils.equals((CharSequence)"member", (CharSequence)role) && space.getMembers() != null) {
                    mentions.addAll(Arrays.asList(space.getMembers()));
                } else if (StringUtils.equals((CharSequence)MANAGER_MEMBERSHIP_NAME, (CharSequence)role) && space.getManagers() != null) {
                    mentions.addAll(Arrays.asList(space.getManagers()));
                } else if (StringUtils.equals((CharSequence)"redactor", (CharSequence)role) && space.getRedactors() != null) {
                    mentions.addAll(Arrays.asList(space.getRedactors()));
                } else if (StringUtils.equals((CharSequence)PUBLISHER_MEMBERSHIP_NAME, (CharSequence)role) && space.getPublishers() != null) {
                    mentions.addAll(Arrays.asList(space.getPublishers()));
                }
            });
        }
        return mentions.stream().map(remoteId -> {
            IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
            org.exoplatform.social.core.identity.model.Identity identity = identityStorage.findIdentity("organization", remoteId);
            return identity == null ? null : identity.getId();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static List<Long> getMyFilteredSpacesIds(Identity userIdentity, List<String> filteredSpacesIds) throws Exception {
        if (!CollectionUtils.isEmpty(filteredSpacesIds)) {
            return filteredSpacesIds.stream().map(Long::parseLong).toList();
        }
        return NewsUtils.getMySpaces(userIdentity).stream().map(space -> Long.valueOf(space.getId())).toList();
    }

    public static List<Long> getAllowedDraftArticleSpaceIds(Identity userIdentity, List<String> filteredSpacesIds) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        return NewsUtils.getMySpaces(userIdentity).stream().filter(space -> {
            boolean allowed;
            boolean bl = allowed = spaceService.canRedactOnSpace(space, userIdentity) || NewsUtils.canPublishNews(space.getId(), userIdentity);
            if (!CollectionUtils.isEmpty((Collection)filteredSpacesIds)) {
                return allowed && filteredSpacesIds.contains(space.getId());
            }
            return allowed;
        }).map(space -> Long.valueOf(space.getId())).toList();
    }

    public static List<Long> getAllowedScheduledNewsSpacesIds(Identity currentIdentity, List<String> filteredSpacesIds) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        return NewsUtils.getMySpaces(currentIdentity).stream().filter(space -> {
            boolean allowed;
            boolean bl = allowed = spaceService.isManager(space, currentIdentity.getUserId()) || spaceService.isRedactor(space, currentIdentity.getUserId()) || NewsUtils.canPublishNews(space.getId(), currentIdentity);
            if (!CollectionUtils.isEmpty((Collection)filteredSpacesIds)) {
                return allowed && filteredSpacesIds.contains(space.getId());
            }
            return allowed;
        }).map(space -> Long.valueOf(space.getId())).toList();
    }

    public static boolean canPublishNews(String spaceId, Identity currentIdentity) {
        if (!StringUtils.isBlank((CharSequence)spaceId)) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            return currentIdentity != null && space != null && (currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || spaceService.isPublisher(space, currentIdentity.getUserId()) || spaceService.isManager(space, currentIdentity.getUserId()) || spaceService.isSuperManager(currentIdentity.getUserId()));
        }
        return currentIdentity != null && currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    public static boolean canManageNewsPublishTargets(Identity currentIdentity) {
        return currentIdentity != null && currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, MANAGER_MEMBERSHIP_NAME);
    }

    public static Identity getUserIdentity(String username) {
        IdentityRegistry identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(username);
        if (identity != null) {
            return identity;
        }
        Authenticator authenticator = (Authenticator)ExoContainerContext.getService(Authenticator.class);
        try {
            identity = authenticator.createIdentity(username);
            if (identity != null) {
                identityRegistry.register(identity);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred while retrieving security identity of user " + username);
        }
        return identity;
    }

    public static String buildDraftUrl(DraftPage draftPage) {
        StringBuilder draftArticleUrl = new StringBuilder();
        draftArticleUrl.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(CommonsUtils.getCurrentPortalOwner()).append("/news-detail?newsId=").append(draftPage.getId()).append(draftPage.getTargetPageId() != null ? "&type=latest_draft" : "&type=draft");
        return draftArticleUrl.toString();
    }

    public static String buildNewsArticleUrl(News news, String currentUsername) throws SpaceException {
        StringBuilder newsArticleUrl = new StringBuilder();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (currentUsername != null && spaceService.isMember(news.getSpaceId(), currentUsername) && news.getActivityId() != null) {
            newsArticleUrl.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(CommonsUtils.getCurrentPortalOwner()).append("/activity?id=").append(news.getActivityId());
        } else {
            newsArticleUrl.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(CommonsUtils.getCurrentPortalOwner()).append("/news-detail?newsId=").append(news.getId()).append("&type=article");
        }
        if (news.getLang() != null) {
            newsArticleUrl.append("&lang=");
            newsArticleUrl.append(news.getLang());
        }
        return newsArticleUrl.toString();
    }

    public static String buildSpaceUrl(String spaceId) {
        StringBuilder spaceUrl = new StringBuilder();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(spaceId);
        if (space != null) {
            String spaceGroupId = space.getGroupId().split("/")[2];
            spaceUrl.append("/portal/g/:spaces:");
            spaceUrl.append(spaceGroupId);
            spaceUrl.append("/");
            spaceUrl.append(space.getPrettyName());
            return spaceUrl.toString();
        }
        return null;
    }

    public static String buildIllustrationUrl(NotePageProperties properties, String lang) {
        if (properties == null || properties.getFeaturedImage() == null || properties.getFeaturedImage().getId() == null || properties.getFeaturedImage().getId() == 0L) {
            return null;
        }
        NoteFeaturedImage featuredImage = properties.getFeaturedImage();
        StringBuilder illustrationUrl = new StringBuilder();
        illustrationUrl.append("/portal/rest/notes/illustration/");
        illustrationUrl.append(properties.getNoteId());
        illustrationUrl.append("?v=");
        illustrationUrl.append(featuredImage.getLastUpdated());
        illustrationUrl.append("&isDraft=");
        illustrationUrl.append(properties.isDraft());
        if (lang != null) {
            illustrationUrl.append("&lang=");
            illustrationUrl.append(lang);
        }
        return illustrationUrl.toString();
    }

    private static List<Space> getMySpaces(Identity userIdentity) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ListAccess memberSpacesListAccess = spaceService.getMemberSpaces(userIdentity.getUserId());
        return Arrays.asList((Space[])memberSpacesListAccess.load(0, memberSpacesListAccess.getSize()));
    }

    public static enum NewsUpdateType {
        CONTENT_AND_TITLE,
        SCHEDULE,
        POSTING_AND_PUBLISHING;

    }

    public static enum NewsObjectType {
        DRAFT,
        LATEST_DRAFT,
        ARTICLE;

    }
}

