/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.service;

import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import io.meeds.social.cms.storage.CMSStorage;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class CMSServiceImpl
implements CMSService {
    private static final Log LOG = ExoLogger.getLogger(CMSServiceImpl.class);
    private LayoutService layoutService;
    private SpaceService spaceService;
    private CMSStorage cmsStorage;
    private UserACL userACL;

    public CMSServiceImpl(LayoutService layoutService, SpaceService spaceService, CMSStorage cmsStorage, UserACL userACL) {
        this.layoutService = layoutService;
        this.spaceService = spaceService;
        this.cmsStorage = cmsStorage;
        this.userACL = userACL;
    }

    public CMSSetting getSetting(String type, String name) {
        return this.cmsStorage.getSetting(type, name);
    }

    public boolean hasAccessPermission(Identity identity, String type, String name) {
        CMSSetting setting = this.getSetting(type, name);
        return setting == null ? this.isContentManager(identity) : this.hasAccessPermission(identity, setting.getPageReference(), setting.getSpaceId());
    }

    public boolean hasAccessPermission(Identity identity, String pageReference, long spaceId) {
        String[] accessPermissions = this.getAccessPermissions(pageReference);
        return accessPermissions != null && accessPermissions.length > 0 && StringUtils.equals((CharSequence)"Everyone", (CharSequence)accessPermissions[0]) || identity != null && Arrays.stream(accessPermissions).anyMatch(perm -> this.userACL.hasPermission(identity, perm)) || this.hasEditPermission(identity, pageReference, spaceId);
    }

    public boolean hasEditPermission(Identity identity, String type, String name) {
        CMSSetting setting = this.getSetting(type, name);
        return setting == null ? this.isContentManager(identity) : this.hasEditPermission(identity, setting.getPageReference(), setting.getSpaceId());
    }

    public boolean hasEditPermission(Identity identity, String pageReference, long spaceId) {
        boolean hasEditPermission;
        if (identity == null || StringUtils.equals((CharSequence)identity.getUserId(), (CharSequence)IdentityConstants.ANONIM)) {
            return false;
        }
        String editPermission = this.getEditPermission(pageReference);
        boolean bl = hasEditPermission = this.isContentManager(identity) || editPermission != null && this.userACL.hasPermission(identity, editPermission);
        if (hasEditPermission || spaceId <= 0L) {
            return hasEditPermission;
        }
        String username = identity.getUserId();
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        return this.spaceService.isSuperManager(username) || space != null && (this.spaceService.isPublisher(space, username) || this.spaceService.isManager(space, username));
    }

    public void saveSettingName(String type, String name, String pageReference, long spaceId, long userCreatorId) throws ObjectAlreadyExistsException {
        if (StringUtils.isBlank((CharSequence)pageReference)) {
            throw new IllegalArgumentException("pageReference is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException("contentType is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is mandatory");
        }
        this.cmsStorage.saveSetting(type, name, pageReference, spaceId, userCreatorId);
    }

    public boolean isSettingNameExists(String type, String name) {
        return this.getSetting(type, name) != null;
    }

    private boolean isContentManager(Identity identity) {
        return identity.isMemberOf(this.userACL.getAdminGroups()) || identity.isMemberOf("/platform/web-contributors", "publisher");
    }

    private String[] getAccessPermissions(String pageReference) {
        Page page = this.layoutService.getPage(pageReference);
        return page == null ? new String[]{} : page.getAccessPermissions();
    }

    private String getEditPermission(String pageReference) {
        try {
            Page page = this.layoutService.getPage(pageReference);
            return page == null ? null : page.getEditPermission();
        }
        catch (Exception e) {
            LOG.warn("Error while getting page with reference {}", new Object[]{pageReference, e});
            return null;
        }
    }
}

