/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.storage;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.pwa.storage.PwaNotificationStorage$AjcClosure1;
import io.meeds.pwa.utils.VapidKeysUtils;
import io.micrometer.common.util.StringUtils;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PwaNotificationStorage {
    private static final Log LOG;
    private static final Context PWA_CONTEXT;
    private static final Scope PWA_VAPID_KEYS_SCOPE;
    private static final String PWA_VAPID_PUBLIC_KEY = "VAPID_PUBLIC_KEY";
    private static final String PWA_VAPID_PRIVATE_KEY = "VAPID_PRIVATE_KEY";
    @Autowired
    private SettingService settingService;
    @Autowired
    private CodecInitializer codecInitializer;
    @Value(value="${pwa.notifications.enabled:true}")
    private boolean enabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public PublicKey getVapidPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        String vapidPublicKeyString = this.getVapidPublicKeyString();
        if (StringUtils.isBlank((String)vapidPublicKeyString)) {
            this.generateVapidKeys();
            vapidPublicKeyString = this.getVapidPublicKeyString();
        }
        return VapidKeysUtils.decodePublicKey(vapidPublicKeyString);
    }

    public PrivateKey getVapidPrivateKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        String vapidPrivateKeyString = this.getVapidPrivateKeyString();
        if (StringUtils.isBlank((String)vapidPrivateKeyString)) {
            this.generateVapidKeys();
            vapidPrivateKeyString = this.getVapidPrivateKeyString();
        }
        return VapidKeysUtils.decodePrivateKey(vapidPrivateKeyString);
    }

    public String getVapidPublicKeyString() {
        return this.getValue(PWA_VAPID_KEYS_SCOPE, PWA_VAPID_PUBLIC_KEY);
    }

    @ContainerTransactional
    protected void generateVapidKeys() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PwaNotificationStorage$AjcClosure1 pwaNotificationStorage$AjcClosure1 = new PwaNotificationStorage$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(pwaNotificationStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private String getVapidPrivateKeyString() {
        return this.decrypt(this.getValue(PWA_VAPID_KEYS_SCOPE, PWA_VAPID_PRIVATE_KEY));
    }

    private void setVapidPublicKeyString(String publicKey) {
        this.setValue(PWA_VAPID_KEYS_SCOPE, PWA_VAPID_PUBLIC_KEY, publicKey);
    }

    private void setVapidPrivateKeyString(String privateKey) {
        this.setValue(PWA_VAPID_KEYS_SCOPE, PWA_VAPID_PRIVATE_KEY, this.crypt(privateKey));
    }

    private String getValue(Scope scope, String key) {
        return this.getValue(PWA_CONTEXT, scope, key);
    }

    private String getValue(Context context, Scope scope, String key) {
        SettingValue settingValue = this.settingService.get(context, scope, key);
        return settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
    }

    private void setValue(Scope scope, String key, String value) {
        this.setValue(PWA_CONTEXT, scope, key, value);
    }

    private void setValue(Context context, Scope scope, String key, String value) {
        this.settingService.set(context, scope, key, SettingValue.create((String)value));
    }

    private String crypt(String value) {
        return this.codecInitializer.getCodec().encode(value);
    }

    private String decrypt(String value) {
        if (value == null) {
            return null;
        }
        return this.codecInitializer.getCodec().decode(value);
    }

    static {
        PwaNotificationStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(PwaNotificationStorage.class);
        PWA_CONTEXT = Context.GLOBAL.id("PWA");
        PWA_VAPID_KEYS_SCOPE = Scope.APPLICATION.id("PWA_VAPID_KEYS");
    }

    static /* synthetic */ void generateVapidKeys_aroundBody0(PwaNotificationStorage ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.enabled) {
            return;
        }
        String publicKey = ajc$this.getVapidPublicKeyString();
        if (StringUtils.isBlank((String)publicKey)) {
            try {
                KeyPair keyPair = VapidKeysUtils.generateKeys();
                ajc$this.setVapidPublicKeyString(VapidKeysUtils.encode((ECPublicKey)keyPair.getPublic()));
                ajc$this.setVapidPrivateKeyString(VapidKeysUtils.encode((ECPrivateKey)keyPair.getPrivate()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while generating keys for Push Notifications, it will be disabled until resolving the error", (Throwable)e);
                ajc$this.enabled = false;
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PwaNotificationStorage.java", PwaNotificationStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "generateVapidKeys", "io.meeds.pwa.storage.PwaNotificationStorage", "", "", "", "void"), 94);
    }
}

