/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;

public class NotificationInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 689981271399587101L;
    public static final String PREFIX_ID = "NotificationMessage";
    public static final String FOR_ALL_USER = "&forAllUser";
    public static final String FOR_ALL_INTERNAL_USER = "&forAllInternalUsers";
    private String id;
    private PluginKey key;
    private String from;
    private String to;
    private int order;
    private Map<String, String> ownerParameter = new HashMap<String, String>();
    private List<String> sendToUserIds = new ArrayList<String>();
    private List<String> excludedUsersIds = new ArrayList<String>();
    private String[] sendToDaily = new String[]{""};
    private String[] sendToWeekly = new String[]{""};
    private long lastModifiedDate = System.currentTimeMillis();
    private String title = "";
    private ChannelKey channelKey;
    private Calendar dateCreated = Calendar.getInstance();
    private boolean isOnPopOver = true;
    private boolean read = false;
    private boolean resetOnBadge = false;
    private boolean isUpdate = false;
    private long spaceId = 0L;
    private boolean mutable = false;
    private boolean spaceMuted = false;

    public static NotificationInfo instance() {
        return new NotificationInfo();
    }

    public String getId() {
        return this.id;
    }

    public NotificationInfo setId(String id) {
        this.id = id;
        return this;
    }

    public NotificationInfo setSendAll(boolean isSendAll) {
        if (isSendAll) {
            this.setSendToDaily(new String[]{FOR_ALL_USER});
            this.setSendToWeekly(new String[]{FOR_ALL_USER});
        } else {
            this.removeOnSendToDaily(FOR_ALL_USER);
            this.removeOnSendToWeekly(FOR_ALL_USER);
        }
        return this;
    }

    public boolean isSendAll() {
        return ArrayUtils.contains((Object[])this.sendToDaily, (Object)FOR_ALL_USER) || ArrayUtils.contains((Object[])this.sendToWeekly, (Object)FOR_ALL_USER);
    }

    public boolean isSendAllInternals() {
        return ArrayUtils.contains((Object[])this.sendToDaily, (Object)FOR_ALL_INTERNAL_USER) || ArrayUtils.contains((Object[])this.sendToWeekly, (Object)FOR_ALL_INTERNAL_USER);
    }

    public NotificationInfo setSendAllInternals(boolean isSendAllInternals) {
        if (isSendAllInternals) {
            this.setSendToDaily(new String[]{FOR_ALL_INTERNAL_USER});
            this.setSendToWeekly(new String[]{FOR_ALL_INTERNAL_USER});
        } else {
            this.removeOnSendToDaily(FOR_ALL_INTERNAL_USER);
            this.removeOnSendToWeekly(FOR_ALL_INTERNAL_USER);
        }
        return this;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public NotificationInfo setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
        return this;
    }

    public PluginKey getKey() {
        return this.key;
    }

    public NotificationInfo key(PluginKey key) {
        this.key = key;
        return this;
    }

    public NotificationInfo key(String id) {
        this.key = PluginKey.key(id);
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public NotificationInfo setFrom(String from) {
        this.from = from;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public NotificationInfo setTitle(String title) {
        this.title = title;
        return this;
    }

    public ChannelKey getChannelKey() {
        return this.channelKey;
    }

    public void setChannelKey(ChannelKey channelKey) {
        this.channelKey = channelKey;
    }

    public String getTo() {
        return this.to;
    }

    public NotificationInfo setTo(String to) {
        this.to = to;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public NotificationInfo setOrder(int order) {
        this.order = order;
        return this;
    }

    public List<String> getSendToUserIds() {
        return this.sendToUserIds;
    }

    public NotificationInfo to(List<String> sendToUserIds) {
        this.sendToUserIds = sendToUserIds;
        return this;
    }

    public List<String> getExcludedUsersIds() {
        return this.excludedUsersIds;
    }

    public NotificationInfo to(String sendToUserId) {
        this.sendToUserIds.add(sendToUserId);
        if (this.to == null) {
            this.to = sendToUserId;
        }
        return this;
    }

    public NotificationInfo exclude(List<String> excludedUsersIds) {
        this.excludedUsersIds = excludedUsersIds;
        return this;
    }

    public NotificationInfo exclude(String excludedUserId) {
        this.excludedUsersIds.add(excludedUserId);
        return this;
    }

    public boolean isExcluded(String userId) {
        return this.excludedUsersIds.contains(userId);
    }

    public Map<String, String> getOwnerParameter() {
        return this.ownerParameter;
    }

    public String getValueOwnerParameter(String key) {
        return this.ownerParameter.get(key);
    }

    public long getSpaceId() {
        String spaceIdString;
        if (this.spaceId == 0L && StringUtils.isNotBlank((CharSequence)(spaceIdString = this.getValueOwnerParameter("spaceId"))) && StringUtils.isNumeric((CharSequence)spaceIdString)) {
            this.spaceId = Long.parseLong(spaceIdString);
        }
        return this.spaceId;
    }

    public NotificationInfo setSpaceId(long spaceId) {
        this.spaceId = spaceId;
        this.getOwnerParameter().put("spaceId", String.valueOf(spaceId));
        return this;
    }

    public String[] getArrayOwnerParameter() {
        if (this.ownerParameter.size() == 0) {
            return new String[]{""};
        }
        String[] strs = this.ownerParameter.toString().split(", ");
        strs[0] = strs[0].replace("{", "");
        strs[strs.length - 1] = strs[strs.length - 1].replace("}", "");
        return strs;
    }

    public NotificationInfo setOwnerParameter(Map<String, String> ownerParameter) {
        this.ownerParameter = ownerParameter;
        return this;
    }

    public NotificationInfo with(String key, String value) {
        this.ownerParameter.put(key, value);
        return this;
    }

    public NotificationInfo end() {
        return this;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public NotificationInfo setLastModifiedDate(Calendar lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate.getTimeInMillis();
        return this;
    }

    public NotificationInfo setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public Calendar getDateCreated() {
        return this.dateCreated;
    }

    public NotificationInfo setDateCreated(Calendar dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public boolean isOnPopOver() {
        return this.isOnPopOver;
    }

    public NotificationInfo setOnPopOver(boolean isOnPopOver) {
        this.isOnPopOver = isOnPopOver;
        return this;
    }

    public String[] getSendToDaily() {
        return this.sendToDaily;
    }

    public NotificationInfo setSendToDaily(String[] userIds) {
        this.sendToDaily = userIds;
        return this;
    }

    public NotificationInfo setSendToDaily(String userId) {
        this.sendToDaily = this.addMoreItemInArray(this.sendToDaily, userId);
        return this;
    }

    public NotificationInfo removeOnSendToDaily(String userId) {
        this.sendToDaily = this.removeItemInArray(this.sendToDaily, userId);
        return this;
    }

    public String[] getSendToWeekly() {
        return this.sendToWeekly;
    }

    public NotificationInfo setSendToWeekly(String[] userIds) {
        this.sendToWeekly = userIds;
        return this;
    }

    public NotificationInfo setSendToWeekly(String userId) {
        this.sendToWeekly = this.addMoreItemInArray(this.sendToWeekly, userId);
        return this;
    }

    public NotificationInfo removeOnSendToWeekly(String userId) {
        this.sendToWeekly = this.removeItemInArray(this.sendToWeekly, userId);
        return this;
    }

    public boolean isResetOnBadge() {
        return this.resetOnBadge;
    }

    public NotificationInfo setResetOnBadge(boolean resetOnBadge) {
        this.resetOnBadge = resetOnBadge;
        return this;
    }

    public boolean isRead() {
        return this.read;
    }

    public NotificationInfo setRead(boolean read) {
        this.read = read;
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("providerType: ").append(this.key).append(", sendToDaily: ").append(Arrays.asList(this.sendToDaily).toString()).append(", sendToWeekly: ").append(Arrays.asList(this.sendToWeekly).toString());
        return buffer.toString();
    }

    private String[] addMoreItemInArray(String[] src, String element) {
        if (element == null || element.trim().length() == 0) {
            return src;
        }
        ArrayList<Object> where = new ArrayList();
        if (src.length > 1 || src.length == 1 && !src[0].equals("")) {
            where = new ArrayList<String>(Arrays.asList(src));
        }
        if (!where.contains(element)) {
            where.add(element);
            return where.toArray(new String[where.size()]);
        }
        return src;
    }

    private String[] removeItemInArray(String[] src, String element) {
        if (element == null || element.trim().length() == 0) {
            return src;
        }
        ArrayList<Object> where = new ArrayList();
        if (src.length > 1 || src.length == 1 && !src[0].equals("")) {
            where = new ArrayList<String>(Arrays.asList(src));
        }
        if (where.contains(element)) {
            where.remove(element);
            return where.toArray(new String[where.size()]);
        }
        return src;
    }

    public NotificationInfo clone() {
        return this.clone(false);
    }

    public NotificationInfo clone(boolean isNew) {
        return new NotificationInfo(isNew ? null : this.id, this.key, this.from, this.to, this.order, new HashMap<String, String>(this.ownerParameter), this.sendToUserIds == null ? null : new ArrayList<String>(this.sendToUserIds), this.excludedUsersIds == null ? null : new ArrayList<String>(this.excludedUsersIds), this.arrayCopy(this.sendToDaily), this.arrayCopy(this.sendToWeekly), this.lastModifiedDate, this.title, this.channelKey, this.dateCreated, isNew || this.isOnPopOver, !isNew && this.read, !isNew && this.resetOnBadge, !isNew, this.spaceId, this.mutable, this.spaceMuted);
    }

    private String[] arrayCopy(String[] source) {
        String[] stringArray;
        if (source != null && source.length > 0) {
            stringArray = Arrays.asList(source).toArray(new String[source.length]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        return stringArray;
    }

    public NotificationInfo(String id, PluginKey key, String from, String to, int order, Map<String, String> ownerParameter, List<String> sendToUserIds, List<String> excludedUsersIds, String[] sendToDaily, String[] sendToWeekly, long lastModifiedDate, String title, ChannelKey channelKey, Calendar dateCreated, boolean isOnPopOver, boolean read, boolean resetOnBadge, boolean isUpdate, long spaceId, boolean mutable, boolean spaceMuted) {
        this.id = id;
        this.key = key;
        this.from = from;
        this.to = to;
        this.order = order;
        this.ownerParameter = ownerParameter;
        this.sendToUserIds = sendToUserIds;
        this.excludedUsersIds = excludedUsersIds;
        this.sendToDaily = sendToDaily;
        this.sendToWeekly = sendToWeekly;
        this.lastModifiedDate = lastModifiedDate;
        this.title = title;
        this.channelKey = channelKey;
        this.dateCreated = dateCreated;
        this.isOnPopOver = isOnPopOver;
        this.read = read;
        this.resetOnBadge = resetOnBadge;
        this.isUpdate = isUpdate;
        this.spaceId = spaceId;
        this.mutable = mutable;
        this.spaceMuted = spaceMuted;
    }

    public NotificationInfo() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationInfo)) {
            return false;
        }
        NotificationInfo other = (NotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.getLastModifiedDate() != other.getLastModifiedDate()) {
            return false;
        }
        if (this.isOnPopOver() != other.isOnPopOver()) {
            return false;
        }
        if (this.isRead() != other.isRead()) {
            return false;
        }
        if (this.isResetOnBadge() != other.isResetOnBadge()) {
            return false;
        }
        if (this.isUpdate() != other.isUpdate()) {
            return false;
        }
        if (this.getSpaceId() != other.getSpaceId()) {
            return false;
        }
        if (this.isMutable() != other.isMutable()) {
            return false;
        }
        if (this.isSpaceMuted() != other.isSpaceMuted()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PluginKey this$key = this.getKey();
        PluginKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Map<String, String> this$ownerParameter = this.getOwnerParameter();
        Map<String, String> other$ownerParameter = other.getOwnerParameter();
        if (this$ownerParameter == null ? other$ownerParameter != null : !((Object)this$ownerParameter).equals(other$ownerParameter)) {
            return false;
        }
        List<String> this$sendToUserIds = this.getSendToUserIds();
        List<String> other$sendToUserIds = other.getSendToUserIds();
        if (this$sendToUserIds == null ? other$sendToUserIds != null : !((Object)this$sendToUserIds).equals(other$sendToUserIds)) {
            return false;
        }
        List<String> this$excludedUsersIds = this.getExcludedUsersIds();
        List<String> other$excludedUsersIds = other.getExcludedUsersIds();
        if (this$excludedUsersIds == null ? other$excludedUsersIds != null : !((Object)this$excludedUsersIds).equals(other$excludedUsersIds)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSendToDaily(), other.getSendToDaily())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSendToWeekly(), other.getSendToWeekly())) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        ChannelKey this$channelKey = this.getChannelKey();
        ChannelKey other$channelKey = other.getChannelKey();
        if (this$channelKey == null ? other$channelKey != null : !((Object)this$channelKey).equals(other$channelKey)) {
            return false;
        }
        Calendar this$dateCreated = this.getDateCreated();
        Calendar other$dateCreated = other.getDateCreated();
        return !(this$dateCreated == null ? other$dateCreated != null : !((Object)this$dateCreated).equals(other$dateCreated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        long $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + (int)($lastModifiedDate >>> 32 ^ $lastModifiedDate);
        result = result * 59 + (this.isOnPopOver() ? 79 : 97);
        result = result * 59 + (this.isRead() ? 79 : 97);
        result = result * 59 + (this.isResetOnBadge() ? 79 : 97);
        result = result * 59 + (this.isUpdate() ? 79 : 97);
        long $spaceId = this.getSpaceId();
        result = result * 59 + (int)($spaceId >>> 32 ^ $spaceId);
        result = result * 59 + (this.isMutable() ? 79 : 97);
        result = result * 59 + (this.isSpaceMuted() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PluginKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Map<String, String> $ownerParameter = this.getOwnerParameter();
        result = result * 59 + ($ownerParameter == null ? 43 : ((Object)$ownerParameter).hashCode());
        List<String> $sendToUserIds = this.getSendToUserIds();
        result = result * 59 + ($sendToUserIds == null ? 43 : ((Object)$sendToUserIds).hashCode());
        List<String> $excludedUsersIds = this.getExcludedUsersIds();
        result = result * 59 + ($excludedUsersIds == null ? 43 : ((Object)$excludedUsersIds).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSendToDaily());
        result = result * 59 + Arrays.deepHashCode(this.getSendToWeekly());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        ChannelKey $channelKey = this.getChannelKey();
        result = result * 59 + ($channelKey == null ? 43 : ((Object)$channelKey).hashCode());
        Calendar $dateCreated = this.getDateCreated();
        result = result * 59 + ($dateCreated == null ? 43 : ((Object)$dateCreated).hashCode());
        return result;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isSpaceMuted() {
        return this.spaceMuted;
    }

    public void setSpaceMuted(boolean spaceMuted) {
        this.spaceMuted = spaceMuted;
    }
}

