/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.translation;

import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class PortletInstanceCategoryTranslationPlugin
extends TranslationPlugin {
    public static final String OBJECT_TYPE = "portletInstanceCategory";
    public static final String TITLE_FIELD_NAME = "title";
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.translationService.addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasEditPermission(long id, String username) throws ObjectNotFoundException {
        return this.layoutAclService.isAdministrator(username);
    }

    public boolean hasAccessPermission(long id, String username) throws ObjectNotFoundException {
        PortletInstanceCategory category = this.portletInstanceService.getPortletInstanceCategory(id);
        if (category == null) {
            throw new ObjectNotFoundException("Portlet instance category not found");
        }
        List<String> permissions = category.getPermissions();
        return CollectionUtils.isEmpty(permissions) || permissions.stream().anyMatch(p -> this.layoutAclService.isMemberOf(username, (String)p));
    }

    public long getAudienceId(long templateId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(long templateId) throws ObjectNotFoundException {
        return 0L;
    }
}

