/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.http.ResponseCookie;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.i18n.AbstractLocaleContextResolver;
import org.springframework.web.util.WebUtils;

public class CookieLocaleResolver
extends AbstractLocaleContextResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    public static final String TIME_ZONE_REQUEST_ATTRIBUTE_NAME = CookieLocaleResolver.class.getName() + ".TIME_ZONE";
    public static final String DEFAULT_COOKIE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    private static final Log logger = LogFactory.getLog(CookieLocaleResolver.class);
    private ResponseCookie cookie;
    private boolean languageTagCompliant = true;
    private boolean rejectInvalidCookies = true;
    private Function<HttpServletRequest, Locale> defaultLocaleFunction = request -> {
        Locale defaultLocale = this.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : request.getLocale();
    };
    private Function<HttpServletRequest, TimeZone> defaultTimeZoneFunction = request -> this.getDefaultTimeZone();

    public CookieLocaleResolver(String cookieName) {
        Assert.notNull((Object)cookieName, (String)"'cookieName' must not be null");
        this.cookie = ResponseCookie.from((String)cookieName).path("/").sameSite("Lax").build();
    }

    public CookieLocaleResolver() {
        this(DEFAULT_COOKIE_NAME);
    }

    @Deprecated
    public void setCookieName(String cookieName) {
        Assert.notNull((Object)cookieName, (String)"cookieName must not be null");
        this.cookie = ResponseCookie.from((String)cookieName).maxAge(this.cookie.getMaxAge()).domain(this.cookie.getDomain()).path(this.cookie.getPath()).secure(this.cookie.isSecure()).httpOnly(this.cookie.isHttpOnly()).sameSite(this.cookie.getSameSite()).build();
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        Assert.notNull((Object)cookieMaxAge, (String)"'cookieMaxAge' must not be null");
        this.cookie = this.cookie.mutate().maxAge(cookieMaxAge).build();
    }

    @Deprecated
    public void setCookieMaxAge(@Nullable Integer cookieMaxAge) {
        this.setCookieMaxAge(Duration.ofSeconds(cookieMaxAge != null ? (long)cookieMaxAge.intValue() : -1L));
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookie = this.cookie.mutate().path(cookiePath).build();
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookie = this.cookie.mutate().domain(cookieDomain).build();
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookie = this.cookie.mutate().secure(cookieSecure).build();
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookie = this.cookie.mutate().httpOnly(cookieHttpOnly).build();
    }

    public void setCookieSameSite(String cookieSameSite) {
        Assert.notNull((Object)cookieSameSite, (String)"cookieSameSite must not be null");
        this.cookie = this.cookie.mutate().sameSite(cookieSameSite).build();
    }

    public void setLanguageTagCompliant(boolean languageTagCompliant) {
        this.languageTagCompliant = languageTagCompliant;
    }

    public boolean isLanguageTagCompliant() {
        return this.languageTagCompliant;
    }

    public void setRejectInvalidCookies(boolean rejectInvalidCookies) {
        this.rejectInvalidCookies = rejectInvalidCookies;
    }

    public boolean isRejectInvalidCookies() {
        return this.rejectInvalidCookies;
    }

    public void setDefaultLocaleFunction(Function<HttpServletRequest, Locale> defaultLocaleFunction) {
        Assert.notNull(defaultLocaleFunction, (String)"defaultLocaleFunction must not be null");
        this.defaultLocaleFunction = defaultLocaleFunction;
    }

    public void setDefaultTimeZoneFunction(Function<HttpServletRequest, TimeZone> defaultTimeZoneFunction) {
        Assert.notNull(defaultTimeZoneFunction, (String)"defaultTimeZoneFunction must not be null");
        this.defaultTimeZoneFunction = defaultTimeZoneFunction;
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        this.parseLocaleCookieIfNecessary(request);
        return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
    }

    @Override
    public LocaleContext resolveLocaleContext(final HttpServletRequest request) {
        this.parseLocaleCookieIfNecessary(request);
        return new TimeZoneAwareLocaleContext(){

            @Nullable
            public Locale getLocale() {
                return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
            }

            @Nullable
            public TimeZone getTimeZone() {
                return (TimeZone)request.getAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
            }
        };
    }

    private void parseLocaleCookieIfNecessary(HttpServletRequest request) {
        if (request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME) == null) {
            Locale locale = null;
            TimeZone timeZone = null;
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.cookie.getName());
            if (cookie != null) {
                block9: {
                    String value;
                    String localePart = value = cookie.getValue();
                    String timeZonePart = null;
                    int separatorIndex = localePart.indexOf(47);
                    if (separatorIndex == -1) {
                        separatorIndex = localePart.indexOf(32);
                    }
                    if (separatorIndex >= 0) {
                        localePart = value.substring(0, separatorIndex);
                        timeZonePart = value.substring(separatorIndex + 1);
                    }
                    try {
                        Locale locale2 = locale = !"-".equals(localePart) ? this.parseLocaleValue(localePart) : null;
                        if (timeZonePart != null) {
                            timeZone = StringUtils.parseTimeZoneString((String)timeZonePart);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.isRejectInvalidCookies() && request.getAttribute("jakarta.servlet.error.exception") == null) {
                            throw new IllegalStateException("Encountered invalid locale cookie '" + this.cookie.getName() + "': [" + value + "] due to: " + ex.getMessage());
                        }
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)("Ignoring invalid locale cookie '" + this.cookie.getName() + "': [" + value + "] due to: " + ex.getMessage()));
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'" + (String)(timeZone != null ? " and time zone '" + timeZone.getID() + "'" : "")));
                }
            }
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, locale != null ? locale : this.defaultLocaleFunction.apply(request));
            request.setAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, timeZone != null ? timeZone : this.defaultTimeZoneFunction.apply(request));
        }
    }

    @Override
    public void setLocaleContext(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable LocaleContext localeContext) {
        Assert.notNull((Object)response, (String)"HttpServletResponse is required for CookieLocaleResolver");
        Locale locale = null;
        TimeZone zone = null;
        if (localeContext != null) {
            locale = localeContext.getLocale();
            if (localeContext instanceof TimeZoneAwareLocaleContext) {
                TimeZoneAwareLocaleContext timeZoneAwareLocaleContext = (TimeZoneAwareLocaleContext)localeContext;
                zone = timeZoneAwareLocaleContext.getTimeZone();
            }
            String value = (locale != null ? this.toLocaleValue(locale) : "-") + (String)(zone != null ? "/" + zone.getID() : "");
            this.cookie = this.cookie.mutate().value(value).build();
        }
        response.addHeader("Set-Cookie", this.cookie.toString());
        request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)(locale != null ? locale : this.defaultLocaleFunction.apply(request)));
        request.setAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, (Object)(zone != null ? zone : this.defaultTimeZoneFunction.apply(request)));
    }

    @Nullable
    protected Locale parseLocaleValue(String localeValue) {
        return StringUtils.parseLocale((String)localeValue);
    }

    protected String toLocaleValue(Locale locale) {
        return this.isLanguageTagCompliant() ? locale.toLanguageTag() : locale.toString();
    }

    @Deprecated(since="6.0")
    protected Locale determineDefaultLocale(HttpServletRequest request) {
        return this.defaultLocaleFunction.apply(request);
    }

    @Deprecated(since="6.0")
    @Nullable
    protected TimeZone determineDefaultTimeZone(HttpServletRequest request) {
        return this.defaultTimeZoneFunction.apply(request);
    }
}

