/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;

public class PageImporter {
    private final SiteKey siteKey;
    private final List<Page> list;
    private final LayoutService layoutService;
    private final ImportMode mode;

    public PageImporter(ImportMode importMode, SiteKey siteKey, List<Page> list, LayoutService layoutService_) {
        this.siteKey = siteKey;
        this.mode = importMode;
        this.list = list;
        this.layoutService = layoutService_;
    }

    public void perform() throws Exception {
        HashMap<String, Page> hashPageList = new HashMap<String, Page>();
        for (Page page : this.list) {
            hashPageList.put(page.getPageId(), page);
        }
        if (this.mode == ImportMode.OVERWRITE && !this.siteKey.getType().equals((Object)SiteType.USER)) {
            this.layoutService.removePages(this.siteKey);
        }
        for (Page src : this.list) {
            PageContext existingPage = this.layoutService.getPageContext(src.getPageKey());
            Page dst = switch (this.mode) {
                case ImportMode.CONSERVE -> null;
                case ImportMode.INSERT -> {
                    if (existingPage == null) {
                        yield src;
                    }
                    yield null;
                }
                case ImportMode.MERGE, ImportMode.OVERWRITE -> src;
                default -> throw new AssertionError();
            };
            if (dst == null) continue;
            PageState dstState = Utils.toPageState((Page)dst);
            this.layoutService.save(new PageContext(src.getPageKey(), dstState), dst);
        }
    }
}

