/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.permlink.service;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import jakarta.servlet.ServletContext;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.picocontainer.Startable;

public class PermanentLinkServiceImpl
implements PermanentLinkService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(PermanentLinkServiceImpl.class);
    public static final Context PERMANEN_LINK_CONTEXT = Context.GLOBAL.id("PermanentLink");
    public static final Scope PERMANENT_LINK_SCOPE = Scope.GLOBAL.id("PermanentLinkIds");
    public static final Scope PERMANENT_LINK_IDS_SCOPE = Scope.APPLICATION.id("PermanentLinkIds");
    public static final String PERMANENT_LINK_SALT_NAME = "PermanentLinkSalt";
    public static final Pattern PERMANENT_LINK_PATTERN = Pattern.compile("(?<objectType>[^/]*)/(?<objectId>[^/?]*)\\?(?<params>.*)");
    public static final String PERMANENT_LINK_FOMRAT = "%s/%s?%s";
    private static final MessageDigest DIGEST = PermanentLinkServiceImpl.getDigest();
    private PortalContainer container;
    private SettingService settingService;
    private Map<String, PermanentLinkPlugin> plugins;
    private String salt;

    public PermanentLinkServiceImpl(PortalContainer container, SettingService settingService) {
        this.container = container;
        this.settingService = settingService;
    }

    public void start() {
        PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostCreateTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                PermanentLinkServiceImpl.this.initPlugins();
            }
        });
        this.initSalt();
    }

    public String getPermanentLink(PermanentLinkObject object) {
        if (this.plugins.containsKey(object.getObjectType())) {
            Map parameters = object.getParameters();
            List queryParams = parameters == null ? Collections.emptyList() : parameters.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + "=" + this.encodeUrl(((String)e.getValue()).getBytes())).toList();
            String permanentLink = String.format(PERMANENT_LINK_FOMRAT, object.getObjectType(), object.getObjectId(), StringUtils.join(queryParams, (String)"&"));
            String permanentLinkId = this.getAndSetId(permanentLink);
            return "/portal/l/" + permanentLinkId;
        }
        return null;
    }

    public String getLink(PermanentLinkObject object) throws ObjectNotFoundException {
        PermanentLinkPlugin plugin = this.plugins.get(object.getObjectType());
        if (plugin == null) {
            throw new ObjectNotFoundException("Plugin not found with object of type : " + object.getObjectType());
        }
        return plugin.getDirectAccessUrl(object);
    }

    public String getDirectAccessUrl(String permanentLinkId, Identity identity) throws IllegalAccessException, ObjectNotFoundException {
        PermanentLinkObject object;
        String permanentLink = this.getById(permanentLinkId);
        PermanentLinkObject permanentLinkObject = object = permanentLink == null ? null : this.parseObject(permanentLink);
        if (object == null) {
            throw new ObjectNotFoundException(String.format("Url '%s' can't be parsed", permanentLink));
        }
        PermanentLinkPlugin plugin = this.plugins.get(object.getObjectType());
        if (plugin == null) {
            throw new ObjectNotFoundException("Plugin not found with object of type : " + object.getObjectType());
        }
        if (plugin.canAccess(object, identity)) {
            return plugin.getDirectAccessUrl(object);
        }
        throw new IllegalAccessException();
    }

    protected void initPlugins() {
        this.plugins = this.container.getComponentInstancesOfType(PermanentLinkPlugin.class).stream().collect(Collectors.toMap(PermanentLinkPlugin::getObjectType, Function.identity()));
    }

    protected void initSalt() {
        SettingValue saltSettingValue = this.settingService.get(PERMANEN_LINK_CONTEXT, PERMANENT_LINK_SCOPE, PERMANENT_LINK_SALT_NAME);
        if (saltSettingValue == null || saltSettingValue.getValue() == null) {
            this.salt = UUID.randomUUID().toString();
            this.settingService.set(PERMANEN_LINK_CONTEXT, PERMANENT_LINK_IDS_SCOPE, PERMANENT_LINK_SALT_NAME, SettingValue.create((String)this.salt));
        } else {
            this.salt = saltSettingValue.getValue().toString();
        }
    }

    private PermanentLinkObject parseObject(String permanentLink) {
        Matcher matcher = PERMANENT_LINK_PATTERN.matcher(permanentLink);
        if (matcher.find()) {
            String objectType = matcher.group("objectType");
            String objectId = matcher.group("objectId");
            PermanentLinkObject object = new PermanentLinkObject(objectType, objectId);
            String params = matcher.group("params");
            if (StringUtils.isNotBlank((CharSequence)params)) {
                object.setParameters(new HashMap());
                String[] paramsArray = params.split("&");
                Stream.of(paramsArray).forEach(param -> {
                    if (StringUtils.contains((CharSequence)param, (CharSequence)"=")) {
                        String[] paramParts = param.split("=");
                        object.getParameters().put(paramParts[0], new String(this.decode(paramParts[1])));
                    }
                });
            }
            return object;
        }
        return null;
    }

    private byte[] decode(String base64Encoded) {
        return Base64.decodeBase64((String)base64Encoded);
    }

    private String encodeUrl(byte[] bytes) {
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    private String getById(String permanentLinkId) {
        SettingValue settingValue = this.settingService.get(PERMANEN_LINK_CONTEXT, PERMANENT_LINK_IDS_SCOPE, permanentLinkId);
        return settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
    }

    private String getAndSetId(String permanentLink) {
        String permanentLinkId = this.generateHash(permanentLink);
        try {
            this.settingService.set(PERMANEN_LINK_CONTEXT, PERMANENT_LINK_IDS_SCOPE, permanentLinkId, SettingValue.create((String)permanentLink));
        }
        catch (RuntimeException e) {
            if (this.settingService.get(PERMANEN_LINK_CONTEXT, PERMANENT_LINK_IDS_SCOPE, permanentLinkId) == null) {
                throw e;
            }
            LOG.debug("Duplicated Permanent Link Id {} set. This may be due to parallel saving", new Object[]{permanentLinkId});
        }
        return permanentLinkId;
    }

    private String generateHash(String permanentLink) {
        byte[] hashbytes = DIGEST.digest((permanentLink + this.salt).getBytes(StandardCharsets.UTF_8));
        return this.encodeUrl(hashbytes);
    }

    private static MessageDigest getDigest() {
        return MessageDigest.getInstance("SHA3-256");
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }
}

