/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.model.NameSpace;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.file.services.impl.FileServiceImpl$AjcClosure1;
import org.exoplatform.commons.file.services.impl.FileServiceImpl$AjcClosure3;
import org.exoplatform.commons.file.storage.DataStorage;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileServiceImpl
implements FileService {
    private static final Log LOG;
    private static final String FILE_CREATED_EVENT = "file.created";
    private static final String FILE_UPDATED_EVENT = "file.updated";
    private static final String FILE_DELETED_EVENT = "file.deleted";
    private DataStorage dataStorage;
    private BinaryProvider binaryProvider;
    private NameSpaceService nameSpaceService;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public FileServiceImpl(DataStorage dataStorage, BinaryProvider resourceProvider, NameSpaceService nameSpaceService, ListenerService listenerService) {
        this.dataStorage = dataStorage;
        this.binaryProvider = resourceProvider;
        this.nameSpaceService = nameSpaceService;
        this.listenerService = listenerService;
    }

    @Override
    public FileInfo getFileInfo(long id) {
        return this.dataStorage.getFileInfo(id);
    }

    @Override
    public List<FileInfo> getFileInfoListByChecksum(String checksum) {
        return this.dataStorage.getFileInfoListByChecksum(checksum);
    }

    @Override
    public FileItem getFile(long id) throws FileStorageException {
        FileItem fileItem;
        FileInfo fileInfo = this.getFileInfo(id);
        if (fileInfo == null || StringUtils.isEmpty((CharSequence)fileInfo.getChecksum())) {
            return null;
        }
        try {
            fileItem = new FileItem(fileInfo, null);
            InputStream inputStream = this.binaryProvider.getStream(fileInfo.getChecksum());
            fileItem.setInputStream(inputStream);
        }
        catch (Exception e) {
            throw new FileStorageException("Cannot get File Item ID=" + id, e);
        }
        return fileItem;
    }

    @Override
    @ExoTransactional
    public FileItem writeFile(FileItem file) throws FileStorageException, IOException {
        FileItem fileItem = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)fileItem);
        Object[] objectArray = new Object[]{this, fileItem, joinPoint};
        FileServiceImpl$AjcClosure1 fileServiceImpl$AjcClosure1 = new FileServiceImpl$AjcClosure1(objectArray);
        return (FileItem)ExoTransactionalAspect.aspectOf().around(fileServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public FileItem updateFile(FileItem file) throws FileStorageException, IOException {
        FileItem fileItem = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)fileItem);
        Object[] objectArray = new Object[]{this, fileItem, joinPoint};
        FileServiceImpl$AjcClosure3 fileServiceImpl$AjcClosure3 = new FileServiceImpl$AjcClosure3(objectArray);
        return (FileItem)ExoTransactionalAspect.aspectOf().around(fileServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    public FileInfo deleteFile(long id) {
        FileInfo fileInfo = this.dataStorage.getFileInfo(id);
        if (fileInfo == null) {
            return null;
        }
        fileInfo.setDeleted(true);
        FileInfo newFileInfo = this.dataStorage.updateFileInfo(fileInfo);
        try {
            this.listenerService.broadcast(FILE_DELETED_EVENT, (Object)newFileInfo, null);
        }
        catch (Exception e) {
            LOG.error("Error while broadcasting event: {}", new Object[]{FILE_DELETED_EVENT, e});
        }
        return newFileInfo;
    }

    @Override
    public List<FileItem> getFilesByChecksum(String checksum) throws FileStorageException {
        ArrayList<FileItem> fileItemList = new ArrayList<FileItem>();
        List<FileInfo> fileInfoList = this.getFileInfoListByChecksum(checksum);
        try {
            for (FileInfo fileInfo : fileInfoList) {
                FileItem fileItem = new FileItem(fileInfo, null);
                InputStream inputStream = this.binaryProvider.getStream(fileInfo.getChecksum());
                fileItem.setInputStream(inputStream);
                fileItemList.add(fileItem);
            }
        }
        catch (Exception e) {
            throw new FileStorageException("Cannot get File Item CHECKSUM=" + checksum, e);
        }
        return fileItemList;
    }

    static {
        FileServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(FileServiceImpl.class);
    }

    static final /* synthetic */ FileItem writeFile_aroundBody0(FileServiceImpl ajc$this, FileItem file, JoinPoint joinPoint) {
        FileInfo fileInfo;
        if (file.getFileInfo() == null || StringUtils.isEmpty((CharSequence)file.getFileInfo().getChecksum())) {
            throw new IllegalArgumentException("Checksum is required to persist the binary");
        }
        NameSpace nSpace = (fileInfo = file.getFileInfo()).getNameSpace() != null && !fileInfo.getNameSpace().isEmpty() ? ajc$this.dataStorage.getNameSpace(fileInfo.getNameSpace()) : ajc$this.dataStorage.getNameSpace(ajc$this.nameSpaceService.getDefaultNameSpace());
        FileStorageTransaction transaction = ajc$this.new FileStorageTransaction(fileInfo, nSpace);
        FileInfo createdFileInfoEntity = transaction.twoPhaseCommit(2, file.getAsStream());
        if (createdFileInfoEntity != null) {
            fileInfo.setId(createdFileInfoEntity.getId());
            file.setFileInfo(fileInfo);
            try {
                ajc$this.listenerService.broadcast(FILE_CREATED_EVENT, (Object)fileInfo, null);
            }
            catch (Exception e) {
                LOG.error("Error while broadcasting event: {}", new Object[]{FILE_CREATED_EVENT, e});
            }
            return file;
        }
        return null;
    }

    static final /* synthetic */ FileItem updateFile_aroundBody2(FileServiceImpl ajc$this, FileItem file, JoinPoint joinPoint) {
        FileInfo fileInfo;
        if (file.getFileInfo() == null || StringUtils.isEmpty((CharSequence)file.getFileInfo().getChecksum())) {
            throw new IllegalArgumentException("Checksum is required to persist the binary");
        }
        NameSpace nSpace = (fileInfo = file.getFileInfo()).getNameSpace() != null && !fileInfo.getNameSpace().isEmpty() ? ajc$this.dataStorage.getNameSpace(fileInfo.getNameSpace()) : ajc$this.dataStorage.getNameSpace(ajc$this.nameSpaceService.getDefaultNameSpace());
        FileStorageTransaction transaction = ajc$this.new FileStorageTransaction(fileInfo, nSpace);
        FileInfo createdFileInfoEntity = transaction.twoPhaseCommit(0, file.getAsStream());
        if (createdFileInfoEntity != null) {
            fileInfo.setId(createdFileInfoEntity.getId());
            file.setFileInfo(fileInfo);
            try {
                ajc$this.listenerService.broadcast(FILE_UPDATED_EVENT, (Object)fileInfo, null);
            }
            catch (Exception e) {
                LOG.error("Error while broadcasting event: {}", new Object[]{FILE_UPDATED_EVENT, e});
            }
            return file;
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FileServiceImpl.java", FileServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "writeFile", "org.exoplatform.commons.file.services.impl.FileServiceImpl", "org.exoplatform.commons.file.model.FileItem", "file", "org.exoplatform.commons.file.services.FileStorageException:java.io.IOException", "org.exoplatform.commons.file.model.FileItem"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFile", "org.exoplatform.commons.file.services.impl.FileServiceImpl", "org.exoplatform.commons.file.model.FileItem", "file", "org.exoplatform.commons.file.services.FileStorageException:java.io.IOException", "org.exoplatform.commons.file.model.FileItem"), 116);
    }

    private class FileStorageTransaction {
        final int UPDATE = 0;
        final int REMOVE = 1;
        final int INSERT = 2;
        private FileInfo fileInfo;
        private NameSpace nameSpace;

        public FileStorageTransaction(FileInfo fileInfo, NameSpace nameSpace) {
            this.fileInfo = fileInfo;
            this.nameSpace = nameSpace;
        }

        public FileInfo twoPhaseCommit(int operation, InputStream inputStream) throws FileStorageException {
            FileInfo createdFileInfoEntity = null;
            if (operation == 2) {
                boolean created = false;
                try {
                    if (!FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                        FileServiceImpl.this.binaryProvider.put(this.fileInfo.getChecksum(), inputStream);
                        created = true;
                    }
                    createdFileInfoEntity = FileServiceImpl.this.dataStorage.create(this.fileInfo, this.nameSpace);
                    return createdFileInfoEntity;
                }
                catch (Exception e) {
                    try {
                        if (created) {
                            FileServiceImpl.this.binaryProvider.remove(this.fileInfo.getChecksum());
                        }
                    }
                    catch (IOException e1) {
                        LOG.error((Object)"Error while rollback writing file");
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName(), e);
                }
            }
            if (operation == 1) {
                this.fileInfo.setDeleted(true);
                FileServiceImpl.this.dataStorage.updateFileInfo(this.fileInfo);
            } else if (operation == 0) {
                try {
                    boolean updated = false;
                    FileInfo oldFile = FileServiceImpl.this.dataStorage.getFileInfo(this.fileInfo.getId());
                    if (oldFile == null || oldFile.getChecksum().isEmpty() || !oldFile.getChecksum().equals(this.fileInfo.getChecksum())) {
                        if (!FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                            FileServiceImpl.this.binaryProvider.put(this.fileInfo.getChecksum(), inputStream);
                        }
                        updated = true;
                    }
                    if (updated && FileServiceImpl.this.dataStorage.sharedChecksum(oldFile.getChecksum()) == 1) {
                        FileServiceImpl.this.dataStorage.createOrphanFile(oldFile);
                    }
                    if (FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                        createdFileInfoEntity = FileServiceImpl.this.dataStorage.updateFileInfo(this.fileInfo);
                        return createdFileInfoEntity;
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName());
                }
                catch (Exception e) {
                    try {
                        FileServiceImpl.this.binaryProvider.remove(this.fileInfo.getChecksum());
                    }
                    catch (IOException e1) {
                        LOG.error((Object)"Error while rollback writing file");
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName(), e);
                }
            }
            return null;
        }
    }
}

