/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import io.meeds.pwa.storage.PwaNotificationStorage;
import java.security.KeyPair;
import nl.martijndwars.webpush.PushService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PushServiceConfiguration {
    @Value(value="${pwa.notifications.email:}")
    private String email;

    @Bean
    public PushService getPushService(PwaNotificationStorage pwaNotificationStorage) throws Exception {
        PushService pushService = new PushService(new KeyPair(pwaNotificationStorage.getVapidPublicKey(), pwaNotificationStorage.getVapidPrivateKey()));
        pushService.setSubject("mailto:" + this.getContactEmail());
        return pushService;
    }

    private String getContactEmail() {
        if (StringUtils.isBlank((CharSequence)this.email)) {
            this.email = MailUtils.getSenderEmail();
        }
        return this.email;
    }
}

