/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.rest.NewsTargetingEntity;
import io.meeds.news.service.NewsTargetingService;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceNewsTargetAutoCreationListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(SpaceNewsTargetAutoCreationListener.class);
    private NewsTargetingService newsTargetingService;
    private static final String SPACE_NEWS_TARGET_AUTO_CREATION_FEATURE = "spaceNewsTargetAutoCreation";

    public SpaceNewsTargetAutoCreationListener(NewsTargetingService newsTargetingService) {
        this.newsTargetingService = newsTargetingService;
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        if (CommonsUtils.isFeatureActive((String)SPACE_NEWS_TARGET_AUTO_CREATION_FEATURE)) {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            Space space = event.getSpace();
            NewsTargetingEntity spaceNewsTargetEntity = new NewsTargetingEntity();
            spaceNewsTargetEntity.setName(space.getDisplayName());
            spaceNewsTargetEntity.setProperties(Map.of("label", space.getDisplayName(), "permissions", "space:" + space.getId()));
            try {
                this.newsTargetingService.createNewsTarget(spaceNewsTargetEntity, currentIdentity, false);
            }
            catch (Exception e) {
                LOG.warn("Can't create space {} news target", new Object[]{space.getPrettyName()});
            }
        }
    }
}

