/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;

@ComponentConfig
public class UIAddOnContainer
extends UIContainer {
    public static final String ADDON_CONTAINER = "addonContainer";
    private ThreadLocal<Boolean> childrenComputed = new ThreadLocal();
    private boolean initialized = false;

    @Override
    public List<UIComponent> getChildren() {
        if (!this.initialized || PortalRequestContext.getCurrentInstance().isNoCache() && this.childrenComputed.get() == null) {
            AddOnService addonService = this.getApplicationComponent(AddOnService.class);
            List<Application<Portlet>> apps = addonService.getApplications(this.getName());
            Container model = new Container();
            model.setChildren(new ArrayList<Application<Portlet>>(apps));
            UIContainer tmp = new UIContainer();
            PortalDataMapper.toUIContainer(tmp, model);
            for (UIComponent comp : tmp.getChildren()) {
                comp.setParent(this);
            }
            this.setChildren(tmp.getChildren());
            this.initialized = true;
            this.childrenComputed.set(true);
            PortalRequestContext.getCurrentInstance().addOnRequestEnd(this.childrenComputed::remove);
        }
        return super.getChildren();
    }

    @Override
    public ModelObject buildModelObject() {
        Container model = new Container(this.getStorageId());
        model.setId(this.getId());
        model.setName(this.getName());
        model.setTitle(this.getTitle());
        model.setIcon(this.getIcon());
        model.setDescription(this.getDescription());
        model.setHeight(this.getHeight());
        model.setWidth(this.getWidth());
        model.setTemplate(this.getTemplate());
        model.setFactoryId(this.getFactoryId());
        model.setAccessPermissions(this.getAccessPermissions());
        return model;
    }
}

