/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.dao;

import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.reward.dao.RewardDAO$AjcClosure1;
import org.exoplatform.wallet.reward.entity.WalletRewardEntity;

public class RewardDAO
extends GenericDAOJPAImpl<WalletRewardEntity, Long> {
    private static final Log LOG;
    private static final String IDENTITY_ID = "identityId";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public List<WalletRewardEntity> findRewardsByPeriodId(long periodId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardsByPeriodId", WalletRewardEntity.class);
        query.setParameter("periodId", (Object)periodId);
        List result = query.getResultList();
        return this.toNotNullList(result);
    }

    public List<WalletRewardEntity> findRewardsByIdentityId(long identityId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardsByIdentityId", WalletRewardEntity.class);
        query.setParameter(IDENTITY_ID, (Object)identityId);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List result = query.getResultList();
        return this.toNotNullList(result);
    }

    public double countRewardsByIdentityId(long identityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.countRewardsByIdentityId", Double.class);
        query.setParameter(IDENTITY_ID, (Object)identityId);
        Double result = (Double)query.getSingleResult();
        return this.toNotNullDouble(result);
    }

    public WalletRewardEntity findRewardByIdentityIdAndPeriodId(long identityId, long periodId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardByIdentityIdAndPeriodId", WalletRewardEntity.class);
        query.setParameter("periodId", (Object)periodId);
        query.setParameter(IDENTITY_ID, (Object)identityId);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one reward was found for identityId {} and periodId {}", new Object[]{identityId, periodId});
        }
        return RewardDAO.getFirstItem(result);
    }

    @ExoTransactional
    public void replaceRewardTransactions(String oldHash, String newHash) {
        String string = oldHash;
        String string2 = newHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        RewardDAO$AjcClosure1 rewardDAO$AjcClosure1 = new RewardDAO$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(rewardDAO$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private List<WalletRewardEntity> toNotNullList(List<WalletRewardEntity> result) {
        return result == null ? Collections.emptyList() : result;
    }

    private double toNotNullDouble(Double result) {
        return result == null ? 0.0 : result;
    }

    private static WalletRewardEntity getFirstItem(List<WalletRewardEntity> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        return resultList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTransactionHash())).sorted((r2, r1) -> {
            if (r1.getTokensSent() > r2.getTokensSent()) {
                return 1;
            }
            if (r2.getTokensSent() > r1.getTokensSent()) {
                return -1;
            }
            return 0;
        }).findFirst().orElse(resultList.get(0));
    }

    static {
        RewardDAO.ajc$preClinit();
        LOG = ExoLogger.getLogger(RewardDAO.class);
    }

    static final /* synthetic */ void replaceRewardTransactions_aroundBody0(RewardDAO ajc$this, String oldHash, String newHash, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("Reward.updateTransactionHash");
        query.setParameter("oldHash", (Object)oldHash);
        query.setParameter("newHash", (Object)newHash);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RewardDAO.java", RewardDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "replaceRewardTransactions", "org.exoplatform.wallet.reward.dao.RewardDAO", "java.lang.String:java.lang.String", "oldHash:newHash", "", "void"), 81);
    }
}

