/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.exoplatform.wallet.reward.entity.WalletRewardEntity;
import org.hibernate.annotations.DynamicUpdate;

@Entity(name="RewardPlugin")
@DynamicUpdate
@Table(name="ADDONS_WALLET_REWARD_PLUGIN")
@NamedQueries(value={@NamedQuery(name="RewardPlugin.getRewardPluginsByRewardId", query="SELECT rp FROM RewardPlugin rp WHERE rp.reward.id = :rewardId"), @NamedQuery(name="RewardPlugin.getRewardPluginsByRewardIdAndPluginId", query="SELECT rp FROM RewardPlugin rp WHERE rp.reward.id = :rewardId AND rp.pluginId = :pluginId")})
public class WalletRewardPluginEntity
implements Serializable {
    private static final long serialVersionUID = 4475704534821391132L;
    @Id
    @SequenceGenerator(name="SEQ_WALLET_REWARD_PLUGIN_ID", sequenceName="SEQ_WALLET_REWARD_PLUGIN_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WALLET_REWARD_PLUGIN_ID")
    @Column(name="REWARD_PLUGIN_ID")
    private Long id;
    @Column(name="PLUGIN_ID")
    private String pluginId;
    @Column(name="POOL_USED")
    private boolean poolUsed;
    @Column(name="POINTS")
    private double points;
    @Column(name="AMOUNT")
    private double amount;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="REWARD_ID", referencedColumnName="REWARD_ID")
    private WalletRewardEntity reward;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public boolean isPoolUsed() {
        return this.poolUsed;
    }

    public void setPoolUsed(boolean poolUsed) {
        this.poolUsed = poolUsed;
    }

    public double getPoints() {
        return this.points;
    }

    public void setPoints(double points) {
        this.points = points;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public WalletRewardEntity getReward() {
        return this.reward;
    }

    public void setReward(WalletRewardEntity reward) {
        this.reward = reward;
    }
}

