/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.dao.ContainerDAO;
import org.exoplatform.portal.mop.dao.PermissionDAO;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.cache.model.WindowData;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CacheLayoutStorage
extends LayoutStorage {
    public static final String PORTLET_PREFERENCES_CACHE_NAME = "portal.PortletPreferences";
    private final FutureExoCache<Long, WindowData, Object> portletPreferencesFutureCache;
    private final ExoCache<Long, WindowData> portletPreferencesCache;

    public CacheLayoutStorage(CacheService cacheService, WindowDAO windowDAO, ContainerDAO containerDAO, PermissionDAO permissionDAO) {
        super(windowDAO, containerDAO, permissionDAO);
        this.portletPreferencesCache = cacheService.getCacheInstance(PORTLET_PREFERENCES_CACHE_NAME);
        this.portletPreferencesFutureCache = new FutureExoCache((Loader)new Loader<Long, WindowData, Object>(){

            public WindowData retrieve(Object context, Long siteKey) throws Exception {
                WindowEntity window = CacheLayoutStorage.super.findWindow(siteKey);
                if (window == null) {
                    return WindowData.NULL_OBJECT;
                }
                return new WindowData(window.getId(), window.getTitle(), window.getIcon(), window.getDescription(), window.isShowInfoBar(), window.isShowApplicationState(), window.isShowApplicationMode(), window.getTheme(), window.getWidth(), window.getHeight(), window.getProperties(), null, window.getContentId(), window.getCustomization());
            }
        }, this.portletPreferencesCache);
    }

    @Override
    protected WindowEntity createWindow(WindowEntity dstW) {
        WindowEntity window = super.createWindow(dstW);
        if (window != null && window.getId() != null) {
            this.portletPreferencesCache.remove((Serializable)window.getId());
        }
        return window;
    }

    @Override
    protected WindowEntity updateWindow(WindowEntity window) {
        try {
            WindowEntity windowEntity = super.updateWindow(window);
            return windowEntity;
        }
        finally {
            this.portletPreferencesCache.remove((Serializable)window.getId());
        }
    }

    @Override
    protected WindowEntity findWindow(Long id) {
        WindowData window = (WindowData)this.portletPreferencesFutureCache.get(null, (Object)id);
        return window == null || window.isNull() ? null : this.toEntity(window);
    }

    @Override
    protected void deleteWindow(WindowEntity window) {
        try {
            super.deleteWindow(window);
        }
        finally {
            this.portletPreferencesCache.remove((Serializable)window.getId());
        }
    }

    @Override
    protected void deleteWindowById(Long id) {
        try {
            super.deleteWindowById(id);
        }
        finally {
            this.portletPreferencesCache.remove((Serializable)id);
        }
    }

    private WindowEntity toEntity(WindowData window) {
        WindowEntity windowEntity = new WindowEntity();
        windowEntity.setId(window.getId());
        windowEntity.setTitle(window.getTitle());
        windowEntity.setIcon(window.getIcon());
        windowEntity.setDescription(window.getDescription());
        windowEntity.setShowInfoBar(window.isShowInfoBar());
        windowEntity.setShowApplicationState(window.isShowApplicationState());
        windowEntity.setShowApplicationMode(window.isShowApplicationMode());
        windowEntity.setTheme(window.getTheme());
        windowEntity.setWidth(window.getWidth());
        windowEntity.setHeight(window.getHeight());
        windowEntity.setProperties(window.getProperties());
        windowEntity.setAppType(WindowEntity.AppType.PORTLET);
        windowEntity.setContentId(window.getContentId());
        windowEntity.setCustomization(window.getCustomization());
        return windowEntity;
    }
}

