/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.PlainTokenService;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class TransientTokenService
extends PlainTokenService<GateInToken, String> {
    protected final ConcurrentHashMap<String, GateInToken> tokens = new ConcurrentHashMap();

    public TransientTokenService(InitParams initParams) throws TokenServiceInitializationException {
        super(initParams);
    }

    @Override
    public String createToken(String username) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (username == null) {
            throw new NullPointerException();
        }
        String tokenId = this.nextTokenId();
        long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
        this.tokens.put(tokenId, new GateInToken(expirationTimeMillis, username));
        return tokenId;
    }

    @Override
    public GateInToken getToken(String id, String type) {
        return this.tokens.get(id);
    }

    @Override
    public GateInToken getToken(String id) {
        return this.getToken(id, "");
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    @Override
    public GateInToken deleteToken(String id, String tokenType) {
        GateInToken token = this.tokens.get(id);
        this.tokens.remove(id);
        return token;
    }

    @Override
    public GateInToken deleteToken(String id) {
        return this.deleteToken(id, "");
    }

    public String[] getAllTokens() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.tokens.keySet())).toArray(new String[0]);
    }

    @Override
    public long size() {
        return this.tokens.size();
    }
}

