/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.job;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.news.job.PostScheduledNewsArticleJob$AjcClosure1;
import io.meeds.news.model.News;
import io.meeds.news.service.NewsService;
import io.meeds.news.service.impl.NewsServiceImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.social.metadata.MetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PostScheduledNewsArticleJob {
    private static final Logger LOG;
    @Autowired
    private NewsService newsService;
    @Autowired
    private MetadataService metadataService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Scheduled(cron="${meeds.content.postScheduledNewsArticle.job.cron:15 */2 * * * ?}")
    @ContainerTransactional
    public void postScheduledNewsArticle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PostScheduledNewsArticleJob$AjcClosure1 postScheduledNewsArticleJob$AjcClosure1 = new PostScheduledNewsArticleJob$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(postScheduledNewsArticleJob$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private boolean isSchedulePostDatePassed(String schedulePostDateString) {
        Calendar schedulePostDate = Calendar.getInstance();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
            schedulePostDate.setTime(format.parse(schedulePostDateString));
        }
        catch (ParseException e) {
            LOG.error("Error parsing schedule post date", (Throwable)e);
            return false;
        }
        Calendar now = Calendar.getInstance();
        return schedulePostDate.before(now) || now.equals(schedulePostDate);
    }

    static {
        PostScheduledNewsArticleJob.ajc$preClinit();
        LOG = LoggerFactory.getLogger(PostScheduledNewsArticleJob.class);
    }

    static final /* synthetic */ void postScheduledNewsArticle_aroundBody0(PostScheduledNewsArticleJob ajc$this, JoinPoint joinPoint) {
        ajc$this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty("news", NewsServiceImpl.NEWS_METADATA_TYPE.getName(), "newsPage", "publicationState", "staged", 0L, 0L).stream().filter(scheduledArticleMetadataItem -> {
            try {
                String articleScheduleDate;
                if (scheduledArticleMetadataItem.getProperties() != null && !scheduledArticleMetadataItem.getProperties().isEmpty() && (articleScheduleDate = (String)scheduledArticleMetadataItem.getProperties().getOrDefault("schedulePostDate", null)) != null && this.isSchedulePostDatePassed(articleScheduleDate)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }).map(scheduledArticle -> this.newsService.getNewsArticleById(scheduledArticle.getObjectId())).forEach(article -> {
            try {
                if (article != null) {
                    article = this.newsService.postNews((News)article, article.getAuthor());
                    LOG.info("News scheduled news posted to {}", (Object)article.getUrl());
                }
            }
            catch (Exception e) {
                LOG.error("Error posting scheduled news article", (Throwable)e);
            }
        });
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostScheduledNewsArticleJob.java", PostScheduledNewsArticleJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postScheduledNewsArticle", "io.meeds.news.job.PostScheduledNewsArticleJob", "", "", "", "void"), 60);
    }
}

