/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.notification.provider;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PostNewsNotificationPlugin", template="war:/notification/templates/mail/postNewsNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="MentionInNewsNotificationPlugin", template="war:/notification/templates/mail/postNewsNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="PublishNewsNotificationPlugin", template="war:/notification/templates/mail/postNewsNotificationPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);
    private final IdentityManager identityManager;
    private final SpaceService spaceService;

    public MailTemplateProvider(InitParams initParams, IdentityManager identityManager, SpaceService spaceService) {
        super(initParams);
        this.spaceService = spaceService;
        this.templateBuilders.put(PluginKey.key((String)"PostNewsNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"MentionInNewsNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"PublishNewsNotificationPlugin"), new TemplateBuilder());
        this.identityManager = identityManager;
    }

    protected class TemplateBuilder
    extends AbstractTemplateBuilder {
        protected TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)MailTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String newsId = notification.getValueOwnerParameter("NEWS_ID");
            String contentAuthor = notification.getValueOwnerParameter("CONTENT_AUTHOR");
            String currentUser = notification.getValueOwnerParameter("CURRENT_USER");
            String contentTitle = notification.getValueOwnerParameter("CONTENT_TITLE");
            String contentSpaceName = notification.getValueOwnerParameter("CONTENT_SPACE");
            String authorAvatarUrl = notification.getValueOwnerParameter("AUTHOR_AVATAR_URL");
            String baseUrl = PropertyManager.getProperty((String)"gatein.email.domain.url");
            String illustrationUrl = baseUrl.concat("/content/images/newsImageDefault.png");
            String activityLink = notification.getValueOwnerParameter("ACTIVITY_LINK");
            String context = notification.getValueOwnerParameter("CONTEXT");
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            templateContext.put((Object)"CONTENT_TITLE", (Object)encoder.encode(contentTitle));
            templateContext.put((Object)"CONTENT_SPACE", (Object)encoder.encode(contentSpaceName));
            templateContext.put((Object)"CONTENT_AUTHOR", (Object)encoder.encode(contentAuthor));
            templateContext.put((Object)"CURRENT_USER", (Object)currentUser);
            templateContext.put((Object)"ILLUSTRATION_URL", (Object)encoder.encode(illustrationUrl));
            templateContext.put((Object)"AUTHOR_AVATAR_URL", (Object)encoder.encode(authorAvatarUrl));
            templateContext.put((Object)"CONTEXT", (Object)encoder.encode(context));
            StringBuilder activityUrl = new StringBuilder();
            if (pluginId.equals("PublishNewsNotificationPlugin")) {
                String portalName = PortalContainer.getCurrentPortalContainerName();
                String portalOwner = CommonsUtils.getCurrentPortalOwner();
                Object currentDomain = CommonsUtils.getCurrentDomain();
                if (!((String)currentDomain).endsWith("/")) {
                    currentDomain = (String)currentDomain + "/";
                }
                activityUrl.append((String)currentDomain).append(portalName).append("/").append(portalOwner).append("/news-detail?newsId=").append(newsId);
            } else {
                activityUrl.append(activityLink);
            }
            templateContext.put((Object)"ACTIVITY_LINK", (Object)encoder.encode(activityUrl.toString()));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notification.getTo());
            if (receiver == null || receiver.getRemoteId().equals(notification.getFrom())) {
                return null;
            }
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            templateContext.put((Object)"COMPANY_LINK", (Object)LinkProviderUtils.getBaseUrl());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo notificationInfo = (NotificationInfo)notifications.get(0);
            try {
                String mentionedIds;
                String ids;
                List mentionedList;
                String pluginId = notificationInfo.getKey().getId();
                String spaceId = notificationInfo.getValueOwnerParameter("CONTENT_SPACE");
                Space space = MailTemplateProvider.this.spaceService.getSpaceByDisplayName(spaceId);
                if (!pluginId.equals("PublishNewsNotificationPlugin") && !MailTemplateProvider.this.spaceService.isMember(space, notificationInfo.getTo()) || notificationInfo.getTo().equals(notificationInfo.getFrom())) {
                    return false;
                }
                if (pluginId.equals("MentionInNewsNotificationPlugin") && !(mentionedList = Stream.of((ids = (mentionedIds = notificationInfo.getValueOwnerParameter("MENTIONED_IDS")).substring(1, mentionedIds.length() - 1)).split(",")).map(String::trim).collect(Collectors.toList())).contains(notificationInfo.getTo())) {
                    return false;
                }
                String language = this.getLanguage(notificationInfo);
                TemplateContext templateContext = new TemplateContext(pluginId, language);
                Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notificationInfo.getTo());
                templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
                templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            StringBuilder sb = new StringBuilder();
            for (NotificationInfo notification : notifications) {
                templateContext.put((Object)"CONTENT_TITLE", (Object)notification.getValueOwnerParameter("CONTENT_TITLE"));
                templateContext.put((Object)"USER", (Object)notification.getValueOwnerParameter("CONTENT_AUTHOR"));
                templateContext.put((Object)"SPACE_TITLE", (Object)notification.getValueOwnerParameter("CONTENT_SPACE"));
                templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
                String digester = TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }
    }
}

