/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.tenant.hub.model.BlockchainHubReport;
import io.meeds.tenant.hub.service.PolygonContractGasProvider;
import io.meeds.tenant.hub.storage.HubIdentityStorage;
import io.meeds.tenant.hub.utils.ContractUtils;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.utils.JsonUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.RawTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.PollingTransactionReceiptProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;

@Component
public class HubWalletStorage {
    public static final String FUNC_ADDREPORT = "addReport";
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private HubIdentityStorage hubIdentityStorage;
    @Autowired
    private CodecInitializer codecInitializer;
    @Autowired(required=false)
    private PolygonContractGasProvider polygonContractGasProvider;
    private TransactionManager transactionManager;
    private TransactionReceiptProcessor transactionReceiptProcessor;

    public String getOrCreateHubAddress() {
        String hubAddress = this.hubIdentityStorage.getHubAddress();
        if (StringUtils.startsWith((CharSequence)hubAddress, (CharSequence)"0x")) {
            return hubAddress;
        }
        return this.createHubWallet();
    }

    public String signHubMessage(String rawRequest) throws WomException {
        byte[] encodedRequest = rawRequest.getBytes(StandardCharsets.UTF_8);
        Sign.SignatureData signatureData = Sign.signPrefixedMessage((byte[])encodedRequest, (ECKeyPair)this.getHubWallet());
        byte[] retval = new byte[65];
        System.arraycopy(signatureData.getR(), 0, retval, 0, 32);
        System.arraycopy(signatureData.getS(), 0, retval, 32, 32);
        System.arraycopy(signatureData.getV(), 0, retval, 64, 1);
        return Numeric.toHexString((byte[])retval);
    }

    public long sendReportTransaction(HubReportPayload report, String uemAddress, long uemNetworkId) throws WomException {
        BlockchainHubReport blockchainReport = new BlockchainHubReport(report.getHubAddress(), BigInteger.valueOf(report.getUsersCount()), BigInteger.valueOf(report.getRecipientsCount()), BigInteger.valueOf(report.getParticipantsCount()), BigInteger.valueOf(report.getAchievementsCount()), WalletUtils.convertToDecimals((double)report.getHubRewardAmount(), (int)this.getHubContractDecimals()), report.getRewardTokenAddress(), BigInteger.valueOf(report.getRewardTokenNetworkId()), BigInteger.valueOf(report.getFromDate().getEpochSecond()), BigInteger.valueOf(report.getToDate().getEpochSecond()));
        Function function = new Function(FUNC_ADDREPORT, Arrays.asList(new Type[]{blockchainReport}), Collections.emptyList());
        RemoteFunctionCall<TransactionReceipt> remoteCall = ContractUtils.executeRemoteCallTransaction(this.getTransactionManager(), this.polygonContractGasProvider, this.getTransactionReceiptProcessor(), function, uemAddress, uemNetworkId);
        try {
            TransactionReceipt receipt = (TransactionReceipt)remoteCall.send();
            if (receipt == null) {
                throw new WomException("uem.sendReportFailedWithoutReceipt");
            }
            if (!receipt.isStatusOK()) {
                String message = this.getUemContractMessage(receipt.getRevertReason());
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    throw new WomException(message);
                }
                message = this.getUemContractMessage(receipt.getStatus());
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    throw new WomException(message);
                }
                throw new WomException("uem.sendReportTransactionFailed");
            }
            List<ContractUtils.ReportSentEventResponse> reportSentEvents = ContractUtils.getReportSentEvents(receipt);
            return reportSentEvents.get((int)0).reportId.longValue();
        }
        catch (Exception e) {
            String message = this.getUemContractExceptionMessage(e);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                throw new WomException(message);
            }
            throw new IllegalStateException("Error While processing Deed Update transaction", e);
        }
    }

    private ECKeyPair getHubWallet() throws WomException {
        String hubWalletString = this.hubIdentityStorage.getHubWallet();
        try {
            hubWalletString = this.codecInitializer.getCodec().decode(hubWalletString);
            WalletFile hubWallet = (WalletFile)JsonUtils.fromJsonString((String)hubWalletString, WalletFile.class);
            return Wallet.decrypt((String)this.walletAccountService.getAdminAccountPassword(), (WalletFile)hubWallet);
        }
        catch (TokenServiceInitializationException | CipherException e) {
            throw new WomException("wom.unableToAccessHubWallet");
        }
    }

    private String createHubWallet() throws WomException {
        try {
            ECKeyPair ecKeyPair = this.getAdminWalletKeys();
            return this.saveHubWallet(ecKeyPair);
        }
        catch (Exception e) {
            throw new WomException("wom.unableCreateHubWallet", e);
        }
    }

    private String saveHubWallet(ECKeyPair ecKeyPair) {
        if (ecKeyPair == null) {
            return null;
        }
        String walletPassword = this.walletAccountService.getAdminAccountPassword();
        WalletFile hubWalletFile = Wallet.createStandard((String)walletPassword, (ECKeyPair)ecKeyPair);
        String walletFileJson = JsonUtils.toJsonString((Object)hubWalletFile);
        walletFileJson = this.codecInitializer.getCodec().encode(walletFileJson);
        Object address = hubWalletFile.getAddress();
        if (!StringUtils.startsWith((CharSequence)address, (CharSequence)"0x")) {
            address = "0x" + (String)address;
        }
        this.hubIdentityStorage.saveHubWallet((String)address, walletFileJson);
        return address;
    }

    private ECKeyPair getAdminWalletKeys() {
        String privateKey = this.walletAccountService.getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin");
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            return null;
        }
        WalletFile adminWallet = null;
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            adminWallet = (WalletFile)objectMapper.readerFor(WalletFile.class).readValue(privateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing admin wallet keys", e);
        }
        try {
            return Wallet.decrypt((String)this.walletAccountService.getAdminAccountPassword(), (WalletFile)adminWallet);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't descrypt stored admin wallet", e);
        }
    }

    private String getUemContractExceptionMessage(Throwable e) {
        if (e != null) {
            String message = this.getUemContractMessage(e.getMessage());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                return message;
            }
            if (e.getCause() != null) {
                return this.getUemContractExceptionMessage(e.getCause());
            }
        }
        return null;
    }

    private String getUemContractMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return null;
        }
        Matcher matcher = Pattern.compile("uem\\.[a-zA-Z0-9]+").matcher(message);
        if (matcher.find()) {
            return matcher.group();
        }
        return this.getWomContractMessage(message);
    }

    private String getWomContractMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return null;
        }
        Matcher matcher = Pattern.compile("wom\\.[a-zA-Z0-9]+").matcher(message);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private int getHubContractDecimals() {
        return WalletUtils.getSettings().getContractDetail().getDecimals();
    }

    private TransactionManager getTransactionManager() throws WomException {
        if (this.transactionManager == null) {
            this.transactionManager = new RawTransactionManager(this.polygonContractGasProvider.getWeb3j(), Credentials.create((ECKeyPair)this.getHubWallet()), this.polygonContractGasProvider.getChainId());
        }
        return this.transactionManager;
    }

    private TransactionReceiptProcessor getTransactionReceiptProcessor() {
        if (this.transactionReceiptProcessor == null) {
            this.transactionReceiptProcessor = new PollingTransactionReceiptProcessor(this.polygonContractGasProvider.getWeb3j(), 15000L, 40);
        }
        return this.transactionReceiptProcessor;
    }

    @Generated
    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Generated
    public void setTransactionReceiptProcessor(TransactionReceiptProcessor transactionReceiptProcessor) {
        this.transactionReceiptProcessor = transactionReceiptProcessor;
    }
}

