/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.renderer;

import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.social.link.model.LinkData;
import io.meeds.social.link.service.LinkService;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinkPortletInstancePreferencePlugin
implements PortletInstancePreferencePlugin {
    private static final String CMS_SETTING_PREFERENCE_NAME = "name";
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    @Autowired
    private LinkService linkService;

    @Override
    public String getPortletName() {
        return "Links";
    }

    @Override
    public List<PortletInstancePreference> generatePreferences(Application<Portlet> application, Portlet preferences) {
        String settingName = this.getCmsSettingName(preferences);
        if (StringUtils.isBlank((CharSequence)settingName)) {
            return Collections.emptyList();
        }
        LinkData linkData = this.linkService.getLinkData(settingName);
        return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, JsonUtils.toJsonString((Object)linkData)));
    }

    private String getCmsSettingName(Portlet preferences) {
        if (preferences == null) {
            return null;
        }
        Preference settingNamePreference = preferences.getPreference(CMS_SETTING_PREFERENCE_NAME);
        return settingNamePreference == null ? null : settingNamePreference.getValue();
    }
}

