/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class XSiteStateTransferConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<XSiteStateTransferConfiguration> {
    public static final int DEFAULT_CHUNK_SIZE = (Integer)XSiteStateTransferConfiguration.CHUNK_SIZE.getDefaultValue();
    public static final long DEFAULT_TIMEOUT = (Long)XSiteStateTransferConfiguration.TIMEOUT.getDefaultValue();
    public static final int DEFAULT_MAX_RETRIES = (Integer)XSiteStateTransferConfiguration.MAX_RETRIES.getDefaultValue();
    public static final long DEFAULT_WAIT_TIME = (Long)XSiteStateTransferConfiguration.WAIT_TIME.getDefaultValue();
    private final BackupConfigurationBuilder backupConfigurationBuilder;
    private final AttributeSet attributes = XSiteStateTransferConfiguration.attributeDefinitionSet();

    public XSiteStateTransferConfigurationBuilder(ConfigurationBuilder builder, BackupConfigurationBuilder backupConfigurationBuilder) {
        super(builder);
        this.backupConfigurationBuilder = backupConfigurationBuilder;
    }

    public void validate() {
        if ((Long)this.attributes.attribute(XSiteStateTransferConfiguration.TIMEOUT).get() <= 0L) {
            throw new CacheConfigurationException("Timeout must be higher or equals than 1 (one).");
        }
        if ((Long)this.attributes.attribute(XSiteStateTransferConfiguration.WAIT_TIME).get() <= 0L) {
            throw new CacheConfigurationException("Waiting time between retries must be higher or equals than 1 (one).");
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public final XSiteStateTransferConfigurationBuilder chunkSize(int chunkSize) {
        this.attributes.attribute(XSiteStateTransferConfiguration.CHUNK_SIZE).set((Object)chunkSize);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder timeout(long timeout) {
        this.attributes.attribute(XSiteStateTransferConfiguration.TIMEOUT).set((Object)timeout);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder maxRetries(int maxRetries) {
        this.attributes.attribute(XSiteStateTransferConfiguration.MAX_RETRIES).set((Object)maxRetries);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder waitTime(long waitingTimeBetweenRetries) {
        this.attributes.attribute(XSiteStateTransferConfiguration.WAIT_TIME).set((Object)waitingTimeBetweenRetries);
        return this;
    }

    public final BackupConfigurationBuilder backup() {
        return this.backupConfigurationBuilder;
    }

    public XSiteStateTransferConfiguration create() {
        return new XSiteStateTransferConfiguration(this.attributes.protect());
    }

    public Builder<XSiteStateTransferConfiguration> read(XSiteStateTransferConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.attributes;
    }
}

