/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.settings.data;

import java.io.Serializable;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class Context
implements Cloneable,
Serializable {
    public static final Context GLOBAL = new Context("GLOBAL", "GLOBAL");
    public static final Context USER = new Context("USER", null);
    private String id;
    private String name;

    public Context(String name, String id) {
        this.id = id;
        this.name = name;
    }

    public Context id(String id) {
        Context result = null;
        try {
            result = (Context)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.id = id;
        return result;
    }

    public String getId() {
        if (this.id == null && USER.getName().equals(this.getName())) {
            String currentId;
            ConversationState state = ConversationState.getCurrent();
            String string = currentId = state == null ? null : state.getIdentity().getUserId();
            if (currentId != null && (IdentityConstants.SYSTEM.contentEquals(currentId) || IdentityConstants.ANONIM.contentEquals(currentId))) {
                currentId = null;
            }
            return currentId;
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context that = (Context)o;
        return that.hashCode() == this.hashCode();
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

