/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.listener;

import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.ContractTransactionEvent;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletTransactionService;

@Asynchronous
public class ContractTransactionMinedListener
extends Listener<String, ContractTransactionEvent> {
    private static final Log LOG = ExoLogger.getLogger(ContractTransactionMinedListener.class);
    private WalletTransactionService walletTransactionService;
    private BlockchainTransactionService blockchainTransactionService;

    public ContractTransactionMinedListener(WalletTransactionService walletTransactionService, BlockchainTransactionService blockchainTransactionService) {
        this.walletTransactionService = walletTransactionService;
        this.blockchainTransactionService = blockchainTransactionService;
    }

    public void onEvent(Event<String, ContractTransactionEvent> event) throws Exception {
        ContractTransactionEvent contractEvent = (ContractTransactionEvent)event.getData();
        String transactionHash = contractEvent.getTransactionHash();
        TransactionDetail transactionDetail = this.walletTransactionService.getTransactionByHash(transactionHash);
        if (transactionDetail != null) {
            if (transactionDetail.isPending() || !transactionDetail.isSucceeded()) {
                LOG.debug("Transaction with hash {} has been mined successfully", new Object[]{transactionDetail.getHash()});
                this.blockchainTransactionService.addTransactionToRefreshFromBlockchain(transactionDetail);
            }
        } else if (this.blockchainTransactionService.hasManagedWalletInTransaction(contractEvent)) {
            this.blockchainTransactionService.refreshTransactionFromBlockchain(transactionHash);
        }
    }
}

