/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class LinkProvider {
    public static final String RESOURCE_URL = "/social-resources";
    public static final String JAVASCRIPT_RESOURCE_URL = "/social-resources/javascript/";
    public static final String PROFILE_DEFAULT_AVATAR_URL = "/platform-ui/skin/images/avatar/DefaultUserAvatar.png";
    public static final String SPACE_DEFAULT_AVATAR_URL = "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
    public static final String HAS_CONNECTION_ICON = "/social-resources/platform-ui/skin/images/themes/default/social/skin/UIManageUsers/StatusIcon.png";
    public static final String WAITING_CONFIRMATION_ICON = "/social-resources/platform-ui/skin/images/themes/default/social/skin/UIManageUsers/WaittingConfirm.png";
    public static final String SPACE_MANAGER_ICON = "/social-resources/platform-ui/skin/images/themes/default/social/skin/UIManageSpaces/Manager.png";
    public static final String SPACE_MEMBER_ICON = "/social-resources/platform-ui/skin/images/themes/default/social/skin/UIManageSpaces/Member.png";
    public static final String SPACE_WAITING_CONFIRM_ICON = "/social-resources/platform-ui/skin/images/themes/default/social/skin/UIManageSpaces/WaitingConfirm.png";
    public static final String STARTER_ACTIVITY_AVATAR = "/platform-ui/skin/images/themes/default/social/skin/Activity/starterAvt.png";
    public static final String STARTER_ACTIVITY_IMAGE = "/platform-ui/skin/images/themes/default/social/skin/Activity/welcome-img.png";
    public static final String ROUTE_DELIMITER = "/";
    public static final long DEFAULT_IMAGES_LAST_MODIFED = System.currentTimeMillis();
    public static final String DEFAULT_IMAGE_REMOTE_ID = "default-image";
    private static final Log LOG = ExoLogger.getLogger(LinkProvider.class);
    private static final String BASE_URL_SOCIAL_REST_API = "/v1/social";
    private static String baseURLSocialUserRest;
    private static String baseURLSocialSpaceRest;
    public static final String TYPE = "file";
    public static final String BASE_URL_SITE_REST_API = "/v1/social/sites";
    public static final String ATTACHMENT_BANNER_TYPE = "banner";

    private LinkProvider() {
    }

    public static String getSpaceUri(String prettyName) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceByPrettyName(prettyName);
        RequestContext ctx = RequestContext.getCurrentInstance();
        if (ctx != null && space != null) {
            NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
            NavigationResource resource = new NavigationResource(SiteType.GROUP, space.getGroupId(), space.getUrl());
            return nodeURL.setResource(resource).toString();
        }
        return null;
    }

    public static String getProfileUri(String username) {
        return LinkProvider.buildProfileUri(username, null, null);
    }

    public static String getProfileUri(String username, String portalOwner) {
        return LinkProvider.buildProfileUri(username, null, portalOwner);
    }

    public static String getProfileLink(String username) {
        return LinkProvider.getProfileLink(username, null);
    }

    public static String getProfileLink(String username, String portalOwner) {
        String configuredDomainUrl;
        Identity identity = LinkProvider.getIdentityManager().getOrCreateIdentity("organization", username);
        Validate.notNull((Object)identity, (String)"Identity must not be null.", (Object[])new Object[0]);
        String lang = LinkProvider.getCurrentUserLanguage(username);
        try {
            configuredDomainUrl = CommonsUtils.getCurrentDomain();
        }
        catch (NullPointerException e) {
            configuredDomainUrl = null;
        }
        StringBuilder profileLink = new StringBuilder("<a class=\"user-suggester\" href=\"");
        profileLink.append(configuredDomainUrl != null ? configuredDomainUrl : "").append(LinkProvider.buildProfileUri(identity.getRemoteId(), null, portalOwner)).append("\" target=\"_parent\"").append(" v-identity-popover=\"{").append("id: '").append(identity.getId()).append("',").append("username: '").append(identity.getRemoteId()).append("',").append("fullName: '").append(identity.getProfile().getFullName().replace("'", "\\\\'")).append("',").append("avatar: '").append(identity.getProfile().getAvatarUrl()).append("',").append("position: '").append(identity.getProfile().getPosition() == null ? "" : identity.getProfile().getPosition().replace("'", "\\\\'")).append("',").append("external: '").append(identity.getProfile().getProperty("external") != null && StringUtils.equals((CharSequence)"true", (CharSequence)String.valueOf(identity.getProfile().getProperty("external")))).append("',").append("enabled: '").append(identity.isEnable() && !identity.isDeleted()).append("',").append("}\"").append(">").append(StringEscapeUtils.escapeHtml4((String)identity.getProfile().getFullName()));
        if (identity.getProfile().getProperty("external") != null && identity.getProfile().getProperty("external").equals("true")) {
            profileLink = profileLink.append("<span \" class=\"externalFlagClass\">").append(" (").append(LinkProvider.getResourceBundleLabel(Locale.forLanguageTag(lang), "external.label.tag")).append(")").append("</span>");
        }
        return profileLink.append("</a>").toString();
    }

    public static String getGroupRoleLink(String role, String identityId, Locale locale) {
        Identity identity = LinkProvider.getIdentityManager().getIdentity(identityId);
        StringBuilder profileLink = new StringBuilder("<a class=\"user-suggester group-role-mention\" ");
        return profileLink.append("href=\"").append(LinkProvider.getGroupUrl(identity, role)).append("\" data-identity-id=\"").append(identityId).append("\"").append(" data-role=\"").append(role).append("\">").append("<i aria-hidden=\"true\" class=\"v-icon fa ").append(LinkProvider.getRoleIcon(role)).append("\" style=\"font-size: var(--appTextFontSize, var(--allPagesBaseTextFontSize, 16px));\"></i> ").append(LinkProvider.getGroupRoleLabel(role, locale)).append("</a>").toString();
    }

    public static String getGroupRoleLabel(String role, Locale locale) {
        if (locale == null) {
            locale = LinkProvider.getDefaultLocale();
        }
        return "<span class=\"group-role-label\">" + LinkProvider.getResourceBundleLabel(locale, role + "s") + "</span>";
    }

    public static String getAbsoluteProfileUrl(String userName, String portalName, String portalOwner, String host) {
        return host + LinkProvider.buildProfileUri(userName, portalName, portalOwner);
    }

    public static String getUserActivityUri(String remoteId) {
        return LinkProvider.getActivityUri("organization", remoteId);
    }

    public static String getUserProfileUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/profile/" + remoteId;
    }

    public static String getActivityUri(String providerId, String remoteId) {
        String prefix = LinkProvider.getBaseUri(null, null) + ROUTE_DELIMITER;
        if (providerId.equals("organization")) {
            return String.format("%sactivities/%s", prefix, remoteId);
        }
        if (providerId.equals("space")) {
            return String.format("/%s/g/:spaces:%s/%s", LinkProvider.getPortalName(null), remoteId, remoteId);
        }
        LOG.warn((Object)("Failed to getActivityLink with providerId: " + providerId));
        return null;
    }

    public static String getSingleActivityUrl(String activityId) {
        return LinkProvider.getBaseUri(null, null) + "/activity?id=" + activityId;
    }

    public static String getActivityUriForSpace(String remoteId, String groupId) {
        return String.format("/%s/g/:spaces:%s/%s", LinkProvider.getPortalName(null), groupId, remoteId);
    }

    private static String buildProfileUri(String userName, String portalName, String portalOwner) {
        return LinkProvider.getBaseUri(portalName, portalOwner) + "/profile/" + userName;
    }

    private static String getBaseUri(String portalName, String portalOwner) {
        return ROUTE_DELIMITER + LinkProvider.getPortalName(portalName) + ROUTE_DELIMITER + LinkProvider.getPortalOwner(portalOwner);
    }

    private static String getSpaceBaseUri(String portalName, String portalOwner) {
        return ROUTE_DELIMITER + LinkProvider.getPortalName(portalName);
    }

    public static String getUserNotificationSettingUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/settings";
    }

    public static String getRedirectUri(String type) {
        if (type.isEmpty()) {
            return LinkProvider.getBaseUri(null, null);
        }
        return LinkProvider.getBaseUri(null, null) + ROUTE_DELIMITER + type;
    }

    public static String getRedirectSpaceUri(String type) {
        if (type.isEmpty()) {
            return LinkProvider.getSpaceBaseUri(null, null);
        }
        return LinkProvider.getSpaceBaseUri(null, null) + ROUTE_DELIMITER + type;
    }

    public static IdentityManager getIdentityManager() {
        return (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    }

    public static SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getService(SpaceService.class);
    }

    @Deprecated
    public static String buildAvatarURL(String providerId, String remoteId) {
        return LinkProvider.buildAttachmentUrl(providerId, remoteId, false, null, "avatar");
    }

    public static String buildAvatarURL(String providerId, String remoteId, Long lastModifiedDate) {
        return LinkProvider.buildAttachmentUrl(providerId, remoteId, false, lastModifiedDate, "avatar");
    }

    public static String buildAvatarURL(String providerId, String id, boolean byId, Long lastModifiedDate) {
        return LinkProvider.buildAttachmentUrl(providerId, id, byId, lastModifiedDate, "avatar");
    }

    @Deprecated
    public static String buildBannerURL(String providerId, String id) {
        return LinkProvider.buildAttachmentUrl(providerId, id, false, null, ATTACHMENT_BANNER_TYPE);
    }

    public static String buildBannerURL(String providerId, String id, Long lastModifiedDate) {
        return LinkProvider.buildAttachmentUrl(providerId, id, false, lastModifiedDate, ATTACHMENT_BANNER_TYPE);
    }

    public static String buildBannerURL(String providerId, String id, boolean byId, Long lastModifiedDate) {
        return LinkProvider.buildAttachmentUrl(providerId, id, byId, lastModifiedDate, ATTACHMENT_BANNER_TYPE);
    }

    private static String buildAttachmentUrl(String providerId, String id, boolean byId, Long lastModifiedDate, String type) {
        String lastModifiedString;
        String token;
        if (providerId == null || id == null) {
            return null;
        }
        if (providerId.equals("spaceTemplates")) {
            return LinkProvider.getBaseURLSocialRest() + ROUTE_DELIMITER + providerId + ROUTE_DELIMITER + id + ROUTE_DELIMITER + type + "?lastModified=" + DEFAULT_IMAGES_LAST_MODIFED;
        }
        try {
            id = URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn((Object)"Failure to encode username for build URL", (Throwable)ex);
        }
        if (lastModifiedDate == null || lastModifiedDate <= 0L || lastModifiedDate == DEFAULT_IMAGES_LAST_MODIFED) {
            id = DEFAULT_IMAGE_REMOTE_ID;
            lastModifiedDate = DEFAULT_IMAGES_LAST_MODIFED;
        }
        if (StringUtils.isNotBlank((CharSequence)(token = LinkProvider.generateAttachmentToken(providerId, id, type, lastModifiedString = String.valueOf(lastModifiedDate))))) {
            try {
                token = URLEncoder.encode(token, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)"Error encoding token", (Throwable)e);
                token = "";
            }
        }
        if (providerId.equals("organization")) {
            StringBuilder urlBuilder = new StringBuilder(LinkProvider.getBaseURLSocialUserRest());
            urlBuilder.append(ROUTE_DELIMITER).append(id).append(ROUTE_DELIMITER).append(type).append("?lastModified=").append(lastModifiedString).append("&r=").append(token);
            if (byId) {
                urlBuilder.append("&byId=true");
            }
            return urlBuilder.toString();
        }
        if (providerId.equals("space")) {
            StringBuilder urlBuilder = new StringBuilder(LinkProvider.getBaseURLSocialSpaceRest());
            urlBuilder.append(ROUTE_DELIMITER).append(id).append(ROUTE_DELIMITER).append(type).append("?lastModified=").append(lastModifiedString).append("&r=").append(token);
            if (byId) {
                urlBuilder.append("&byId=true");
            }
            return urlBuilder.toString();
        }
        return null;
    }

    public static String generateAttachmentToken(String providerId, String remoteId, String attachmentType, String lastModifiedDate) {
        String token = null;
        CodecInitializer codecInitializer = (CodecInitializer)ExoContainerContext.getService(CodecInitializer.class);
        if (codecInitializer == null) {
            LOG.debug((Object)"Can't find an instance of CodecInitializer, an empty token will be generated");
            token = "";
        } else {
            try {
                String tokenPlain = attachmentType + ":" + providerId + ":" + remoteId + ":" + lastModifiedDate;
                token = codecInitializer.getCodec().encode(tokenPlain);
            }
            catch (TokenServiceInitializationException e) {
                LOG.warn("Error generating token of {} for identity '{}:{}'. An empty token will be used", new Object[]{attachmentType, remoteId, e});
                token = "";
            }
        }
        return token;
    }

    public static boolean isAttachmentTokenValid(String token, String providerId, String remoteId, String attachmentType, String lastModifiedDate) {
        if (StringUtils.isBlank((CharSequence)token)) {
            LOG.warn("An empty token is used for {} for identity '{}:{}'", new Object[]{attachmentType, remoteId});
            return false;
        }
        String validToken = LinkProvider.generateAttachmentToken(providerId, remoteId, attachmentType, lastModifiedDate);
        return StringUtils.equals((CharSequence)validToken, (CharSequence)token);
    }

    public static String getPortalOwner(String portalOwner) {
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            portalOwner = CommonsUtils.getCurrentPortalOwner();
        }
        return portalOwner;
    }

    public static String getPortalName(String portalName) {
        if (portalName == null || portalName.trim().length() == 0) {
            return PortalContainer.getCurrentPortalContainerName();
        }
        return portalName;
    }

    public static String getBaseURLSocialSpaceRest() {
        if (baseURLSocialSpaceRest == null) {
            baseURLSocialSpaceRest = LinkProvider.getBaseURLSocialRest() + "/spaces";
        }
        return baseURLSocialSpaceRest;
    }

    public static String getBaseURLSocialUserRest() {
        if (baseURLSocialUserRest == null) {
            baseURLSocialUserRest = LinkProvider.getBaseURLSocialRest() + "/users";
        }
        return baseURLSocialUserRest;
    }

    public static String getBaseURLSocialRest() {
        return ROUTE_DELIMITER + PortalContainer.getCurrentPortalContainerName() + ROUTE_DELIMITER + PortalContainer.getCurrentRestContextName() + BASE_URL_SOCIAL_REST_API;
    }

    public static String getCurrentUserLanguage(String userId) {
        try {
            LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
            LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
            String lang = null;
            if (localePolicy != null) {
                Locale locale = localePolicy.determineLocale(localeCtx);
                lang = locale.toString();
            }
            return lang;
        }
        catch (Exception e) {
            LOG.error((Object)("Error searching user " + userId), (Throwable)e);
            return null;
        }
    }

    public static String getResourceBundleLabel(Locale locale, String label) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        try {
            return resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), locale).getString(label);
        }
        catch (MissingResourceException e) {
            return label;
        }
    }

    public static Locale getDefaultLocale() {
        LocaleConfigService localeConfigService = (LocaleConfigService)ExoContainerContext.getService(LocaleConfigService.class);
        return localeConfigService.getDefaultLocaleConfig().getLocale();
    }

    public static String getBaseURLSiteRest() {
        return ROUTE_DELIMITER + PortalContainer.getCurrentPortalContainerName() + ROUTE_DELIMITER + PortalContainer.getCurrentRestContextName() + BASE_URL_SITE_REST_API;
    }

    public static String buildSiteBannerUrl(String siteName, long bannerFileId) {
        if (StringUtils.isBlank((CharSequence)siteName)) {
            return null;
        }
        boolean isDefault = bannerFileId == 0L;
        Object bannerParam = isDefault ? " " : "&bannerId=" + bannerFileId;
        return LinkProvider.getBaseURLSiteRest() + ROUTE_DELIMITER + siteName + ROUTE_DELIMITER + ATTACHMENT_BANNER_TYPE + "?isDefault=" + isDefault + (String)bannerParam;
    }

    private static String getGroupUrl(Identity identity, String role) {
        String configuredDomainUrl;
        if (!identity.isSpace()) {
            return "#";
        }
        try {
            configuredDomainUrl = CommonsUtils.getCurrentDomain();
        }
        catch (Exception e) {
            configuredDomainUrl = "";
        }
        PermanentLinkObject object = new PermanentLinkObject("space", identity.getRemoteId());
        object.addParameter("applicationUri", "members");
        object.addParameter("hash", role);
        PermanentLinkService permanentLinkService = (PermanentLinkService)ExoContainerContext.getService(PermanentLinkService.class);
        return configuredDomainUrl + permanentLinkService.getLink(object);
    }

    private static String getRoleIcon(String role) {
        return switch (role) {
            case "member" -> "fa-users";
            case "manager" -> "fa-user-cog";
            case "redactor" -> "fa-user-edit";
            case "publisher" -> "fa-paper-plane";
            default -> "";
        };
    }
}

