/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.gamification;

import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.social.BaseActivityPwaNotificationPlugin;
import io.meeds.social.translation.service.TranslationService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"gamification"})
@Component
public class GamificationActionAnnouncedPwaNotificationPlugin
extends BaseActivityPwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.GamificationActionAnnouncedNotification.title";
    @Autowired
    private RuleService ruleService;
    @Autowired
    private RealizationService realizationService;
    @Autowired
    private TranslationService translationService;

    public String getId() {
        return "GamificationActionAnnouncedNotification";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        long realizationId = Long.parseLong(notification.getValueOwnerParameter("ANNOUNCEMENT_ID"));
        RealizationDTO realization = this.realizationService.getRealizationById(realizationId);
        Identity earner = this.identityManager.getIdentity(realization.getEarnerId());
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", earner.getProfile().getFullName()));
        String ruleTitle = this.translationService.getTranslationLabel("rule", realization.getRuleId().longValue(), "title", localeConfig.getLocale());
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            ruleTitle = this.ruleService.findRuleById(realization.getRuleId().longValue()).getTitle();
        }
        notificationMessage.setBody(ruleTitle);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(new PermanentLinkObject("activity", activityId)));
        super.process(notificationMessage, notification, localeConfig);
        return notificationMessage;
    }
}

