/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.permlink.web;

import io.meeds.portal.permlink.service.PermanentLinkService;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.security.sso.SSOHelper;

public class PermanentLinkRequestHandler
extends WebRequestHandler {
    protected static final Log LOG = ExoLogger.getLogger(PermanentLinkRequestHandler.class);
    public static final QualifiedName REQUEST_PATH = QualifiedName.create((String)"path");
    private PermanentLinkService permanentLinkService;
    private UserPortalConfigService userPortalConfigService;

    public String getHandlerName() {
        return "permanent-link";
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        this.permanentLinkService = (PermanentLinkService)ExoContainerContext.getService(PermanentLinkService.class);
        this.userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
    }

    public boolean execute(ControllerContext context) throws Exception {
        String requestPath = context.getParameter(REQUEST_PATH);
        Identity currentIdentity = this.getCurrentIdentity();
        try {
            String directAccessUrl = this.permanentLinkService.getDirectAccessUrl(requestPath, currentIdentity);
            HttpServletResponse res = context.getResponse();
            res.sendRedirect(directAccessUrl);
        }
        catch (IllegalAccessException e) {
            if (currentIdentity == null || StringUtils.equals((CharSequence)IdentityConstants.ANONIM, (CharSequence)currentIdentity.getUserId())) {
                String loginPath = this.getAuthenticationUrl(context.getRequest().getRequestURI());
                context.getResponse().sendRedirect(loginPath);
            } else {
                LOG.warn("Error while handling permanent link '{}' redirecting to not found page", new Object[]{requestPath, e});
                context.getResponse().sendRedirect(String.format("/portal/%s/page-not-found", this.userPortalConfigService.getMetaPortal()));
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Error while handling permanent link '{}'", new Object[]{requestPath, e});
            context.getResponse().sendRedirect(String.format("/portal/%s/page-not-found", this.userPortalConfigService.getMetaPortal()));
        }
        return true;
    }

    public String getAuthenticationUrl(String permanentLink) {
        StringBuilder loginPath = new StringBuilder();
        SSOHelper ssoHelper = (SSOHelper)ExoContainerContext.getService(SSOHelper.class);
        if (ssoHelper != null && ssoHelper.isSSOEnabled() && ssoHelper.skipJSPRedirection()) {
            loginPath.append("/portal").append(ssoHelper.getSSORedirectURLSuffix());
        } else {
            loginPath.append("/portal/login");
        }
        loginPath.append("?initialURI=").append(URLEncoder.encode(permanentLink, StandardCharsets.UTF_8));
        return loginPath.toString();
    }

    private Identity getCurrentIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null ? null : conversationState.getIdentity();
    }
}

