/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.page.PageTemplatePlugin;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;

public class PageTemplateService {
    private List<SelectItemCategory<String>> categories = new ArrayList<SelectItemCategory<String>>();

    public void addPageTemplate(PageTemplatePlugin pageTemplatePlugin) {
        if (pageTemplatePlugin == null) {
            throw new IllegalArgumentException("Plugin is empty");
        }
        if (pageTemplatePlugin.getCategory() == null) {
            return;
        }
        SelectItemCategory<String> category = pageTemplatePlugin.getCategory();
        SelectItemCategory foundCategory = this.categories.stream().filter(existingCategory -> StringUtils.equals((CharSequence)existingCategory.getName(), (CharSequence)category.getName())).findAny().orElse(null);
        if (foundCategory == null) {
            this.categories.add(category);
            if (category.getSelectItemOptions() == null) {
                category.setSelectItemOptions(new ArrayList());
            }
        } else {
            foundCategory.getSelectItemOptions().addAll(category.getSelectItemOptions());
        }
    }

    public List<SelectItemCategory<String>> getPageTemplateCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public List<SelectItemOption<String>> getPageTemplates() {
        return this.categories.stream().map(SelectItemCategory::getSelectItemOptions).flatMap(Collection::stream).toList();
    }
}

