/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UISiteBody.gtmpl")
public class UISiteBody
extends UIComponentDecorator {
    private String storageId;

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext requestContext = (PortalRequestContext)RequestContext.getCurrentInstance();
        if (this.isShowSiteBody(requestContext)) {
            this.processContainerRender(context);
        } else {
            this.processPageBodyRender(context);
        }
    }

    public String getSiteClass() {
        String portalOwner = ((PortalRequestContext)RequestContext.getCurrentInstance()).getPortalOwner();
        if (StringUtils.isBlank((CharSequence)portalOwner)) {
            return "";
        }
        return portalOwner.toUpperCase() + "Site";
    }

    @Override
    public UIComponent getUIComponent() {
        return PortalRequestContext.getCurrentInstance().getUiPortal();
    }

    public UIPortal getUIPortal() {
        return (UIPortal)this.getUIComponent();
    }

    @Override
    protected void setChildComponent(UIComponent uicomponent) {
        PortalRequestContext.getCurrentInstance().setUiPortal((UIPortal)uicomponent);
    }

    protected boolean isShowSiteBody(PortalRequestContext requestContext) {
        return !requestContext.isShowMaxWindow() && (Util.getUIPage() == null || !Util.getUIPage().isShowMaxWindow());
    }

    protected void processPageBodyRender(WebuiRequestContext context) throws Exception {
        UIPageBody uiPageBody = this.findFirstComponentOfType(UIPageBody.class);
        uiPageBody.processRender(context);
    }

    protected void processContainerRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }
}

