/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.management;

import java.util.List;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.EntityNotFoundException;
import org.gatein.api.Portal;
import org.gatein.api.common.Pagination;
import org.gatein.api.management.Utils;
import org.gatein.api.page.Page;
import org.gatein.api.page.PageId;
import org.gatein.api.page.PageQuery;
import org.gatein.api.security.Permission;
import org.gatein.api.site.SiteId;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.annotations.Managed;
import org.gatein.management.api.annotations.ManagedContext;
import org.gatein.management.api.annotations.ManagedOperation;
import org.gatein.management.api.annotations.ManagedRole;
import org.gatein.management.api.annotations.MappedAttribute;
import org.gatein.management.api.annotations.MappedPath;
import org.gatein.management.api.model.ModelList;
import org.gatein.management.api.model.ModelObject;
import org.gatein.management.api.model.ModelProvider;
import org.gatein.management.api.model.ModelReference;
import org.gatein.management.api.model.ModelString;

@Managed
public class PageManagementResource {
    private final Portal portal;
    private final ModelProvider modelProvider;
    private final SiteId siteId;
    private final PageQuery pagesQuery;

    public PageManagementResource(Portal portal, ModelProvider modelProvider, SiteId siteId) {
        this.portal = portal;
        this.modelProvider = modelProvider;
        this.siteId = siteId;
        this.pagesQuery = new PageQuery.Builder().withSiteId(siteId).build();
    }

    @Managed(description="Retrieves all pages for given site")
    public ModelList getPages(@ManagedContext PathAddress address, @MappedAttribute(value="offset") String offsetParam, @MappedAttribute(value="limit") String limitParam) {
        Pagination pagination = Utils.getPagination(offsetParam, limitParam, this.pagesQuery.getPagination());
        List pages = this.portal.findPages(new PageQuery.Builder().from(this.pagesQuery).withPagination(pagination).build());
        return this.populateModel(pages, (ModelList)this.modelProvider.newModel(ModelList.class), address);
    }

    @Managed(value="{page-name}")
    public ModelObject getPage(@MappedPath(value="page-name") String name) {
        PageId pageId = new PageId(this.siteId, name);
        Page page = this.portal.getPage(pageId);
        if (page == null) {
            throw Utils.notFound("Could not retrieve page", pageId);
        }
        return this.populateModel(page, (ModelObject)this.modelProvider.newModel(ModelObject.class));
    }

    @Managed(value="{page-name}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="remove-resource", description="Removes the given page from the portal")
    public void removePage(@MappedPath(value="page-name") String name) {
        PageId pageId = new PageId(this.siteId, name);
        try {
            if (!this.portal.removePage(pageId)) {
                throw Utils.notFound("Could not remove page", pageId);
            }
        }
        catch (EntityNotFoundException e) {
            throw Utils.notFound("Could not remove page", this.siteId);
        }
    }

    @Managed(value="{page-name}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="add-resource", description="Adds the given page to the portal")
    public ModelObject addPage(@MappedPath(value="page-name") String name) {
        Page page;
        PageId pageId = new PageId(this.siteId, name);
        try {
            page = this.portal.createPage(pageId);
        }
        catch (EntityAlreadyExistsException e) {
            throw Utils.alreadyExists("Could not add page", pageId);
        }
        catch (EntityNotFoundException e) {
            throw Utils.alreadyExists("Cannot add page", this.siteId);
        }
        this.portal.savePage(page);
        return this.populateModel(this.portal.getPage(pageId), (ModelObject)this.modelProvider.newModel(ModelObject.class));
    }

    @Managed(value="{page-name}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="update-resource", description="Updates a page of the portal")
    public ModelObject updatePage(@MappedPath(value="page-name") String name, @ManagedContext ModelObject pageModel) {
        Permission permission;
        PageId pageId = new PageId(this.siteId, name);
        Page page = this.portal.getPage(pageId);
        if (page == null) {
            throw Utils.notFound("Could not update page", pageId);
        }
        boolean changed = false;
        if (pageModel.has("displayName")) {
            ModelString displayNameModel = Utils.get(pageModel, ModelString.class, "displayName");
            page.setDisplayName(displayNameModel.getValue());
            changed = true;
        }
        if (pageModel.has("description")) {
            ModelString descModel = Utils.get(pageModel, ModelString.class, "description");
            page.setDescription(descModel.getValue());
            changed = true;
        }
        if (pageModel.has("access-permissions")) {
            permission = Utils.getPermission(pageModel, false, "access-permissions");
            page.setAccessPermission(permission);
            changed = true;
        }
        if (pageModel.has("edit-permissions")) {
            permission = Utils.getPermission(pageModel, true, "edit-permissions");
            page.setEditPermission(permission);
            changed = true;
        }
        if (changed) {
            this.portal.savePage(page);
        }
        return this.populateModel(this.portal.getPage(pageId), (ModelObject)this.modelProvider.newModel(ModelObject.class));
    }

    private ModelList populateModel(List<Page> pages, ModelList list, PathAddress address) {
        for (Page page : pages) {
            if (!Utils.hasPermission(page.getAccessPermission())) continue;
            ModelReference pageRef = (ModelReference)list.add().asValue(ModelReference.class);
            pageRef.set("name", page.getName());
            pageRef.set("siteType", page.getId().getSiteId().getType().name().toLowerCase());
            pageRef.set("siteName", page.getId().getSiteId().getName());
            pageRef.set(address.append(page.getName()));
        }
        return list;
    }

    private ModelObject populateModel(Page page, ModelObject model) {
        model.set("name", page.getName());
        model.set("displayName", page.getDisplayName());
        model.set("description", page.getDescription());
        Utils.populate("access-permissions", page.getAccessPermission(), model);
        Utils.populate("edit-permissions", page.getEditPermission(), model);
        return model;
    }
}

