/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class KuromojiStemmerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final int minimumLength;
    public static final JsonpDeserializer<KuromojiStemmerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiStemmerTokenFilter::setupKuromojiStemmerTokenFilterDeserializer);

    private KuromojiStemmerTokenFilter(Builder builder) {
        super(builder);
        this.minimumLength = ApiTypeHelper.requireNonNull(builder.minimumLength, this, "minimumLength");
    }

    public static KuromojiStemmerTokenFilter of(Function<Builder, ObjectBuilder<KuromojiStemmerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KuromojiStemmer;
    }

    public final int minimumLength() {
        return this.minimumLength;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_stemmer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("minimum_length");
        generator.write(this.minimumLength);
    }

    protected static void setupKuromojiStemmerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::minimumLength, JsonpDeserializer.integerDeserializer(), "minimum_length");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiStemmerTokenFilter> {
        private Integer minimumLength;

        public final Builder minimumLength(int value) {
            this.minimumLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiStemmerTokenFilter build() {
            this._checkSingleUse();
            return new KuromojiStemmerTokenFilter(this);
        }
    }
}

