/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.chain.web.ParameterMap;

public class MutableParameterMap<P, T>
extends ParameterMap<P, T> {
    private final Consumer<String> removeConsumer;
    private final BiConsumer<String, T> setConsumer;

    public MutableParameterMap(P parameter, Function<String, T> valueFunction, Supplier<Enumeration<String>> namesSupplier, Consumer<String> removeConsumer, BiConsumer<String, T> setConsumer) {
        super(parameter, valueFunction, namesSupplier);
        this.removeConsumer = removeConsumer;
        this.setConsumer = setConsumer;
    }

    @Override
    public void clear() {
        for (String key : this.keySet()) {
            this.removeConsumer.accept(key);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && super.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.entrySet(true);
    }

    @Override
    public T put(String key, T value) {
        if (value == null) {
            return this.remove(key);
        }
        Object previous = this.getValueFunction().apply(key);
        this.setConsumer.accept(key, (String)value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        map.forEach(this::put);
    }

    @Override
    public T remove(Object key) {
        String skey = MutableParameterMap.key(key);
        Object previous = this.getValueFunction().apply(skey);
        this.removeConsumer.accept(skey);
        return previous;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

