/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public interface CollectionPersister
extends Restrictable {
    public NavigableRole getNavigableRole();

    default public String getRole() {
        return this.getNavigableRole().getFullPath();
    }

    default public PluralAttributeMapping getAttributeMapping() {
        throw new UnsupportedOperationException("CollectionPersister used for [" + this.getRole() + "] does not support SQL AST");
    }

    public EntityPersister getOwnerEntityPersister();

    public void initialize(Object var1, SharedSessionContractImplementor var2) throws HibernateException;

    public boolean hasCache();

    default public boolean needsRemove() {
        return true;
    }

    public CollectionDataAccess getCacheAccessStrategy();

    public CacheEntryStructure getCacheEntryStructure();

    @Incubating
    public boolean useShallowQueryCacheLayout();

    public Class<?> getElementClass();

    public boolean isPrimitiveArray();

    public boolean isArray();

    public boolean isOneToMany();

    public boolean isManyToMany();

    public String getManyToManyFilterFragment(TableGroup var1, Map<String, Filter> var2);

    public boolean hasIndex();

    public boolean isLazy();

    public boolean isInverse();

    public void remove(Object var1, SharedSessionContractImplementor var2);

    public void recreate(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    public void deleteRows(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    public void updateRows(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    public void insertRows(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    public void processQueuedOps(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    @Deprecated
    public IdentifierGenerator getIdentifierGenerator();

    default public BeforeExecutionGenerator getGenerator() {
        return this.getIdentifierGenerator();
    }

    public boolean hasOrphanDelete();

    public boolean hasOrdering();

    public boolean hasManyToManyOrdering();

    public String[] getCollectionSpaces();

    @Deprecated(since="6.0")
    public CollectionMetadata getCollectionMetadata();

    public boolean isCascadeDeleteEnabled();

    public boolean isVersioned();

    public boolean isMutable();

    public void postInstantiate() throws MappingException;

    public SessionFactoryImplementor getFactory();

    public boolean isAffectedByEnabledFilters(SharedSessionContractImplementor var1);

    default public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        throw new UnsupportedOperationException("CollectionPersister used for [" + this.getRole() + "] does not support SQL AST");
    }

    default public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        throw new UnsupportedOperationException("CollectionPersister used for [" + this.getRole() + "] does not support SQL AST");
    }

    default public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        throw new UnsupportedOperationException("CollectionPersister used for [" + this.getRole() + "] does not support SQL AST");
    }

    default public boolean isExtraLazy() {
        return false;
    }

    public int getSize(Object var1, SharedSessionContractImplementor var2);

    public boolean indexExists(Object var1, Object var2, SharedSessionContractImplementor var3);

    public boolean elementExists(Object var1, Object var2, SharedSessionContractImplementor var3);

    public Object getElementByIndex(Object var1, Object var2, SharedSessionContractImplementor var3, Object var4);

    default public int getBatchSize() {
        return -1;
    }

    default public boolean isBatchLoadable() {
        return this.getBatchSize() > 1;
    }

    default public boolean isSubselectLoadable() {
        return false;
    }

    public String getMappedByProperty();

    public Comparator<?> getSortingComparator();

    public CollectionSemantics<?, ?> getCollectionSemantics();

    public void applyBaseManyToManyRestrictions(Consumer<Predicate> var1, TableGroup var2, boolean var3, Map<String, Filter> var4, Set<String> var5, SqlAstCreationState var6);

    @Deprecated(since="6", forRemoval=true)
    public String[] getKeyColumnAliases(String var1);

    @Deprecated(since="6", forRemoval=true)
    public String[] getIndexColumnAliases(String var1);

    @Deprecated(since="6", forRemoval=true)
    public String[] getElementColumnAliases(String var1);

    @Deprecated(since="6", forRemoval=true)
    public String getIdentifierColumnAlias(String var1);

    @Deprecated(forRemoval=true)
    public CollectionType getCollectionType();

    @Deprecated(forRemoval=true)
    public Type getKeyType();

    @Deprecated(forRemoval=true)
    public Type getIndexType();

    @Deprecated(forRemoval=true)
    public Type getElementType();

    @Deprecated(forRemoval=true)
    public Type getIdentifierType();
}

