/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.model;

import io.meeds.kudos.model.KudosPeriodType;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalSettings
implements Cloneable {
    private static final String END_PERIOD_DATE_IN_SECONDS_PARAM = "endPeriodDateInSeconds";
    private static final String START_PERIOD_DATE_IN_SECONDS_PARAM = "startPeriodDateInSeconds";
    private static final String KUDOS_PERIOD_TYPE_PARAM = "kudosPeriodType";
    private static final String KUDOS_PER_PERIOD_PARAM = "kudosPerPeriod";
    private static final String ACCESS_PERMISSION_PARAM = "accessPermission";
    String accessPermission;
    long kudosPerPeriod;
    KudosPeriodType kudosPeriodType = KudosPeriodType.DEFAULT;

    public JSONObject toJSONObject(boolean includeTransient) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.accessPermission != null) {
                jsonObject.put(ACCESS_PERMISSION_PARAM, (Object)this.accessPermission);
            }
            jsonObject.put(KUDOS_PER_PERIOD_PARAM, this.kudosPerPeriod);
            jsonObject.put(KUDOS_PERIOD_TYPE_PARAM, (Object)this.kudosPeriodType.name());
            if (includeTransient) {
                jsonObject.put(START_PERIOD_DATE_IN_SECONDS_PARAM, this.kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getStartDateInSeconds());
                jsonObject.put(END_PERIOD_DATE_IN_SECONDS_PARAM, this.kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getEndDateInSeconds());
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJSONObject(true).toString();
    }

    public String toStringToPersist() {
        return this.toJSONObject(false).toString();
    }

    public static final GlobalSettings parseStringToObject(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            GlobalSettings globalSettings = new GlobalSettings();
            globalSettings.setKudosPerPeriod(jsonObject.has(KUDOS_PER_PERIOD_PARAM) ? jsonObject.getLong(KUDOS_PER_PERIOD_PARAM) : 0L);
            globalSettings.setKudosPeriodType(jsonObject.has(KUDOS_PERIOD_TYPE_PARAM) ? KudosPeriodType.valueOf(jsonObject.getString(KUDOS_PERIOD_TYPE_PARAM).toUpperCase()) : KudosPeriodType.DEFAULT);
            return globalSettings;
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting JSON String to Object", e);
        }
    }

    public GlobalSettings clone() {
        try {
            return (GlobalSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new GlobalSettings(this.accessPermission, this.kudosPerPeriod, this.kudosPeriodType);
        }
    }

    @Generated
    public String getAccessPermission() {
        return this.accessPermission;
    }

    @Generated
    public long getKudosPerPeriod() {
        return this.kudosPerPeriod;
    }

    @Generated
    public KudosPeriodType getKudosPeriodType() {
        return this.kudosPeriodType;
    }

    @Generated
    public void setAccessPermission(String accessPermission) {
        this.accessPermission = accessPermission;
    }

    @Generated
    public void setKudosPerPeriod(long kudosPerPeriod) {
        this.kudosPerPeriod = kudosPerPeriod;
    }

    @Generated
    public void setKudosPeriodType(KudosPeriodType kudosPeriodType) {
        this.kudosPeriodType = kudosPeriodType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings other = (GlobalSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKudosPerPeriod() != other.getKudosPerPeriod()) {
            return false;
        }
        String this$accessPermission = this.getAccessPermission();
        String other$accessPermission = other.getAccessPermission();
        if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) {
            return false;
        }
        KudosPeriodType this$kudosPeriodType = this.getKudosPeriodType();
        KudosPeriodType other$kudosPeriodType = other.getKudosPeriodType();
        return !(this$kudosPeriodType == null ? other$kudosPeriodType != null : !((Object)((Object)this$kudosPeriodType)).equals((Object)other$kudosPeriodType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlobalSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kudosPerPeriod = this.getKudosPerPeriod();
        result = result * 59 + (int)($kudosPerPeriod >>> 32 ^ $kudosPerPeriod);
        String $accessPermission = this.getAccessPermission();
        result = result * 59 + ($accessPermission == null ? 43 : $accessPermission.hashCode());
        KudosPeriodType $kudosPeriodType = this.getKudosPeriodType();
        result = result * 59 + ($kudosPeriodType == null ? 43 : ((Object)((Object)$kudosPeriodType)).hashCode());
        return result;
    }

    @Generated
    public GlobalSettings() {
    }

    @Generated
    public GlobalSettings(String accessPermission, long kudosPerPeriod, KudosPeriodType kudosPeriodType) {
        this.accessPermission = accessPermission;
        this.kudosPerPeriod = kudosPerPeriod;
        this.kudosPeriodType = kudosPeriodType;
    }
}

