/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.utils.MOPUtils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;

public abstract class AbstractPageStorage
implements PageStorage {
    private static final Log LOG = ExoLogger.getLogger(AbstractPageStorage.class);
    protected ListenerService listenerService;
    protected LayoutStorage layoutStorage;
    protected SiteDAO siteDAO;
    protected PageDAO pageDAO;

    protected AbstractPageStorage(ListenerService listenerService, LayoutStorage layoutStorage, SiteDAO siteDAO, PageDAO pageDAO) {
        this.listenerService = listenerService;
        this.layoutStorage = layoutStorage;
        this.siteDAO = siteDAO;
        this.pageDAO = pageDAO;
    }

    public void save(PageData page) {
        SiteKey siteKey = new SiteKey(page.getKey().getType(), page.getKey().getId());
        org.exoplatform.portal.mop.page.PageKey mopKey = new org.exoplatform.portal.mop.page.PageKey(siteKey, page.getKey().getName());
        PageEntity dst = this.pageDAO.findByKey(mopKey);
        if (dst == null) {
            throw new NoSuchDataException("The page " + String.valueOf(page.getKey()) + " not found");
        }
        List children = page.getChildren();
        JSONArray pageBodyJson = MOPUtils.parseJsonArray(dst.getPageBody());
        List<ComponentEntity> newPageBody = this.layoutStorage.saveChildren(pageBodyJson, children);
        dst.setChildren(newPageBody);
        dst.setPageBody(((JSONArray)dst.toJSON().get((Object)"children")).toJSONString());
        this.pageDAO.update(dst);
        this.broadcastEvent("org.exoplatform.portal.mop.page.page_updated", mopKey);
    }

    public PageData getPage(PageKey key) {
        SiteKey siteKey = new SiteKey(key.getType(), key.getId());
        org.exoplatform.portal.mop.page.PageKey pageKey = new org.exoplatform.portal.mop.page.PageKey(siteKey, key.getName());
        PageEntity entity = this.pageDAO.findByKey(pageKey);
        return this.buildPageData(entity);
    }

    protected PageData buildPageData(PageEntity entity) {
        if (entity == null) {
            return null;
        }
        List<String> accessPermissions = this.layoutStorage.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<String> editPermissions = this.layoutStorage.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.EDIT);
        String editPermission = CollectionUtils.isEmpty(editPermissions) ? null : editPermissions.get(0);
        List<ComponentData> children = this.layoutStorage.buildChildren(MOPUtils.parseJsonArray(entity.getPageBody()));
        return new PageData("page_" + entity.getId(), null, entity.getName(), null, null, entity.getFactoryId(), entity.getDisplayName(), entity.getDescription(), null, null, null, entity.getProfiles(), accessPermissions, children, entity.getOwnerType().getName(), entity.getOwnerId(), editPermission, entity.isShowMaxWindow(), entity.isHideSharedLayout(), entity.getPageType() != null ? entity.getPageType().name() : null, entity.getLink());
    }

    protected void broadcastEvent(String eventName, org.exoplatform.portal.mop.page.PageKey pageKey) {
        try {
            this.listenerService.broadcast(eventName, (Object)this, (Object)pageKey);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when broadcasting notification " + eventName + " for page " + String.valueOf(pageKey)), (Throwable)e);
        }
    }
}

