/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.mop.Visibility;

public class UserNodeFilterConfig {
    public static final int AUTH_NO_CHECK = 0;
    public static final int AUTH_READ = 1;
    public static final int AUTH_READ_WRITE = 2;
    final Set<Visibility> visibility;
    final int authorizationMode;
    final boolean temporalCheck;
    String[] path;

    public UserNodeFilterConfig(Builder builder) {
        if (builder == null) {
            throw new NullPointerException();
        }
        this.visibility = Safe.unmodifiableSet(builder.withVisibility);
        this.authorizationMode = builder.withAuthorizationMode;
        this.temporalCheck = builder.withTemporalCheck;
        this.path = builder.path;
    }

    public Set<Visibility> getVisibility() {
        return this.visibility;
    }

    public int getAuthorizationMode() {
        return this.authorizationMode;
    }

    public boolean getTemporalCheck() {
        return this.temporalCheck;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserNodeFilterConfig predicate) {
        return new Builder(predicate);
    }

    public static class Builder {
        private Set<Visibility> withVisibility;
        private int withAuthorizationMode;
        private boolean withTemporalCheck;
        private String[] path;

        private Builder() {
            this.withVisibility = null;
            this.withAuthorizationMode = 0;
            this.withTemporalCheck = false;
            this.path = null;
        }

        private Builder(UserNodeFilterConfig predicate) {
            this.withVisibility = predicate.visibility;
            this.withAuthorizationMode = predicate.authorizationMode;
            this.withTemporalCheck = predicate.temporalCheck;
            this.path = predicate.path;
        }

        public Builder withVisibility(Visibility first, Visibility ... rest) {
            this.withVisibility = EnumSet.of(first, rest);
            return this;
        }

        public Builder withVisibility(Visibility first) {
            this.withVisibility = EnumSet.of(first);
            return this;
        }

        public Builder withVisibility(Visibility[] all) {
            if (all.length == 0) {
                this.withVisibility = Collections.emptySet();
            } else if (all.length == 1) {
                this.withVisibility = EnumSet.of(all[0]);
            } else {
                Visibility[] rest = new Visibility[all.length - 1];
                System.arraycopy(all, 1, rest, 0, rest.length);
                this.withVisibility = EnumSet.of(all[0], rest);
            }
            return this;
        }

        public Builder withoutVisibility() {
            this.withVisibility = null;
            return this;
        }

        public Builder withTemporalCheck() {
            this.withTemporalCheck = true;
            return this;
        }

        public Builder withoutTemporalCheck() {
            this.withTemporalCheck = false;
            return this;
        }

        public Builder withAuthMode(int withAuthorizationMode) {
            if (withAuthorizationMode < 0 || withAuthorizationMode > 2) {
                throw new IllegalArgumentException("Wrong authorization mode value");
            }
            this.withAuthorizationMode = withAuthorizationMode;
            return this;
        }

        public Builder withReadWriteCheck() {
            this.withAuthorizationMode = 2;
            return this;
        }

        public Builder withReadCheck() {
            this.withAuthorizationMode = 1;
            return this;
        }

        public Builder withNoCheck() {
            this.withAuthorizationMode = 0;
            return this;
        }

        public UserNodeFilterConfig build() {
            return new UserNodeFilterConfig(this);
        }
    }
}

