/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.model.News;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsGamificationIntegrationListener
extends Listener<String, News> {
    private static final Log LOG = ExoLogger.getLogger(NewsGamificationIntegrationListener.class);
    private String[] LISTENERS = new String[]{"exo.news.gamification.postArticle", "exo.news.gamification.PublishArticle"};
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    public static final String GAMIFICATION_POST_NEWS_ARTICLE_RULE_TITLE = "PostArticle";
    public static final String GAMIFICATION_PUBLISH_NEWS_ARTICLE_RULE_TITLE = "PublishArticle";
    String ACTIVITY_OBJECT_TYPE = "news";
    String OBJECT_ID_PARAM = "objectId";
    String OBJECT_TYPE_PARAM = "objectType";
    @Autowired
    private PortalContainer container;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        for (String listener : this.LISTENERS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<String, News> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String eventName = event.getEventName();
            News news = (News)event.getData();
            String ruleTitle = "";
            if (StringUtils.equals((CharSequence)eventName, (CharSequence)"exo.news.gamification.postArticle")) {
                ruleTitle = GAMIFICATION_POST_NEWS_ARTICLE_RULE_TITLE;
            } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"exo.news.gamification.PublishArticle")) {
                ruleTitle = GAMIFICATION_PUBLISH_NEWS_ARTICLE_RULE_TITLE;
            }
            try {
                HashMap<String, String> gamificationMap = new HashMap<String, String>();
                gamificationMap.put("ruleTitle", ruleTitle);
                gamificationMap.put("object", news.getUrl());
                gamificationMap.put("senderId", news.getAuthor());
                gamificationMap.put("receiverId", news.getAuthor());
                gamificationMap.put(this.OBJECT_ID_PARAM, news.getActivityId());
                gamificationMap.put(this.OBJECT_TYPE_PARAM, this.ACTIVITY_OBJECT_TYPE);
                this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gamificationMap, (Object)news.getId());
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast gamification event");
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

