/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.service.impl;

import io.meeds.news.filter.NewsFilter;
import io.meeds.news.model.News;
import io.meeds.news.model.NewsDraftObject;
import io.meeds.news.model.NewsLatestDraftObject;
import io.meeds.news.model.NewsPageObject;
import io.meeds.news.model.NewsPageVersionObject;
import io.meeds.news.notification.plugin.MentionInNewsNotificationPlugin;
import io.meeds.news.notification.plugin.PostNewsNotificationPlugin;
import io.meeds.news.notification.utils.NotificationConstants;
import io.meeds.news.notification.utils.NotificationUtils;
import io.meeds.news.search.NewsESSearchResult;
import io.meeds.news.search.NewsSearchConnector;
import io.meeds.news.service.NewsService;
import io.meeds.news.service.NewsTargetingService;
import io.meeds.news.utils.NewsUtils;
import io.meeds.notes.model.NotePageProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class NewsServiceImpl
implements NewsService {
    public static final String NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME = "Articles";
    private static final String HTML_AT_SYMBOL_PATTERN = "@";
    private static final String HTML_AT_SYMBOL_ESCAPED_PATTERN = "&#64;";
    public static final MetadataType NEWS_METADATA_TYPE = new MetadataType(1000L, "news");
    public static final String NEWS_METADATA_NAME = "news";
    public static final String NEWS_METADATA_DRAFT_OBJECT_TYPE = "newsDraftPage";
    public static final String PUBLISHED = "published";
    public static final String POSTED = "posted";
    public static final String DRAFT = "draft";
    public static final String STAGED = "staged";
    public static final String NEWS_AUDIENCE = "audience";
    public static final String NEWS_DELETED = "deleted";
    public static final String NEWS_ID = "newsId";
    public static final String SCHEDULE_POST_DATE = "schedulePostDate";
    public static final String NEWS_ACTIVITIES = "activities";
    public static final String NEWS_PUBLICATION_STATE = "publicationState";
    public static final String NEWS_ACTIVITY_POSTED = "activityPosted";
    public static final String NEWS_METADATA_PAGE_OBJECT_TYPE = "newsPage";
    public static final String NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE = "newsPageVersion";
    public static final String NEWS_VIEWERS = "viewers";
    public static final String NEWS_VIEWS = "viewsCount";
    public static final String NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE = "newsLatestDraftPage";
    public static final String NEWS_ATTACHMENTS_IDS = "attachmentsIds";
    public static final String ARTICLE_CONTENT = "content";
    public static final String UNPUBLISH_SCHEDULED = "unpublishScheduled";
    public static final String UNPUBLISH_SCHEDULED_DATE = "unpublishScheduledDate";
    public static final MetadataKey NEWS_METADATA_KEY = new MetadataKey(NEWS_METADATA_TYPE.getName(), "news", 0L);
    private static final Log LOG = ExoLogger.getLogger(NewsServiceImpl.class);
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private NoteService noteService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private NewsTargetingService newsTargetingService;
    @Autowired
    private IndexingService indexingService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private WikiService wikiService;
    @Autowired
    private NewsSearchConnector newsSearchConnector;

    @Override
    public News createNews(News news, Identity currentIdentity) throws Exception {
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        try {
            if (!this.canCreateNews(space, currentIdentity)) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to create news");
            }
            News createdNews = POSTED.equals(news.getPublicationState()) ? this.postNews(news, currentIdentity.getUserId()) : (news.getSchedulePostDate() != null ? this.unScheduleNews(news, space.getGroupId(), currentIdentity.getUserId()) : this.createDraftArticleForNewPage(news, space.getGroupId(), currentIdentity.getUserId(), System.currentTimeMillis()));
            return createdNews;
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return null;
        }
    }

    @Override
    public News postNews(News news, String poster) throws Exception {
        news = news.getPublicationState().equals(STAGED) || news.getSchedulePostDate() != null ? this.postScheduledArticle(news) : this.createNewsArticlePage(news, poster);
        this.postNewsActivity(news);
        this.sendNotification(poster, news, NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        if (news.isPublished()) {
            this.publishNews(news, poster);
        }
        NewsUtils.broadcastEvent("exo.news.gamification.postArticle", news.getId(), news);
        NewsUtils.broadcastEvent("exo.news.postArticle", news.getAuthor(), news);
        return news;
    }

    @Override
    public boolean canCreateNews(Space space, Identity currentIdentity) throws Exception {
        return space != null && (NewsUtils.canPublishNews(space.getId(), currentIdentity) || this.spaceService.canRedactOnSpace(space, currentIdentity));
    }

    @Override
    public News updateNews(News news, String updater, Boolean post, boolean publish, String newsObjectType, String newsUpdateType) throws Exception {
        boolean displayed;
        if (!this.canEditNews(news, updater)) {
            throw new IllegalAccessException("User " + updater + " is not authorized to update news");
        }
        Identity updaterIdentity = NewsUtils.getUserIdentity(updater);
        String newsId = news.getTargetPageId() != null ? news.getTargetPageId() : news.getId();
        News originalNews = this.getNewsById(newsId, updaterIdentity, false, newsObjectType);
        List<String> oldTargets = this.newsTargetingService.getTargetsByNews(news);
        boolean canPublish = NewsUtils.canPublishNews(news.getSpaceId(), updaterIdentity);
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        Set<String> previousMentions = NewsUtils.processMentions(originalNews.getOriginalBody(), space);
        if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
            return this.updateDraftArticleForNewPage(news, updater, space);
        }
        if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType)) {
            return this.createOrUpdateDraftArticleForExistingPage(news, updater, space);
        }
        if (NewsUtils.NewsObjectType.ARTICLE.name().equalsIgnoreCase(newsObjectType) && NewsUtils.NewsUpdateType.CONTENT_AND_TITLE.name().equalsIgnoreCase(newsUpdateType) && StringUtils.isNotEmpty((CharSequence)news.getLang())) {
            return this.addNewArticleVersionWithLang(news, updaterIdentity, space);
        }
        if (publish != news.isPublished() && news.isCanPublish()) {
            news.setPublished(publish);
            if (news.isPublished()) {
                this.publishNews(news, updater);
            } else {
                this.unpublishNews(newsId, updater);
            }
        }
        boolean bl = displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED);
        if (publish == news.isPublished() && news.isPublished() && canPublish) {
            if (!(news.getTargets() == null || oldTargets != null && oldTargets.equals(news.getTargets()))) {
                this.newsTargetingService.deleteNewsTargets(news, updater);
                this.newsTargetingService.saveNewsTarget(news, displayed, news.getTargets(), updater);
            }
            if (news.getAudience() != null && news.getAudience().equals("all") && originalNews.getAudience() != null && originalNews.getAudience().equals("space")) {
                this.sendNotification(updater, news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS);
            }
        }
        if (NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase().equals(newsObjectType)) {
            news = this.updateArticle(news, updaterIdentity, newsUpdateType);
        }
        if (POSTED.equals(news.getPublicationState())) {
            if (StringUtils.isNotEmpty((CharSequence)newsId) && news.getCreationDate() != null) {
                News newMentionedNews = news;
                if (!previousMentions.isEmpty()) {
                    previousMentions.forEach(username -> newMentionedNews.setBody(newMentionedNews.getBody().replaceAll(HTML_AT_SYMBOL_PATTERN + username, "")));
                }
                this.sendNotification(updater, newMentionedNews, NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS);
            }
            this.indexingService.reindex(NEWS_METADATA_NAME, String.valueOf(newsId));
        }
        if (!news.getPublicationState().isEmpty() && !DRAFT.equals(news.getPublicationState())) {
            if (post != null) {
                this.updateNewsActivity(news, post);
            }
            NewsUtils.broadcastEvent("exo.news.updateArticle", updater, news);
        }
        return news;
    }

    @Override
    public void deleteNews(String newsId, Identity currentIdentity, String newsObjectType) throws Exception {
        News news = this.getNewsById(newsId, currentIdentity, false, newsObjectType);
        if (!news.isCanDelete()) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to delete news");
        }
        if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
            this.deleteDraftArticle(newsId, currentIdentity.getUserId());
        } else if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType)) {
            DraftPage draft;
            Page newsArticlePage = this.noteService.getNoteById(newsId);
            if (newsArticlePage != null && (draft = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(newsArticlePage.getId())), currentIdentity.getUserId(), null)) != null) {
                this.deleteDraftArticle(draft.getId(), currentIdentity.getUserId());
            }
        } else {
            this.deleteArticle(news, currentIdentity.getUserId());
            if (news.getActivities() != null) {
                String newsActivities = news.getActivities();
                Stream.of(newsActivities.split(";")).map(activity -> activity.split(":")[1]).forEach(arg_0 -> ((ActivityManager)this.activityManager).deleteActivity(arg_0));
            }
            MetadataObject newsMetadataObject = new MetadataObject(NEWS_METADATA_NAME, newsId);
            this.metadataService.deleteMetadataItemsByObject(newsMetadataObject);
            this.indexingService.unindex(NEWS_METADATA_NAME, String.valueOf(news.getId()));
            List<String> articleLanguages = this.getArticleLanguages(newsId, false);
            if (CollectionUtils.isNotEmpty(articleLanguages)) {
                articleLanguages.forEach(lang -> this.indexingService.unindex(NEWS_METADATA_NAME, news.getId().concat("-").concat((String)lang)));
            }
            NewsUtils.broadcastEvent("exo.news.deleteArticle", currentIdentity.getUserId(), news);
        }
    }

    @Override
    public void publishNews(News newsToPublish, String publisher) throws Exception {
        Identity publisherIdentity = NewsUtils.getUserIdentity(publisher);
        News news = this.getNewsArticleById(newsToPublish.getId());
        boolean displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED);
        NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
        MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
        if (metadataItem != null) {
            HashMap<String, String> properties = metadataItem.getProperties();
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            properties.put(PUBLISHED, String.valueOf(true));
            if (StringUtils.isNotEmpty((CharSequence)newsToPublish.getAudience())) {
                properties.put(NEWS_AUDIENCE, news.getAudience());
            }
            metadataItem.setProperties(properties);
            Date updatedDate = Calendar.getInstance().getTime();
            metadataItem.setUpdatedDate(updatedDate.getTime());
            String publisherId = this.identityManager.getOrCreateUserIdentity(publisherIdentity.getUserId()).getId();
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(publisherId), false);
        }
        if (newsToPublish.getTargets() != null) {
            this.newsTargetingService.deleteNewsTargets(news, publisher);
            this.newsTargetingService.saveNewsTarget(news, displayed, newsToPublish.getTargets(), publisher);
        }
        news.setAudience(newsToPublish.getAudience());
        NewsUtils.broadcastEvent("exo.news.gamification.PublishArticle", news.getId(), news);
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        this.updateArticlePermissions(List.of(space), news);
        try {
            this.sendNotification(publisher, news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS);
        }
        catch (Error | Exception e) {
            LOG.warn((Object)("Error sending notification when publishing news with Id " + news.getId()), e);
        }
    }

    @Override
    public void unpublishNews(String newsId, String publisher) throws Exception {
        News news = this.getNewsArticleById(newsId);
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        this.newsTargetingService.deleteNewsTargets(news, publisher);
        NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
        MetadataItem newsMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
        if (newsMetadataItem != null) {
            Map properties = newsMetadataItem.getProperties();
            if (properties != null) {
                properties.put(PUBLISHED, String.valueOf(false));
                properties.put(UNPUBLISH_SCHEDULED, "false");
                properties.remove(UNPUBLISH_SCHEDULED_DATE);
                properties.remove(NEWS_AUDIENCE);
            }
            newsMetadataItem.setProperties(properties);
            Date updatedDate = Calendar.getInstance().getTime();
            newsMetadataItem.setUpdatedDate(updatedDate.getTime());
            String publisherId = this.identityManager.getOrCreateUserIdentity(publisher).getId();
            this.metadataService.updateMetadataItem(newsMetadataItem, Long.parseLong(publisherId), false);
            this.updateArticlePermissions(List.of(space), news);
        }
    }

    @Override
    public News getNewsById(String newsId, Identity currentIdentity, boolean editMode, String newsObjectType) throws IllegalAccessException {
        return this.getNewsByIdAndLang(newsId, currentIdentity, editMode, newsObjectType, null);
    }

    @Override
    public News getNewsByIdAndLang(String newsId, Identity currentIdentity, boolean editMode, String newsObjectType, String lang) throws IllegalAccessException {
        News news = null;
        try {
            if (newsObjectType == null) {
                throw new IllegalArgumentException("Required argument news object type could not be null");
            }
            if (NewsUtils.NewsObjectType.DRAFT.name().equalsIgnoreCase(newsObjectType)) {
                news = this.buildDraftArticle(newsId, currentIdentity.getUserId());
            } else if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().equalsIgnoreCase(newsObjectType)) {
                news = this.buildLatestDraftArticle(newsId, currentIdentity.getUserId(), lang);
            } else if (NewsUtils.NewsObjectType.ARTICLE.name().equalsIgnoreCase(newsObjectType)) {
                news = this.buildArticle(newsId, lang, true);
            }
        }
        catch (Exception exception) {
            LOG.error("An error occurred while retrieving news with id {}", new Object[]{newsId, exception});
        }
        if (news != null) {
            if (editMode) {
                if (!this.canEditNews(news, currentIdentity.getUserId())) {
                    throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to edit News");
                }
            } else if (!this.canViewNews(news, currentIdentity.getUserId())) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to view News");
            }
            news.setCanEdit(this.canEditNews(news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity));
            Space space = this.spaceService.getSpaceById(news.getSpaceId());
            if (space != null) {
                news.setCanSchedule(this.canScheduleNews(space, currentIdentity, news));
            }
            news.setTargets(this.newsTargetingService.getTargetsByNews(news));
            ExoSocialActivity activity = null;
            try {
                activity = this.activityManager.getActivity(news.getActivityId());
            }
            catch (Exception e) {
                LOG.debug("Error getting activity of News with id {}", new Object[]{news.getActivityId(), e});
            }
            if (activity != null) {
                RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, true);
                news.setCommentsCount(listAccess.getSize());
                news.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
            }
        }
        return news;
    }

    @Override
    public News getNewsArticleById(String newsId) {
        return this.getNewsArticleByIdAndLang(newsId, null);
    }

    @Override
    public News getNewsArticleByIdAndLang(String newsId, String lang) {
        News news = null;
        try {
            news = this.buildArticle(newsId, lang, true);
            news.setTargets(this.newsTargetingService.getTargetsByNews(news));
        }
        catch (Exception exception) {
            LOG.error("An error occurred while retrieving news with id {}", new Object[]{newsId, exception});
        }
        return news;
    }

    @Override
    public List<News> getNews(NewsFilter filter, Identity currentIdentity) throws Exception {
        List<Object> newsList = new ArrayList();
        if (filter != null) {
            newsList = StringUtils.isNotBlank((CharSequence)filter.getSearchText()) ? this.searchNews(filter, this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId())) : (filter.isPublishedNews() ? this.getPublishedArticles(filter, currentIdentity) : (filter.isDraftNews() ? this.buildDraftArticles(filter, currentIdentity) : (filter.isScheduledNews() ? this.getScheduledArticles(filter, currentIdentity) : (filter.getAuthor() != null ? this.getMyPostedArticles(filter, currentIdentity) : this.getPostedArticles(filter, currentIdentity)))));
        } else {
            throw new Exception("Unable to build query, filter is null");
        }
        newsList.stream().filter(Objects::nonNull).forEach(news -> {
            news.setCanEdit(this.canEditNews((News)news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity));
            Space space = this.spaceService.getSpaceById(news.getSpaceId());
            if (space != null) {
                news.setCanSchedule(this.canScheduleNews(space, currentIdentity, (News)news));
            }
        });
        return newsList;
    }

    @Override
    public List<News> getNewsByTargetName(NewsFilter newsFilter, String targetName, Identity currentIdentity) throws Exception {
        List<MetadataItem> newsTargetItems = this.newsTargetingService.getNewsTargetItemsByTargetName(targetName, newsFilter.getOffset(), 0L);
        return newsTargetItems.stream().filter(target -> {
            try {
                News news = this.getNewsByIdAndLang(target.getObjectId(), currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase(), newsFilter.getLang());
                return news != null && (StringUtils.isEmpty((CharSequence)news.getAudience()) || news.getAudience().equals("all") || news.isSpaceMember());
            }
            catch (Exception e) {
                return false;
            }
        }).map(target -> {
            try {
                News news = this.getNewsByIdAndLang(target.getObjectId(), currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase(), newsFilter.getLang());
                news.setPublishDate(new Date(target.getCreatedDate()));
                return news;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).limit(newsFilter.getLimit()).toList();
    }

    @Override
    public int getNewsCount(NewsFilter filter) throws Exception {
        return 0;
    }

    @Override
    public void markAsRead(News news, String userId) throws Exception {
        try {
            MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()))).get(0);
            if (metadataItem != null) {
                HashMap<String, String> properties = metadataItem.getProperties();
                if (properties == null) {
                    properties = new HashMap<String, String>();
                }
                if (properties.containsKey(NEWS_VIEWERS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWERS)))) {
                    String newsViewers = (String)properties.get(NEWS_VIEWERS);
                    String[] newsViewersArray = newsViewers.split(",");
                    boolean isUserInNewsViewers = Arrays.stream(newsViewersArray).anyMatch(userId::equals);
                    if (isUserInNewsViewers) {
                        return;
                    }
                    newsViewers = newsViewers.concat("," + userId);
                    properties.put(NEWS_VIEWERS, newsViewers);
                    if (properties.containsKey(NEWS_VIEWS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWS)))) {
                        Long newsViewsCount = Long.parseLong((String)properties.get(NEWS_VIEWS)) + 1L;
                        properties.put(NEWS_VIEWS, String.valueOf(newsViewsCount));
                    } else {
                        properties.put(NEWS_VIEWS, "1");
                    }
                } else {
                    properties.put(NEWS_VIEWERS, userId);
                    properties.put(NEWS_VIEWS, "1");
                }
                metadataItem.setProperties(properties);
                String userIdentityId = this.identityManager.getOrCreateUserIdentity(userId).getId();
                this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(userIdentityId), false);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Failed to mark news article " + news.getId() + " as read for current user"), (Throwable)exception);
            return;
        }
        NewsUtils.broadcastEvent("exo.news.viewArticle", userId, news);
    }

    @Override
    public List<News> searchNews(NewsFilter filter, org.exoplatform.social.core.identity.model.Identity currentIdentity) throws Exception {
        return this.newsSearchConnector.search(currentIdentity, filter).stream().map(articleSearchResult -> {
            try {
                return this.buildArticle(articleSearchResult.getId());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    @Override
    public News getNewsByActivityId(String activityId, Identity currentIdentity) throws IllegalAccessException, ObjectNotFoundException {
        return this.getNewsByActivityIdAndLang(activityId, currentIdentity, null);
    }

    @Override
    public News getNewsByActivityIdAndLang(String activityId, Identity currentIdentity, String lang) throws IllegalAccessException, ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        Identity viewerIdentity = NewsUtils.getUserIdentity(currentIdentity.getUserId());
        if (!this.activityManager.isActivityViewable(activity, viewerIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " isn't allowed to access activity with id " + activityId);
        }
        Map templateParams = activity.getTemplateParams();
        if (templateParams == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        String newsId = (String)templateParams.get(NEWS_ID);
        if (StringUtils.isBlank((CharSequence)newsId)) {
            String originalActivityId = (String)templateParams.get("originalActivityId");
            if (StringUtils.isNotBlank((CharSequence)originalActivityId)) {
                org.exoplatform.social.core.identity.model.Identity sharedActivityPosterIdentity = this.identityManager.getIdentity(activity.getPosterId());
                if (sharedActivityPosterIdentity == null) {
                    throw new IllegalAccessException("Shared Activity '" + activityId + "' Poster " + activity.getPosterId() + " isn't found");
                }
                return this.getNewsByActivityIdAndLang(originalActivityId, NewsUtils.getUserIdentity(sharedActivityPosterIdentity.getRemoteId()), lang);
            }
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        return this.getNewsByIdAndLang(newsId, currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase(), lang);
    }

    @Override
    public News scheduleNews(News news, Identity currentIdentity, String newsObjectType) throws Exception {
        Space space;
        Space space2 = space = news.getSpaceId() == null ? null : this.spaceService.getSpaceById(news.getSpaceId());
        if (!this.canScheduleNews(space, currentIdentity, news)) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " is not authorized to schedule news");
        }
        if (newsObjectType.equalsIgnoreCase(NewsUtils.NewsObjectType.DRAFT.name())) {
            news = this.createNewsArticlePage(news, currentIdentity.getUserId());
        } else if (newsObjectType.equalsIgnoreCase(NewsUtils.NewsObjectType.ARTICLE.name())) {
            this.updateArticle(news, currentIdentity, NewsUtils.NewsUpdateType.SCHEDULE.name().toLowerCase());
        }
        if (news != null) {
            if (NewsUtils.canPublishNews(space.getId(), currentIdentity)) {
                if (news.isPublished()) {
                    this.publishNews(news, currentIdentity.getUserId());
                } else {
                    this.unpublishNews(news.getId(), currentIdentity.getUserId());
                }
            }
            news.setUrl(NewsUtils.buildNewsArticleUrl(news, currentIdentity.getUserId()));
            news.setSpaceUrl(NewsUtils.buildSpaceUrl(news.getSpaceId()));
            return news;
        }
        return null;
    }

    @Override
    public News unScheduleNews(News news, String pageOwnerId, String articleCreator) throws Exception {
        News existingNews = this.getNewsArticleById(news.getId());
        if (existingNews != null) {
            news = this.createDraftArticleForNewPage(news, pageOwnerId, articleCreator, System.currentTimeMillis());
            this.deleteArticle(existingNews, articleCreator);
            return this.buildDraftArticle(news.getId(), articleCreator);
        }
        return null;
    }

    @Override
    public List<NewsESSearchResult> search(org.exoplatform.social.core.identity.model.Identity currentIdentity, NewsFilter filter) {
        return this.newsSearchConnector.search(currentIdentity, filter);
    }

    @Override
    public boolean canScheduleNews(Space space, Identity currentIdentity, News article) {
        boolean isArticleAuthor = article.getAuthor() != null && article.getAuthor().equals(currentIdentity.getUserId());
        boolean spaceMemberCanSchedule = isArticleAuthor && this.spaceService.isMember(space, currentIdentity.getUserId());
        return spaceMemberCanSchedule || this.spaceService.isManager(space, currentIdentity.getUserId()) || this.spaceService.isRedactor(space, currentIdentity.getUserId()) || NewsUtils.canPublishNews(space.getId(), currentIdentity);
    }

    @Override
    public boolean canViewNews(News news, String authenticatedUser) {
        try {
            Space space;
            String spaceId = news.getSpaceId();
            Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                LOG.warn("Can't find space with id {} when checking access on news with id {}", new Object[]{spaceId, news.getId()});
                return false;
            }
            if (!(news.isPublished() || !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)POSTED) || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isMember(space, authenticatedUser) || this.isMemberOfsharedInSpaces(news, authenticatedUser))) {
                return false;
            }
            if (news.isPublished() && StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)POSTED) && "space".equals(news.getAudience()) && !this.spaceService.isMember(space, authenticatedUser) && !this.isMemberOfsharedInSpaces(news, authenticatedUser)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED) && !this.canScheduleNews(space, NewsUtils.getUserIdentity(authenticatedUser), news)) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving access permission for user {} on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        return true;
    }

    @Override
    public void shareNews(News news, Space space, org.exoplatform.social.core.identity.model.Identity userIdentity, String sharedActivityId) throws Exception {
        if (!this.canViewNews(news, userIdentity.getRemoteId())) {
            throw new IllegalAccessException("User with id " + userIdentity.getRemoteId() + "doesn't have access to news");
        }
        if (sharedActivityId != null) {
            NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
            MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
            if (metadataItem == null) {
                throw new ObjectNotFoundException("News metadata object with id " + news.getId() + " wasn't found");
            }
            HashMap<String, String> properties = metadataItem.getProperties();
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            if (properties.containsKey(NEWS_ACTIVITIES)) {
                String newsActivities = (String)properties.get(NEWS_ACTIVITIES);
                newsActivities = newsActivities.concat(";").concat(space.getId()).concat(":").concat(sharedActivityId);
                properties.put(NEWS_ACTIVITIES, newsActivities);
            } else {
                properties.put(NEWS_ACTIVITIES, space.getId().concat(":").concat(sharedActivityId));
            }
            metadataItem.setProperties(properties);
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(userIdentity.getId()), false);
            this.updateArticlePermissions(List.of(space), news);
            NewsUtils.broadcastEvent("exo.news.shareArticle", userIdentity.getRemoteId(), news);
        }
    }

    @Override
    public void deleteVersionsByArticleIdAndLang(String id, String lang) throws Exception {
        News article = this.getNewsArticleById(id);
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(Long.parseLong(id)), lang);
        NewsUtils.broadcastEvent("content.remove.article.translation", article.getAuthor(), article);
        String newsTranslationId = id.concat("-").concat(lang);
        this.indexingService.unindex(NEWS_METADATA_NAME, newsTranslationId);
    }

    @Override
    public News createDraftArticleForNewPage(News draftArticle, String pageOwnerId, String draftArticleCreator, long creationDate) throws Exception {
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
        Page newsArticlesRootNotePage = null;
        if (wiki != null) {
            newsArticlesRootNotePage = this.noteService.getNoteOfNoteBookByName(WikiType.GROUP.name().toLowerCase(), pageOwnerId, NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            if (newsArticlesRootNotePage == null) {
                newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
            }
        } else {
            pageOwnerId = this.formatWikiOwnerToGroupId(pageOwnerId);
            wiki = this.wikiService.createWiki(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
            newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
        }
        if (newsArticlesRootNotePage != null) {
            DraftPage draftArticlePage = new DraftPage();
            draftArticlePage.setNewPage(true);
            draftArticlePage.setTargetPageId(null);
            draftArticlePage.setTitle(draftArticle.getTitle());
            draftArticlePage.setContent(draftArticle.getBody());
            draftArticlePage.setParentPageId(newsArticlesRootNotePage.getId());
            draftArticlePage.setAuthor(draftArticle.getAuthor());
            draftArticlePage.setProperties(draftArticle.getProperties());
            draftArticlePage = this.noteService.createDraftForNewPage(draftArticlePage, creationDate, Long.parseLong(this.identityManager.getOrCreateUserIdentity(draftArticleCreator).getId()));
            draftArticle.setProperties(draftArticlePage.getProperties());
            draftArticle.setIllustrationURL(NewsUtils.buildIllustrationUrl(draftArticle.getProperties(), draftArticlePage.getLang()));
            draftArticle.setId(draftArticlePage.getId());
            draftArticle.setCreationDate(draftArticlePage.getCreatedDate());
            draftArticle.setUpdateDate(draftArticlePage.getUpdatedDate());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(pageOwnerId);
            draftArticle.setSpaceId(draftArticleSpace.getId());
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            String draftArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(draftArticleCreator).getId();
            HashMap draftArticleMetadataItemProperties = new HashMap();
            this.metadataService.createMetadataItem((MetadataObject)draftArticleMetaDataObject, NEWS_METADATA_KEY, draftArticleMetadataItemProperties, Long.parseLong(draftArticleMetadataItemCreatorIdentityId), false);
            this.updateArticlePermissions(List.of(draftArticleSpace), draftArticle);
            return draftArticle;
        }
        return null;
    }

    @Override
    public News createNewsArticlePage(News newsArticle, String newsArticleCreator) throws Exception {
        String draftNewsId = newsArticle.getId();
        Identity poster = NewsUtils.getUserIdentity(newsArticleCreator);
        Space space = this.spaceService.getSpaceById(newsArticle.getSpaceId());
        String pageOwnerId = space.getGroupId();
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
        Page newsArticlesRootNotePage = null;
        if (wiki != null) {
            newsArticlesRootNotePage = this.noteService.getNoteOfNoteBookByName(WikiType.GROUP.name().toLowerCase(), pageOwnerId, NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            if (newsArticlesRootNotePage == null) {
                newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
            }
        } else {
            pageOwnerId = this.formatWikiOwnerToGroupId(pageOwnerId);
            wiki = this.wikiService.createWiki(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
            newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
        }
        if (newsArticlesRootNotePage != null) {
            Page newsArticlePage = new Page();
            newsArticlePage.setName(newsArticle.getName());
            newsArticlePage.setTitle(newsArticle.getTitle());
            newsArticlePage.setContent(newsArticle.getBody());
            newsArticlePage.setParentPageId(newsArticlesRootNotePage.getId());
            newsArticlePage.setAuthor(newsArticle.getAuthor());
            newsArticlePage.setLang(null);
            newsArticlePage.setProperties(newsArticle.getProperties());
            if (newsArticlePage.getProperties() == null) {
                newsArticlePage.setProperties(new NotePageProperties(Long.valueOf(draftNewsId).longValue(), null, null, true));
            }
            if ((newsArticlePage = this.noteService.createNote(wiki, newsArticlesRootNotePage.getName(), newsArticlePage, poster)) != null) {
                PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(newsArticlePage.getId())), null);
                newsArticle.setId(newsArticlePage.getId());
                newsArticle.setLang(newsArticlePage.getLang());
                newsArticle.setCreationDate(pageVersion.getCreatedDate());
                newsArticle.setProperties(newsArticlePage.getProperties());
                newsArticle.setLatestVersionId(pageVersion.getId());
                newsArticle.setIllustrationURL(NewsUtils.buildIllustrationUrl(newsArticlePage.getProperties(), newsArticle.getLang()));
                NewsPageVersionObject newsArticleVersionMetaDataObject = new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, pageVersion.getId(), null, Long.parseLong(space.getId()));
                String newsArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(newsArticleCreator).getId();
                HashMap newsArticleVersionMetadataItemProperties = new HashMap();
                this.metadataService.createMetadataItem((MetadataObject)newsArticleVersionMetaDataObject, NEWS_METADATA_KEY, newsArticleVersionMetadataItemProperties, Long.parseLong(newsArticleMetadataItemCreatorIdentityId), false);
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, newsArticlePage.getId(), null, Long.parseLong(space.getId()));
                HashMap<String, String> newsPageProperties = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((CharSequence)newsArticle.getAudience())) {
                    newsPageProperties.put(NEWS_AUDIENCE, newsArticle.getAudience());
                }
                this.setScheduleProperties(newsArticle, newsPageProperties);
                if (StringUtils.isNotEmpty((CharSequence)newsArticle.getPublicationState())) {
                    newsPageProperties.put(NEWS_PUBLICATION_STATE, newsArticle.getPublicationState());
                }
                newsPageProperties.put(NEWS_ACTIVITY_POSTED, String.valueOf(newsArticle.isActivityPosted()));
                newsPageProperties.put(PUBLISHED, String.valueOf(newsArticle.isPublished()));
                newsPageProperties.put(NEWS_DELETED, String.valueOf(newsArticlePage.isDeleted()));
                this.metadataService.createMetadataItem((MetadataObject)newsPageObject, NEWS_METADATA_KEY, newsPageProperties, Long.parseLong(newsArticleMetadataItemCreatorIdentityId), false);
                this.deleteDraftArticle(draftNewsId, poster.getUserId());
                return newsArticle;
            }
        }
        return null;
    }

    @Override
    public News createDraftForExistingPage(News draftArticle, String updater, Page targetArticlePage, long creationDate, Space space) throws Exception {
        DraftPage draftArticlePage = new DraftPage();
        draftArticlePage.setNewPage(false);
        draftArticlePage.setTargetPageId(targetArticlePage.getId());
        draftArticlePage.setTitle(draftArticle.getTitle());
        draftArticlePage.setContent(draftArticle.getBody());
        draftArticlePage.setParentPageId(targetArticlePage.getParentPageId());
        draftArticlePage.setAuthor(draftArticle.getAuthor());
        draftArticlePage.setLang(draftArticle.getLang());
        draftArticlePage.setProperties(draftArticle.getProperties());
        draftArticlePage = this.noteService.createDraftForExistPage(draftArticlePage, targetArticlePage, null, creationDate, updater);
        draftArticle.setDraftUpdateDate(draftArticlePage.getCreatedDate());
        draftArticle.setDraftUpdater(draftArticlePage.getAuthor());
        draftArticle.setTargetPageId(draftArticlePage.getTargetPageId());
        draftArticle.setProperties(draftArticlePage.getProperties());
        draftArticle.setId(draftArticlePage.getId());
        NewsLatestDraftObject latestDraftObject = new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), targetArticlePage.getId(), Long.parseLong(draftArticle.getSpaceId()));
        HashMap<String, String> draftArticleMetadataItemProperties = new HashMap<String, String>();
        draftArticleMetadataItemProperties.put(NEWS_ACTIVITY_POSTED, String.valueOf(draftArticle.isActivityPosted()));
        this.setScheduleProperties(draftArticle, draftArticleMetadataItemProperties);
        String draftArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(updater).getId();
        this.metadataService.createMetadataItem((MetadataObject)latestDraftObject, NEWS_METADATA_KEY, draftArticleMetadataItemProperties, Long.parseLong(draftArticleMetadataItemCreatorIdentityId), false);
        this.updateArticlePermissions(List.of(space), draftArticle);
        return draftArticle;
    }

    @Override
    public void deleteArticle(News news, String articleCreator) throws Exception {
        Page articlePage = this.noteService.getNoteById(news.getId());
        if (articlePage != null && !articlePage.isDeleted()) {
            NewsPageObject newsPageMetadataObject;
            MetadataItem metadataItem;
            boolean hasDraft = true;
            while (hasDraft) {
                try {
                    DraftPage latestDraftPage = this.noteService.getLatestDraftOfPage(articlePage, articleCreator);
                    if (latestDraftPage != null) {
                        this.deleteDraftArticle(latestDraftPage.getId(), articleCreator);
                        continue;
                    }
                    hasDraft = false;
                }
                catch (Exception exception) {
                    hasDraft = false;
                }
            }
            boolean isDeleted = this.noteService.deleteNote(articlePage.getWikiType(), articlePage.getWikiOwner(), articlePage.getName());
            if (isDeleted && (metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)(newsPageMetadataObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId())))).stream().findFirst().orElse(null)) != null) {
                Map properties = metadataItem.getProperties();
                properties.put(NEWS_DELETED, String.valueOf(true));
                metadataItem.setProperties(properties);
                String currentIdentityId = this.identityManager.getOrCreateUserIdentity(articleCreator).getId();
                this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(currentIdentityId), false);
            }
        }
    }

    @Override
    public void deleteDraftArticle(String draftArticleId, String draftArticleCreator) throws Exception {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, draftArticleCreator);
        if (draftArticlePage != null) {
            if (draftArticlePage.getProperties() != null && draftArticlePage.getProperties().getFeaturedImage() != null) {
                long featuredImageId = draftArticlePage.getProperties().getFeaturedImage().getId();
                String userIdentityId = this.identityManager.getOrCreateUserIdentity(draftArticleCreator).getId();
                this.noteService.removeNoteFeaturedImage(Long.valueOf(Long.parseLong(draftArticlePage.getId())), Long.valueOf(featuredImageId), null, true, Long.valueOf(Long.parseLong(userIdentityId)));
            }
            this.noteService.removeDraftById(draftArticlePage.getId());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            MetadataObject draftArticleMetaDataObject = new MetadataObject(draftArticlePage.getTargetPageId() != null ? NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE : NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), draftArticlePage.getTargetPageId(), Long.parseLong(draftArticleSpace.getId()));
            List draftArticleMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, draftArticleMetaDataObject);
            this.metadataService.deleteMetadataItem(((MetadataItem)draftArticleMetadataItems.getFirst()).getId(), false);
        }
    }

    @Override
    public List<String> getArticleLanguages(String articleId, boolean withDrafts) throws WikiException {
        return this.noteService.getPageAvailableTranslationLanguages(Long.valueOf(Long.parseLong(articleId)), withDrafts);
    }

    private News updateDraftArticleForNewPage(News draftArticle, String draftArticleUpdater, Space space) throws WikiException, IllegalAccessException {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticle.getId(), draftArticleUpdater);
        if (draftArticlePage != null) {
            draftArticlePage.setTitle(draftArticle.getTitle());
            draftArticlePage.setContent(draftArticle.getBody());
            draftArticlePage.setProperties(draftArticle.getProperties());
            DraftPage draftPage = this.noteService.updateDraftForNewPage(draftArticlePage, System.currentTimeMillis(), Long.parseLong(this.identityManager.getOrCreateUserIdentity(draftArticleUpdater).getId()));
            draftArticle.setProperties(draftPage.getProperties());
            draftArticle.setIllustrationURL(NewsUtils.buildIllustrationUrl(draftPage.getProperties(), draftArticle.getLang()));
            this.updateArticlePermissions(List.of(space), draftArticle);
            return draftArticle;
        }
        return null;
    }

    private News buildDraftArticle(String draftArticleId, String currentUserId) throws Exception {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, currentUserId);
        if (draftArticlePage != null) {
            org.exoplatform.social.core.identity.model.Identity draftUpdaterIdentity;
            News draftArticle = new News();
            draftArticle.setId(draftArticlePage.getId());
            draftArticle.setTitle(draftArticlePage.getTitle());
            draftArticle.setAuthor(draftArticlePage.getAuthor());
            draftArticle.setCreationDate(draftArticlePage.getCreatedDate());
            draftArticle.setUpdateDate(draftArticlePage.getUpdatedDate());
            draftArticle.setDraftUpdateDate(draftArticlePage.getUpdatedDate());
            draftArticle.setDraftUpdaterUserName(draftArticlePage.getAuthor());
            draftArticle.setLang(draftArticlePage.getLang());
            draftArticle.setProperties(draftArticlePage.getProperties());
            if (draftArticlePage.getProperties() != null && draftArticlePage.getProperties().getFeaturedImage() != null && draftArticlePage.getProperties().getFeaturedImage().getId() != 0L) {
                draftArticle.setIllustrationURL(NewsUtils.buildIllustrationUrl(draftArticlePage.getProperties(), draftArticlePage.getLang()));
            }
            if ((draftUpdaterIdentity = this.identityManager.getOrCreateUserIdentity(currentUserId)) != null && draftUpdaterIdentity.getProfile() != null) {
                draftArticle.setDraftUpdaterDisplayName(draftUpdaterIdentity.getProfile().getFullName());
            }
            this.processPageContent((Page)draftArticlePage, draftArticle);
            draftArticle.setPublicationState(DRAFT);
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            draftArticle.setSpaceId(draftArticleSpace.getId());
            draftArticle.setSpaceAvatarUrl(draftArticleSpace.getAvatarUrl());
            draftArticle.setSpaceDisplayName(draftArticleSpace.getDisplayName());
            boolean hiddenSpace = draftArticleSpace.getVisibility().equals("hidden") && !this.spaceService.isMember(draftArticleSpace, currentUserId) && !this.spaceService.isSuperManager(currentUserId);
            draftArticle.setHiddenSpace(hiddenSpace);
            boolean isSpaceMember = this.spaceService.isSuperManager(currentUserId) || this.spaceService.isMember(draftArticleSpace, currentUserId);
            draftArticle.setSpaceMember(isSpaceMember);
            if (StringUtils.isNotEmpty((CharSequence)draftArticleSpace.getGroupId())) {
                draftArticle.setSpaceUrl(NewsUtils.buildSpaceUrl(draftArticleSpace.getId()));
            }
            draftArticle.setUrl(NewsUtils.buildDraftUrl(draftArticlePage));
            MetadataObject draftArticleMetaDataObject = draftArticlePage.getTargetPageId() == null ? new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticle.getId(), null, Long.parseLong(draftArticleSpace.getId())) : new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftArticle.getId(), draftArticlePage.getTargetPageId(), Long.parseLong(draftArticleSpace.getId()));
            MetadataItem draftArticleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, draftArticleMetaDataObject).stream().findFirst().orElse(null);
            this.buildDraftArticleProperties(draftArticle, draftArticleMetadataItem);
            if (draftArticlePage.getTargetPageId() != null) {
                draftArticle.setPublicationDate(this.noteService.getNoteById(draftArticlePage.getTargetPageId()).getCreatedDate());
            }
            return draftArticle;
        }
        return null;
    }

    private void buildArticleProperties(News article, String currentUsername, MetadataItem metadataItem) throws Exception {
        if (metadataItem != null && !MapUtils.isEmpty((Map)metadataItem.getProperties())) {
            Map properties = metadataItem.getProperties();
            if (properties.containsKey(NEWS_ACTIVITIES) && properties.get(NEWS_ACTIVITIES) != null) {
                String[] activities = ((String)properties.get(NEWS_ACTIVITIES)).split(";");
                StringBuilder memberSpaceActivities = new StringBuilder();
                String newsActivityId = activities[0].split(":")[1];
                article.setActivityId(newsActivityId);
                memberSpaceActivities.append(activities[0]).append(";");
                ArrayList<String> sharedInSpacesList = new ArrayList<String>();
                for (int i = 1; i < activities.length; ++i) {
                    String sharedInSpaceId = activities[i].split(":")[0];
                    sharedInSpacesList.add(sharedInSpaceId);
                    Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
                    String activityId = activities[i].split(":")[1];
                    if (sharedInSpace == null || currentUsername == null || !this.spaceService.isMember(sharedInSpace, currentUsername) || !this.activityManager.isActivityExists(activityId)) continue;
                    memberSpaceActivities.append(activities[i]).append(";");
                }
                article.setActivities(memberSpaceActivities.toString());
                article.setSharedInSpacesList(sharedInSpacesList);
            }
            if (properties.containsKey(NEWS_AUDIENCE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_AUDIENCE)))) {
                article.setAudience((String)properties.get(NEWS_AUDIENCE));
            }
            if (properties.containsKey(SCHEDULE_POST_DATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(SCHEDULE_POST_DATE)))) {
                article.setSchedulePostDate((String)properties.get(SCHEDULE_POST_DATE));
            }
            if (properties.containsKey(UNPUBLISH_SCHEDULED_DATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(UNPUBLISH_SCHEDULED_DATE)))) {
                article.setScheduleUnpublishDate((String)properties.get(UNPUBLISH_SCHEDULED_DATE));
            }
            if (properties.containsKey(NEWS_PUBLICATION_STATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_PUBLICATION_STATE)))) {
                article.setPublicationState((String)properties.get(NEWS_PUBLICATION_STATE));
            }
            if (properties.containsKey(PUBLISHED) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(PUBLISHED)))) {
                article.setPublished(Boolean.parseBoolean((String)properties.get(PUBLISHED)));
            }
            if (properties.containsKey(NEWS_VIEWS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWS)))) {
                article.setViewsCount(Long.parseLong((String)properties.get(NEWS_VIEWS)));
            }
            if (properties.containsKey(NEWS_ACTIVITY_POSTED)) {
                article.setActivityPosted(Boolean.parseBoolean((String)properties.get(NEWS_ACTIVITY_POSTED)));
            } else {
                article.setActivityPosted(false);
            }
        }
    }

    private void buildDraftArticleProperties(News draftArticle, MetadataItem metadataItem) {
        if (metadataItem != null) {
            Map draftArticleMetadataItemProperties = metadataItem.getProperties();
            if (!MapUtils.isEmpty((Map)draftArticleMetadataItemProperties)) {
                if (draftArticleMetadataItemProperties.containsKey(NEWS_ACTIVITY_POSTED)) {
                    draftArticle.setActivityPosted(Boolean.parseBoolean((String)draftArticleMetadataItemProperties.get(NEWS_ACTIVITY_POSTED)));
                } else {
                    draftArticle.setActivityPosted(false);
                }
            }
            if (metadataItem.getParentObjectId() != null) {
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, metadataItem.getParentObjectId(), null, metadataItem.getSpaceId());
                MetadataItem parentMetadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
                Map properties = parentMetadataItem.getProperties();
                if (properties.containsKey(NEWS_ACTIVITIES) && properties.get(NEWS_ACTIVITIES) != null) {
                    String[] activities = ((String)properties.get(NEWS_ACTIVITIES)).split(";");
                    String newsActivityId = activities[0].split(":")[1];
                    draftArticle.setActivityId(newsActivityId);
                }
                if (properties.containsKey(NEWS_VIEWS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWS)))) {
                    draftArticle.setViewsCount(Long.parseLong((String)properties.get(NEWS_VIEWS)));
                }
                if (properties.containsKey(SCHEDULE_POST_DATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(SCHEDULE_POST_DATE)))) {
                    draftArticle.setSchedulePostDate((String)properties.get(SCHEDULE_POST_DATE));
                }
                if (properties.containsKey(UNPUBLISH_SCHEDULED_DATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(UNPUBLISH_SCHEDULED_DATE)))) {
                    draftArticle.setScheduleUnpublishDate((String)properties.get(UNPUBLISH_SCHEDULED_DATE));
                }
            }
        }
    }

    private List<News> getPublishedArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(NEWS_METADATA_NAME);
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "space", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getMyFilteredSpacesIds(currentIdentity, filter.getSpaces()));
        metadataFilter.setCombinedMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "all", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId(), filter.getLang(), true);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building published news article", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private List<News> getPostedArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(NEWS_METADATA_NAME);
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setMetadataProperties(Map.of(NEWS_PUBLICATION_STATE, POSTED, NEWS_DELETED, "false"));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getMyFilteredSpacesIds(currentIdentity, filter.getSpaces()));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setCombinedMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "all", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId(), filter.getLang(), true);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private List<News> getScheduledArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(NEWS_METADATA_NAME);
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setMetadataProperties(Map.of(NEWS_PUBLICATION_STATE, STAGED, NEWS_DELETED, "false"));
        metadataFilter.setCombinedMetadataProperties(Map.of(UNPUBLISH_SCHEDULED, "true", NEWS_DELETED, "false"));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setMetadataSpaceIds(NewsUtils.getAllowedScheduledNewsSpacesIds(currentIdentity, filter.getSpaces()));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId(), filter.getLang(), true);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private List<News> getMyPostedArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(NEWS_METADATA_NAME);
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setCreatorId(Long.valueOf(Long.parseLong(this.identityManager.getOrCreateUserIdentity(filter.getAuthor()).getId())));
        metadataFilter.setMetadataProperties(Map.of(NEWS_PUBLICATION_STATE, POSTED, NEWS_DELETED, "false"));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getMyFilteredSpacesIds(currentIdentity, filter.getSpaces()));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setCombinedMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "all", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId(), filter.getLang(), true);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private List<News> buildDraftArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(NEWS_METADATA_NAME);
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_DRAFT_OBJECT_TYPE, NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getAllowedDraftArticleSpaceIds(currentIdentity, filter.getSpaces()));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(draftArticle -> {
            try {
                News draft = this.buildDraftArticle(draftArticle.getObjectId(), currentIdentity.getUserId());
                if (draft != null && draftArticle.getParentObjectId() != null) {
                    draft.setId(draftArticle.getParentObjectId());
                }
                return draft;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("User with id " + currentIdentity.getUserId() + " not authorized to view news"), (Throwable)e);
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building new draft article", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private boolean canEditNews(News news, String authenticatedUser) {
        Space space;
        String spaceId = news.getSpaceId();
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        Identity authenticatedUserIdentity = NewsUtils.getUserIdentity(authenticatedUser);
        if (authenticatedUserIdentity == null) {
            LOG.warn("Can't find user with id {} when checking access on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        return NewsUtils.canPublishNews(news.getSpaceId(), authenticatedUserIdentity) || this.spaceService.canRedactOnSpace(space, authenticatedUserIdentity);
    }

    private boolean canDeleteNews(Identity currentIdentity, String posterId, String spaceId) {
        Space space;
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        return this.spaceService.canRedactOnSpace(space, currentIdentity);
    }

    private boolean isMemberOfsharedInSpaces(News news, String username) {
        for (String sharedInSpaceId : news.getSharedInSpacesList()) {
            Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
            if (sharedInSpace == null || !this.spaceService.isMember(sharedInSpace, username)) continue;
            return true;
        }
        return false;
    }

    private Page createNewsArticlesNoteRootPage(Wiki wiki) throws WikiException {
        if (wiki != null) {
            Page newsArticlesRootNotePage = new Page();
            newsArticlesRootNotePage.setWikiType(wiki.getType());
            newsArticlesRootNotePage.setWikiOwner(wiki.getOwner());
            newsArticlesRootNotePage.setName(NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            newsArticlesRootNotePage.setTitle(NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            Date now = Calendar.getInstance().getTime();
            newsArticlesRootNotePage.setCreatedDate(now);
            newsArticlesRootNotePage.setUpdatedDate(now);
            newsArticlesRootNotePage.setContent("");
            newsArticlesRootNotePage.setSyntax(wiki.getPreferences().getWikiPreferencesSyntax().getDefaultSyntax());
            return this.noteService.createNote(wiki, null, newsArticlesRootNotePage);
        }
        return null;
    }

    private String formatWikiOwnerToGroupId(String wikiOwner) {
        if (wikiOwner == null || ((String)wikiOwner).length() == 0) {
            return null;
        }
        if (!((String)wikiOwner).startsWith("/")) {
            wikiOwner = "/" + (String)wikiOwner;
        }
        if (((String)wikiOwner).endsWith("/")) {
            wikiOwner = ((String)wikiOwner).substring(0, ((String)wikiOwner).length() - 1);
        }
        return wikiOwner;
    }

    private void sendNotification(String currentUserId, News news, NotificationConstants.NOTIFICATION_CONTEXT context) throws Exception {
        if (news.getActivities() == null || news.getActivities().isEmpty()) {
            return;
        }
        String newsId = news.getTargetPageId() != null ? news.getTargetPageId() : news.getId();
        String contentAuthor = news.getAuthor();
        String currentUser = currentUserId != null ? currentUserId : contentAuthor;
        String activities = news.getActivities();
        String contentTitle = news.getTitle();
        String contentBody = news.getBody();
        String lastSpaceIdActivityId = activities.split(";")[activities.split(";").length - 1];
        String contentSpaceId = lastSpaceIdActivityId.split(":")[0];
        String contentActivityId = lastSpaceIdActivityId.split(":")[1];
        Space contentSpace = this.spaceService.getSpaceById(contentSpaceId);
        boolean isMember = this.spaceService.isMember(contentSpace, contentAuthor);
        if (contentSpace == null) {
            throw new NullPointerException("Cannot find a space with id " + contentSpaceId + ", it may not exist");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(contentAuthor);
        String authorAvatarUrl = LinkProviderUtils.getUserAvatarUrl((Profile)identity.getProfile());
        String activityLink = NotificationUtils.getNotificationActivityLink(contentSpace, contentActivityId, isMember);
        String contentSpaceName = contentSpace.getDisplayName();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTEXT, (Object)context).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(PostNewsNotificationPlugin.NEWS_ID, (Object)newsId);
        if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS)) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostNewsNotificationPlugin"))).execute(ctx);
            Matcher matcher = MentionInNewsNotificationPlugin.MENTION_PATTERN.matcher(contentBody);
            if (matcher.find()) {
                this.sendMentionInNewsNotification(newsId, contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, authorAvatarUrl, activityLink, contentSpaceName);
            }
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS)) {
            this.sendMentionInNewsNotification(newsId, contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, authorAvatarUrl, activityLink, contentSpaceName);
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS)) {
            if (news.getAudience() != null) {
                News originalNews = this.getNewsArticleById(news.getId());
                if (news.getAudience().equals("all") && originalNews.getAudience() != null && originalNews.getAudience().equals("space")) {
                    ctx.append(PostNewsNotificationPlugin.AUDIENCE, (Object)"excludeSpaceMembers");
                } else {
                    ctx.append(PostNewsNotificationPlugin.AUDIENCE, (Object)news.getAudience());
                }
            }
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PublishNewsNotificationPlugin"))).execute(ctx);
        }
    }

    private void updateNewsActivity(News news, boolean post) {
        ExoSocialActivity activity = this.activityManager.getActivity(news.getActivityId());
        if (activity != null) {
            if (post) {
                activity.setUpdated(Long.valueOf(System.currentTimeMillis()));
            }
            activity.isHidden(!news.isActivityPosted());
            Map<String, String> templateParams = activity.getTemplateParams() == null ? new HashMap() : activity.getTemplateParams();
            templateParams.put(NEWS_ID, news.getId());
            activity.setTemplateParams(templateParams);
            activity.setMetadataObjectId(news.getId());
            activity.setMetadataObjectType(NEWS_METADATA_NAME);
            this.activityManager.updateActivity(activity, true);
        }
    }

    private void sendMentionInNewsNotification(String newsId, String contentAuthor, String currentUser, String contentTitle, String contentBody, String contentSpaceId, String authorAvatarUrl, String activityLink, String contentSpaceName) {
        Space space = this.spaceService.getSpaceById(contentSpaceId);
        Set<String> mentionedIds = NewsUtils.processMentions(contentBody, space);
        NotificationContext mentionNotificationCtx = NotificationContextImpl.cloneInstance().append(MentionInNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(MentionInNewsNotificationPlugin.MENTIONED_IDS, mentionedIds).append(PostNewsNotificationPlugin.NEWS_ID, (Object)newsId);
        mentionNotificationCtx.getNotificationExecutor().with(mentionNotificationCtx.makeCommand(PluginKey.key((String)"MentionInNewsNotificationPlugin"))).execute(mentionNotificationCtx);
    }

    private Identity getCurrentIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null ? null : conversationState.getIdentity();
    }

    private void updateNewsActivities(String activityId, News news) throws Exception {
        if (activityId != null && !StringUtils.isEmpty((CharSequence)news.getId())) {
            Page newsPage = this.noteService.getNoteById(news.getId());
            if (newsPage != null) {
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, newsPage.getId(), null, Long.parseLong(news.getSpaceId()));
                MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
                if (metadataItem != null) {
                    HashMap<String, String> properties = metadataItem.getProperties();
                    if (properties == null) {
                        properties = new HashMap<String, String>();
                    }
                    String newsActivity = news.getSpaceId().concat(":").concat(activityId);
                    if (properties.containsKey(NEWS_ACTIVITIES)) {
                        properties.put(NEWS_ACTIVITIES, ((String)properties.get(NEWS_ACTIVITIES)).concat("; ").concat(newsActivity));
                    } else {
                        properties.put(NEWS_ACTIVITIES, newsActivity);
                    }
                    metadataItem.setProperties(properties);
                    String updaterId = this.identityManager.getOrCreateUserIdentity(news.getAuthor()).getId();
                    Date updateDate = Calendar.getInstance().getTime();
                    metadataItem.setUpdatedDate(updateDate.getTime());
                    this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(updaterId), false);
                    news.setActivities((String)properties.get(NEWS_ACTIVITIES));
                    news.setActivityId(activityId);
                }
            } else {
                throw new ObjectNotFoundException("No metadata item found for the news article page " + news.getId());
            }
        }
    }

    private void postNewsActivity(News news) throws Exception {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateUserIdentity(news.getAuthor());
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(news.getTitle());
        activity.setType(NEWS_METADATA_NAME);
        activity.setUserId(poster.getId());
        activity.isHidden(!news.isActivityPosted());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(NEWS_ID, news.getId());
        activity.setTemplateParams(templateParams);
        activity.setMetadataObjectId(news.getId());
        activity.setMetadataObjectType(NEWS_METADATA_NAME);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.updateNewsActivities(activity.getId(), news);
    }

    private News updateArticle(News news, Identity updater, String newsUpdateType) throws Exception {
        String newsId = news.getTargetPageId() != null ? news.getTargetPageId() : news.getId();
        Page existingPage = this.noteService.getNoteById(newsId);
        if (existingPage != null) {
            Map metadataItemProperties;
            Map newsPageProperties;
            if (newsUpdateType.equals(NewsUtils.NewsUpdateType.CONTENT_AND_TITLE.name())) {
                existingPage.setTitle(news.getTitle());
                existingPage.setContent(news.getBody());
            }
            existingPage.setProperties(news.getProperties());
            existingPage = this.noteService.updateNote(existingPage, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, updater);
            news.setUpdateDate(existingPage.getUpdatedDate());
            news.setUpdater(existingPage.getAuthor());
            news.setLang(existingPage.getLang());
            news.setUpdaterFullName(existingPage.getAuthorFullName());
            news.setProperties(existingPage.getProperties());
            news.setUrl(NewsUtils.buildNewsArticleUrl(news, updater.getUserId()));
            news.setIllustrationURL(NewsUtils.buildIllustrationUrl(existingPage.getProperties(), news.getLang()));
            String newsArticleUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(updater.getUserId()).getId();
            NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, newsId, null, Long.parseLong(news.getSpaceId()));
            MetadataItem existingPageMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
            if (existingPageMetadataItem != null) {
                newsPageProperties = existingPageMetadataItem.getProperties();
                if (StringUtils.isNotEmpty((CharSequence)news.getAudience())) {
                    newsPageProperties.put(NEWS_AUDIENCE, news.getAudience());
                }
                this.setScheduleProperties(news, newsPageProperties);
                if (StringUtils.isNotEmpty((CharSequence)news.getPublicationState())) {
                    newsPageProperties.put(NEWS_PUBLICATION_STATE, news.getPublicationState());
                }
            } else {
                throw new ObjectNotFoundException("No such news article metadata item exists with id " + newsId);
            }
            newsPageProperties.put(NEWS_ACTIVITY_POSTED, String.valueOf(news.isActivityPosted()));
            existingPageMetadataItem.setProperties(newsPageProperties);
            Date updateDate = Calendar.getInstance().getTime();
            existingPageMetadataItem.setUpdatedDate(updateDate.getTime());
            this.metadataService.updateMetadataItem(existingPageMetadataItem, Long.parseLong(newsArticleUpdaterIdentityId), false);
            if (newsUpdateType.equalsIgnoreCase(NewsUtils.NewsUpdateType.CONTENT_AND_TITLE.name())) {
                this.noteService.createVersionOfNote(existingPage, updater.getUserId());
                news.setLatestVersionId(this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(news.getId()), news.getLang()).getId());
                DraftPage draftPage = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(existingPage.getId())), updater.getUserId(), null);
                this.deleteDraftArticle(draftPage.getId(), updater.getUserId());
            }
            if ((metadataItemProperties = existingPageMetadataItem.getProperties()).containsKey(NEWS_ACTIVITIES) && metadataItemProperties.get(NEWS_ACTIVITIES) != null) {
                String[] articleActivities = ((String)metadataItemProperties.get(NEWS_ACTIVITIES)).split(";");
                ArrayList<Space> articleSpaces = new ArrayList<Space>();
                for (int i = 0; i < articleActivities.length; ++i) {
                    String sharedInSpaceId = articleActivities[i].split(":")[0];
                    Space space = this.spaceService.getSpaceById(sharedInSpaceId);
                    if (space == null) continue;
                    articleSpaces.add(space);
                }
                this.updateArticlePermissions(articleSpaces, news);
            }
            return news;
        }
        return null;
    }

    private News buildArticle(String newsId) throws Exception {
        return this.buildArticle(newsId, null, false);
    }

    private News buildArticle(String newsId, String lang, boolean fetchOriginal) throws Exception {
        if (StringUtils.isNumeric((CharSequence)newsId)) {
            String currentUsername;
            Page articlePage = this.noteService.getNoteById(newsId);
            Identity userIdentity = this.getCurrentIdentity();
            String string = currentUsername = userIdentity == null ? null : userIdentity.getUserId();
            if (articlePage != null) {
                org.exoplatform.social.core.identity.model.Identity identity;
                Space space = this.spaceService.getSpaceByGroupId(articlePage.getWikiOwner());
                PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(articlePage.getId())), lang);
                if (pageVersion == null && fetchOriginal) {
                    pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(articlePage.getId())), null);
                }
                News news = new News();
                news.setId(articlePage.getId());
                news.setCreationDate(articlePage.getCreatedDate());
                news.setAuthor(pageVersion.getAuthor());
                news.setUpdater(pageVersion.getAuthor());
                news.setSpaceId(space.getId());
                news.setSpaceAvatarUrl(space.getAvatarUrl());
                news.setSpaceDisplayName(space.getDisplayName());
                boolean hiddenSpace = space.getVisibility().equals("hidden") && !this.spaceService.isMember(space, currentUsername) && !this.spaceService.isSuperManager(currentUsername);
                news.setHiddenSpace(hiddenSpace);
                boolean isSpaceMember = this.spaceService.isSuperManager(currentUsername) || this.spaceService.isMember(space, currentUsername);
                news.setSpaceMember(isSpaceMember);
                if (StringUtils.isNotEmpty((CharSequence)space.getGroupId())) {
                    news.setSpaceUrl(NewsUtils.buildSpaceUrl(space.getId()));
                }
                if ((identity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor())) != null && identity.getProfile() != null) {
                    news.setAuthorDisplayName(identity.getProfile().getFullName());
                    news.setAuthorAvatarUrl(identity.getProfile().getAvatarUrl());
                }
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, articlePage.getId(), null, Long.parseLong(space.getId()));
                MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
                this.buildArticleProperties(news, currentUsername, metadataItem);
                news.setDeleted(articlePage.isDeleted());
                news.setPublicationDate(articlePage.getCreatedDate());
                news.setTitle(pageVersion.getTitle());
                this.processPageContent((Page)pageVersion, news);
                news.setUpdaterFullName(pageVersion.getAuthorFullName());
                news.setLang(pageVersion.getLang());
                news.setUpdateDate(new Date(metadataItem.getUpdatedDate()));
                news.setProperties(pageVersion.getProperties());
                news.setUrl(NewsUtils.buildNewsArticleUrl(news, currentUsername));
                news.setLatestVersionId(pageVersion.getId());
                if (news.getProperties() != null && news.getProperties().getFeaturedImage() != null && news.getProperties().getFeaturedImage().getId() != 0L) {
                    news.setIllustrationURL(NewsUtils.buildIllustrationUrl(news.getProperties(), pageVersion.getLang()));
                }
                NewsPageVersionObject newsPageVersionObject = new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, pageVersion.getId(), null, Long.parseLong(space.getId()));
                List newsPageVersionMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageVersionObject);
                return news;
            }
        }
        return null;
    }

    private News createOrUpdateDraftArticleForExistingPage(News news, String updater, Space space) throws Exception {
        String pageId = news.getTargetPageId() != null ? news.getTargetPageId() : news.getId();
        Page existingPage = this.noteService.getNoteById(pageId);
        if (existingPage == null) {
            return null;
        }
        DraftPage draftPage = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(pageId)), updater, news.getLang());
        news = draftPage == null ? this.createDraftForExistingPage(news, updater, existingPage, System.currentTimeMillis(), space) : this.updateDraftArticleForExistingPage(news, updater, existingPage, draftPage, space);
        return news;
    }

    private News updateDraftArticleForExistingPage(News news, String updater, Page page, DraftPage draftPage, Space space) {
        try {
            draftPage.setTitle(news.getTitle());
            draftPage.setContent(news.getBody());
            draftPage.setAuthor(news.getAuthor());
            draftPage.setTargetPageId(page.getId());
            draftPage.setLang(news.getLang());
            draftPage.setProperties(news.getProperties());
            draftPage = this.noteService.updateDraftForExistPage(draftPage, page, null, System.currentTimeMillis(), updater);
            news.setId(draftPage.getId());
            news.setDraftUpdateDate(draftPage.getUpdatedDate());
            news.setDraftUpdater(draftPage.getAuthor());
            news.setTargetPageId(draftPage.getTargetPageId());
            news.setProperties(draftPage.getProperties());
            news.setIllustrationURL(NewsUtils.buildIllustrationUrl(draftPage.getProperties(), news.getLang()));
            NewsLatestDraftObject latestDraftObject = new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftPage.getId(), page.getId(), Long.parseLong(news.getSpaceId()));
            MetadataItem latestDraftArticleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)latestDraftObject).stream().findFirst().orElse(null);
            if (latestDraftArticleMetadataItem != null) {
                HashMap<String, String> latestDraftArticleMetadataItemProperties = latestDraftArticleMetadataItem.getProperties();
                if (latestDraftArticleMetadataItemProperties == null) {
                    latestDraftArticleMetadataItemProperties = new HashMap<String, String>();
                }
                this.setLatestDraftProperties(latestDraftArticleMetadataItemProperties, news);
                latestDraftArticleMetadataItem.setProperties(latestDraftArticleMetadataItemProperties);
                String draftArticleMetadataItemUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(updater).getId();
                this.metadataService.updateMetadataItem(latestDraftArticleMetadataItem, Long.parseLong(draftArticleMetadataItemUpdaterIdentityId), false);
            } else {
                HashMap<String, String> latestDraftArticleMetadataItemProperties = new HashMap<String, String>();
                this.setLatestDraftProperties(latestDraftArticleMetadataItemProperties, news);
                this.metadataService.createMetadataItem((MetadataObject)latestDraftObject, NEWS_METADATA_KEY, latestDraftArticleMetadataItemProperties, false);
            }
            this.updateArticlePermissions(List.of(space), news);
        }
        catch (Exception exception) {
            return null;
        }
        return news;
    }

    private void setLatestDraftProperties(Map<String, String> properties, News news) {
        properties.put(NEWS_ACTIVITY_POSTED, String.valueOf(news.isActivityPosted()));
        this.setScheduleProperties(news, properties);
    }

    private News buildLatestDraftArticle(String parentPageId, String currentIdentityId, String lang) throws Exception {
        Page parentPage = this.noteService.getNoteById(parentPageId);
        if (parentPage == null) {
            return null;
        }
        DraftPage latestDraft = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(parentPageId)), currentIdentityId, lang);
        if (latestDraft == null) {
            return this.buildArticle(parentPageId, lang, true);
        }
        News draftArticle = this.buildDraftArticle(latestDraft.getId(), currentIdentityId);
        draftArticle.setTargetPageId(latestDraft.getTargetPageId());
        draftArticle.setLang(latestDraft.getLang());
        return draftArticle;
    }

    private void processPageContent(Page page, News news) throws Exception {
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String body = page.getContent();
        String sanitizedBody = HTMLSanitizer.sanitize((String)body);
        sanitizedBody = sanitizedBody.replaceAll(HTML_AT_SYMBOL_ESCAPED_PATTERN, HTML_AT_SYMBOL_PATTERN);
        news.setBody(MentionUtils.substituteUsernames((String)portalOwner, (String)sanitizedBody));
        news.setOriginalBody(sanitizedBody);
    }

    private String parseAndNormalizeScheduleDate(String date, String timeZoneId) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneId.of("UTC") : ZoneId.of(timeZoneId);
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(date);
        ZonedDateTime userZonedDateTime = zonedDateTime.withZoneSameInstant(userTimeZone);
        ZonedDateTime utcDateTime = userZonedDateTime.withZoneSameInstant(ZoneId.of("UTC"));
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return utcDateTime.format(outputFormatter);
    }

    private void setScheduleProperties(News news, Map<String, String> newsProperties) throws DateTimeParseException {
        String scheduledPostDate = this.parseAndNormalizeScheduleDate(news.getSchedulePostDate(), news.getTimeZoneId());
        String scheduledUnpublishDate = this.parseAndNormalizeScheduleDate(news.getScheduleUnpublishDate(), news.getTimeZoneId());
        if (scheduledPostDate != null) {
            newsProperties.put(SCHEDULE_POST_DATE, scheduledPostDate);
        } else {
            newsProperties.remove(SCHEDULE_POST_DATE);
        }
        if (scheduledUnpublishDate != null) {
            newsProperties.put(UNPUBLISH_SCHEDULED_DATE, scheduledUnpublishDate);
            newsProperties.put(UNPUBLISH_SCHEDULED, "true");
        } else {
            newsProperties.remove(UNPUBLISH_SCHEDULED_DATE);
            newsProperties.remove(UNPUBLISH_SCHEDULED);
        }
    }

    private News postScheduledArticle(News news) throws ObjectNotFoundException {
        NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
        MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
        if (metadataItem == null) {
            throw new ObjectNotFoundException("Metadata items not found for news " + news.getId());
        }
        Map properties = metadataItem.getProperties();
        if (properties != null) {
            properties.put(NEWS_PUBLICATION_STATE, POSTED);
            properties.remove(SCHEDULE_POST_DATE);
            String poster = this.identityManager.getOrCreateUserIdentity(news.getAuthor()).getId();
            Date updateDate = Calendar.getInstance().getTime();
            metadataItem.setUpdatedDate(updateDate.getTime());
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(poster), false);
            news.setSchedulePostDate(null);
            return news;
        }
        if (!news.isPublished()) {
            this.newsTargetingService.deleteNewsTargets(news);
        }
        return null;
    }

    private News addNewArticleVersionWithLang(News news, Identity versionCreator, Space space) throws Exception {
        News existingNews = this.getNewsArticleById(news.getId());
        String newsId = news.getTargetPageId() != null ? news.getTargetPageId() : news.getId();
        Page existingPage = this.noteService.getNoteById(newsId);
        if (existingPage != null) {
            existingPage.setLang(news.getLang());
            existingPage = this.noteService.updateNote(existingPage, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, versionCreator);
            news.setPublicationState(POSTED);
            MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, newsId, null, Long.parseLong(existingNews.getSpaceId()))).stream().findFirst().orElse(null);
            if (metadataItem != null) {
                Calendar calendar = Calendar.getInstance();
                metadataItem.setUpdatedDate(calendar.getTime().getTime());
                this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(this.identityManager.getOrCreateUserIdentity(versionCreator.getUserId()).getId()), false);
            }
            existingPage.setTitle(news.getTitle());
            existingPage.setContent(news.getBody());
            NotePageProperties properties = news.getProperties();
            if (properties != null) {
                properties.setDraft(false);
            }
            existingPage.setProperties(properties);
            this.noteService.createVersionOfNote(existingPage, versionCreator.getUserId());
            news.setLatestVersionId(this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(newsId), news.getLang()).getId());
            news.setIllustrationURL(NewsUtils.buildIllustrationUrl(news.getProperties(), news.getLang()));
            DraftPage draftPage = this.noteService.getLatestDraftPageByTargetPageAndLang(Long.valueOf(Long.parseLong(newsId)), news.getLang());
            if (draftPage != null) {
                this.deleteDraftArticle(draftPage.getId(), draftPage.getAuthor());
            }
            NewsUtils.broadcastEvent("content.add.article.translation", versionCreator, news);
            String newsTranslationId = news.getId().concat("-").concat(news.getLang());
            this.indexingService.index(NEWS_METADATA_NAME, newsTranslationId);
            this.updateArticlePermissions(List.of(space), news);
            return news;
        }
        return null;
    }

    private void updateArticlePermissions(List<Space> spaces, News article) {
        HashMap<String, String> updateContentPermissionEventListenerData = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(article.getSharedInSpacesList())) {
            List<Space> spaceList = article.getSharedInSpacesList().stream().map(spaceId -> {
                try {
                    return this.spaceService.getSpaceById(spaceId);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).toList();
            spaces = new ArrayList<Space>(spaces);
            spaces.addAll(spaceList);
        }
        updateContentPermissionEventListenerData.putAll(Map.of("spaces", spaces, ARTICLE_CONTENT, article.getBody()));
        String entityType = article.getPublicationState().equals(DRAFT) ? "WIKI_DRAFT_PAGES" : "WIKI_PAGE_VERSIONS";
        String entityId = entityType.equals("WIKI_DRAFT_PAGES") ? article.getId() : article.getLatestVersionId();
        updateContentPermissionEventListenerData.put("entityId", entityId);
        updateContentPermissionEventListenerData.put("entityType", entityType);
        if (article.getAudience() != null) {
            updateContentPermissionEventListenerData.put(NEWS_AUDIENCE, article.getAudience());
        }
        NewsUtils.broadcastEvent("content.update.permissions", this, updateContentPermissionEventListenerData);
    }
}

